/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.command;

import com.dev7ex.common.bukkit.command.CommandProperties;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.configuration.BasePluginConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public abstract class BukkitCommand {
    private final BukkitPlugin plugin;
    private final Map<String, BukkitCommand> subCommands = new HashMap<String, BukkitCommand>();
    private final String[] aliases = new String[0];

    public BukkitCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public boolean execute(BukkitCommand bukkitCommand, CommandSender commandSender, String[] arguments) {
        if (!this.getPermission().isBlank() && !commandSender.hasPermission(this.getPermission())) {
            commandSender.sendMessage(this.plugin.getConfiguration().getNoPermissionMessage());
            return true;
        }
        return bukkitCommand.execute(commandSender, arguments);
    }

    public void registerSubCommand(BukkitCommand bukkitCommand) {
        if (bukkitCommand.getAliases() != null && bukkitCommand.getAliases().length == 0) {
            Arrays.stream(bukkitCommand.getAliases()).forEach(aliases -> this.subCommands.put((String)aliases, bukkitCommand));
        }
        this.subCommands.put(bukkitCommand.getName(), bukkitCommand);
    }

    public Optional<BukkitCommand> getSubCommand(String name) {
        return Optional.ofNullable(this.subCommands.get(name));
    }

    public String getName() {
        return this.getClass().getAnnotation(CommandProperties.class).name();
    }

    public String getPermission() {
        return this.getClass().getAnnotation(CommandProperties.class).permission();
    }

    public <T extends BasePluginConfiguration> T getConfiguration() {
        return this.plugin.getConfiguration();
    }

    public String getPrefix() {
        return this.plugin.getConfiguration().getPrefix();
    }

    public String getNoPermissionMessage() {
        return this.plugin.getConfiguration().getNoPermissionMessage();
    }

    public BukkitPlugin getPlugin() {
        return this.plugin;
    }

    public Map<String, BukkitCommand> getSubCommands() {
        return this.subCommands;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

