/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit;

import com.dev7ex.common.bukkit.BukkitCommonConfiguration;
import com.dev7ex.common.bukkit.plugin.BukkitPlugin;
import com.dev7ex.common.bukkit.plugin.PluginProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

@PluginProperties(metricsId=17161, metrics=true)
public class BukkitCommonPlugin
extends BukkitPlugin
implements Listener {
    private BukkitCommonConfiguration configuration;
    private boolean updateAvailable = false;

    public void onLoad() {
        this.configuration = new BukkitCommonConfiguration((Plugin)this);
        this.configuration.load();
    }

    public void onEnable() {
        super.registerListener(this);
        this.checkUpdate();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handlePluginEnable(PluginEnableEvent event) {
        if (!(event.getPlugin() instanceof BukkitPlugin)) {
            return;
        }
        BukkitPlugin plugin = (BukkitPlugin)event.getPlugin();
        plugin.registerServices();
        plugin.getServiceManager().onEnable();
        plugin.registerCommands();
        plugin.registerListeners();
        if (plugin.hasMetrics()) {
            plugin.enableMetrics();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handlePluginEnable(PluginDisableEvent event) {
        if (!(event.getPlugin() instanceof BukkitPlugin)) {
            return;
        }
        BukkitPlugin plugin = (BukkitPlugin)event.getPlugin();
        plugin.getServiceManager().onDisable();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.configuration.getBoolean("settings.receive-update-message")) {
            return;
        }
        if (!this.updateAvailable) {
            return;
        }
        player.sendMessage(this.configuration.getString("settings.update-message"));
    }

    public void checkUpdate() {
        super.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + super.getResourceId()).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                String newVersion;
                String currentVersion;
                if (scanner.hasNext() && !(currentVersion = this.getDescription().getVersion()).equalsIgnoreCase(newVersion = scanner.next())) {
                    this.updateAvailable = true;
                    super.getServer().getScheduler().runTask((Plugin)this, () -> super.getLogger().info("There is a new update available."));
                }
            }
            catch (IOException exception) {
                super.getServer().getScheduler().runTask((Plugin)this, () -> super.getLogger().info("Unable to check for updates: " + exception.getMessage()));
            }
        });
    }

    public BukkitCommonConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }
}

