/*
 * Decompiled with CFR 0.152.
 */
package de.verlinkmich.ffa.listeners;

import de.verlinkmich.ffa.Main;
import de.verlinkmich.ffa.utils.ItemClass;
import de.verlinkmich.ffa.utils.LocationManager;
import de.verlinkmich.ffa.utils.Title;
import de.verlinkmich.ffa.utils.Token;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.Inventory;

public class Extra
implements Listener {
    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void onWeather(WeatherChangeEvent e) {
        if (e.toWeatherState()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        Player d = e.getEntity();
        Player k = d.getKiller();
        e.setDeathMessage(null);
        e.getDrops().clear();
        if (k instanceof Player && k != null) {
            Token.addKills(k, 1);
            Token.addToken(k, 2);
        }
    }

    @EventHandler
    public void onFood(FoodLevelChangeEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        World welt = Bukkit.getWorld((String)Main.cfg.getString("Maps.Spawn.World"));
        Location loc = new Location(welt, Main.cfg.getDouble("Maps.Spawn.X"), Main.cfg.getDouble("Maps.Spawn.Y"), Main.cfg.getDouble("Maps.Spawn.Z"));
        double yaw = Main.cfg.getDouble("Maps.Spawn.Yaw");
        double pitch = Main.cfg.getDouble("Maps.Spawn.Pitch");
        loc.setYaw((float)yaw);
        loc.setPitch((float)pitch);
        Player p = e.getPlayer();
        Player k = p.getKiller();
        e.setRespawnLocation(loc);
        if (k instanceof Player && k != null) {
            Title.sendActionBar(p, "\u00a7c" + k.getName());
            Title.sendActionBar(k, "\u00a7a" + p.getName());
        }
        ItemClass.getStandartItems(p);
    }

    @EventHandler
    public void onFall(EntityDamageEvent e) {
        Player p = (Player)e.getEntity();
        EntityDamageEvent.DamageCause damageCause = e.getCause();
        e.getCause();
        if (damageCause == EntityDamageEvent.DamageCause.FALL) {
            e.setCancelled(true);
        } else if (p.getLocation().getY() >= LocationManager.getY("Ground")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if ((e.getAction() == Action.RIGHT_CLICK_BLOCK || e.getAction() == Action.RIGHT_CLICK_AIR) && p.getItemInHand().getType() == Material.ENDER_CHEST) {
            Inventory i = Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)"\u00a77Kauf dir ein Kit");
            ItemClass.fill(i);
            i.setItem(0, ItemClass.createItemLoreTwo(Material.IRON_CHESTPLATE, 1, 0, "\u00a73Kit 1", "\u00a7620 Token"));
            i.setItem(2, ItemClass.createItemLoreTwoEnchant(Material.IRON_CHESTPLATE, 1, 0, "\u00a73Kit 2", "\u00a7650 Token", Enchantment.DURABILITY, 10));
            i.setItem(4, ItemClass.createItemLoreTwo(Material.DIAMOND_CHESTPLATE, 1, 0, "\u00a73Kit 3", "\u00a76100 Token"));
            p.openInventory(i);
            p.playSound(p.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        e.setCancelled(true);
        if (e.getClickedInventory().getName().equalsIgnoreCase("\u00a77Kauf dir ein Kit")) {
            if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase("\u00a73Kit 1")) {
                if (Token.hasTokens(p, 20)) {
                    Token.remToken(p, 20);
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aDu hast dir das einmalige Kit gekauft");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
                    Main.kit.put(p, 1);
                } else {
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7cDu hast nicht gen\u00fcgend Tokens");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.ANVIL_LAND, 1.0f, 1.0f);
                }
            } else if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase("\u00a73Kit 2")) {
                if (Token.hasTokens(p, 50)) {
                    Token.remToken(p, 50);
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aDu hast dir das einmalige Kit gekauft");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
                    Main.kit.put(p, 2);
                } else {
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7cDu hast nicht gen\u00fcgend Tokens");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.ANVIL_LAND, 1.0f, 1.0f);
                }
            } else if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase("\u00a73Kit 3")) {
                if (Token.hasTokens(p, 100)) {
                    Token.remToken(p, 100);
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aDu hast dir das einmalige Kit gekauft");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
                    Main.kit.put(p, 3);
                } else {
                    p.sendMessage(String.valueOf(Main.prefix) + "\u00a7cDu hast nicht gen\u00fcgend Tokens");
                    p.closeInventory();
                    p.playSound(p.getLocation(), Sound.ANVIL_LAND, 1.0f, 1.0f);
                }
            }
        }
    }
}

