/*
 * Decompiled with CFR 0.152.
 */
package me.ray.wgflags.language;

import me.ray.wgflags.utils.FileUtil;
import me.ray.wgflags.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public enum Language {
    PREFIX("messages.prefix", "&7[&bFlags&7]"),
    NO_PERMISSION("mesages.no_permission", "%prefix%&b You do not have permission to run this command!"),
    INVALID_CMD("messages.invalid_cmd", "%prefix%&b Type \"/fcwg\" for a list of commands"),
    INVALID_FLAG("messages.invalid_flag", "%prefix%&b Invalid flag! Type \"/fcwg flags\" for a list of flags!"),
    INVALID_REGION("messages.invalid_region", "%prefix%&b Invalid region! Type \"/regions list\" for a list of regions!"),
    COMMANDS("messages.commands", "%prefix%&b /fcwg flags : Lists the available flags\n%prefix%&b /fcwg add [region] [flag]\n%prefix%&b /fcwg remove [region] [flag]\n%prefix%&b /fcwg info [flag]"),
    CMD_FLAGS("messages.cmd_flags", "%prefix%&b - %flag%"),
    CMD_INFO("messages.cmd_info", "%prefix%&b Name: &7%flag%\n%prefix%&b Regions:"),
    CMD_INFO_REGIONS("messages.cmd_info_regions", "%prefix%&b - %region%"),
    CMD_ADD("messages.cmd_add", "%prefix%&b You've added the %flag% flag to the %region% region!"),
    CMD_REMOVE("messages.cmd_remove", "%prefix%&b You've removed the %flag% flag from the %region% region!");

    private final String path;
    private String message;

    private Language(String path, String message) {
        this.path = path;
        this.message = message;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawMessage() {
        return this.message;
    }

    public String getMessage() {
        return Utils.color(this.getRawMessage().replace("%prefix%", PREFIX.getRawMessage()));
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static void loadMessages() {
        FileConfiguration file = FileUtil.getFile("messages.yml");
        for (Language l : Language.values()) {
            if (file.getString(l.getPath()) == null) {
                file.set(l.getPath(), (Object)l.getRawMessage());
                continue;
            }
            l.setMessage(file.getString(l.getPath()));
        }
        FileUtil.saveFile(file, "messages.yml");
    }
}

