/*
 * Decompiled with CFR 0.152.
 */
package me.ray.wgflags.flags;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.ray.wgflags.WGFlags;
import org.bukkit.World;

public class FlagManager {
    private WGFlags plugin;

    public FlagManager(WGFlags plugin) {
        this.plugin = plugin;
    }

    public List<String> getRegions(String flag) {
        return this.plugin.getConfig().getStringList("flags." + flag);
    }

    public Set<String> getFlags() {
        return this.plugin.getConfig().getConfigurationSection("flags").getKeys(false);
    }

    public void add(String region, String flag) {
        List<Object> regions = this.getRegions(flag) == null ? new ArrayList() : this.getRegions(flag);
        regions.add(region);
        this.plugin.getConfig().set("flags." + flag, regions);
        this.plugin.saveConfig();
    }

    public void remove(String region, String flag) {
        List<Object> regions = this.getRegions(flag) == null ? new ArrayList() : this.getRegions(flag);
        regions.remove(region);
        this.plugin.getConfig().set("flags." + flag, regions);
        this.plugin.saveConfig();
    }

    public boolean contains(String region, String flag) {
        return this.getRegions(flag).contains(region);
    }

    public boolean isRegion(String region, World world) {
        return this.plugin.getWGPlugin().getRegionManager(world).getRegions().containsKey(region);
    }

    public boolean isFlag(String flag) {
        return this.getFlags().contains(flag);
    }
}

