/*
 * Decompiled with CFR 0.152.
 */
package me.ray.wgflags.cmd;

import java.util.Iterator;
import java.util.Set;
import me.ray.wgflags.WGFlags;
import me.ray.wgflags.language.Language;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WGFlagCmd
implements CommandExecutor {
    private WGFlags plugin;

    public WGFlagCmd(WGFlags plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String string, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("wgflags.admin")) {
            player.sendMessage(Language.NO_PERMISSION.getMessage());
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(Language.COMMANDS.getMessage());
            return true;
        }
        if (args.length == 1) {
            if (!args[0].equals("flags")) {
                player.sendMessage(Language.INVALID_CMD.getMessage());
                return false;
            }
            Set<String> flags = this.plugin.getFlagManager().getFlags();
            Iterator<String> i$ = flags.iterator();
            while (i$.hasNext()) {
                String flag = i$.next();
                player.sendMessage(Language.CMD_FLAGS.getMessage().replace("%flag%", flag));
            }
            return true;
        }
        if (args.length == 2) {
            if (!args[0].equals("info")) {
                player.sendMessage(Language.INVALID_CMD.getMessage());
                return false;
            }
            if (!this.plugin.getFlagManager().isFlag(args[1])) {
                player.sendMessage(Language.INVALID_FLAG.getMessage());
                return false;
            }
            player.sendMessage(Language.CMD_INFO.getMessage().replace("%flag%", args[1]));
            Iterator<String> i$ = this.plugin.getFlagManager().getRegions(args[1]).iterator();
            while (i$.hasNext()) {
                String region = i$.next();
                player.sendMessage(Language.CMD_INFO_REGIONS.getMessage().replace("%region%", region));
            }
            return true;
        }
        if (args.length != 3) return true;
        if (args[0].equals("add")) {
            if (!this.plugin.getFlagManager().isFlag(args[2])) {
                player.sendMessage(Language.INVALID_FLAG.getMessage());
                return false;
            }
            if (!this.plugin.getFlagManager().isRegion(args[1], player.getWorld())) {
                player.sendMessage(Language.INVALID_REGION.getMessage());
                return false;
            }
            this.plugin.getFlagManager().add(args[1], args[2]);
            player.sendMessage(Language.CMD_ADD.getMessage().replace("%flag%", args[2]).replace("%region%", args[1]));
            return true;
        }
        if (!args[0].equals("remove")) {
            player.sendMessage(Language.INVALID_CMD.getMessage());
            return false;
        }
        if (!this.plugin.getFlagManager().isFlag(args[2])) {
            player.sendMessage(Language.INVALID_FLAG.getMessage());
            return false;
        }
        if (!this.plugin.getFlagManager().isRegion(args[1], player.getWorld())) {
            player.sendMessage(Language.INVALID_REGION.getMessage());
            return false;
        }
        this.plugin.getFlagManager().remove(args[1], args[2]);
        player.sendMessage(Language.CMD_REMOVE.getMessage().replace("%flag%", args[2]).replace("%region%", args[1]));
        return true;
    }
}

