/*
 * Decompiled with CFR 0.152.
 */
package me.alexmc.epicclearlag.workloads;

import java.util.List;
import me.alexmc.epicclearlag.enums.ConfigOptions;
import me.alexmc.epicclearlag.workloads.Workload;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;

public class ChunkWorkload
implements Workload {
    private final Chunk chunk;
    private final List<EntityType> removableEntities;
    private final List<Material> removableItems;

    public ChunkWorkload(Chunk chunk, List<EntityType> removableEntities, List<Material> removableItems) {
        this.chunk = chunk;
        this.removableEntities = removableEntities;
        this.removableItems = removableItems;
    }

    @Override
    public void compute() {
        for (Entity entity : this.chunk.getEntities()) {
            if (entity.getType() == EntityType.PLAYER || ConfigOptions.IGNORE_NAMETAG.getBoolean() && entity.getCustomName() != null || ConfigOptions.IGNORE_TAMED.getBoolean() && entity instanceof Tameable) continue;
            if (entity.getType() == EntityType.DROPPED_ITEM) {
                ItemStack item = ((Item)entity).getItemStack();
                if (!this.removableItems.contains(item.getType())) continue;
                entity.remove();
            }
            if (!this.removableEntities.contains(entity.getType())) continue;
            entity.remove();
        }
    }
}

