/*
 * Decompiled with CFR 0.152.
 */
package me.alexmc.epicclearlag.tasks;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.alexmc.epicclearlag.EpicClearLag;
import me.alexmc.epicclearlag.enums.ConfigOptions;
import me.alexmc.epicclearlag.objects.PlaceHolder;
import me.alexmc.epicclearlag.utils.ListUtils;
import me.alexmc.epicclearlag.workloads.ChunkWorkload;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

public class ResetTask
implements Runnable {
    private final EpicClearLag plugin;
    private final AtomicInteger countdownTime;
    private final LoadWorkloadRunnable loadWorkloadRunnable;

    public ResetTask(EpicClearLag plugin) {
        this.plugin = plugin;
        this.countdownTime = new AtomicInteger(plugin.getConfig().getInt("reset-time"));
        this.loadWorkloadRunnable = new LoadWorkloadRunnable();
    }

    @Override
    public void run() {
        int current = this.countdownTime.decrementAndGet();
        if (this.plugin.getConfig().getIntegerList("announce-times").contains(current)) {
            Bukkit.broadcastMessage((String)ConfigOptions.CLEAR_IN.getFormattedMessage(new PlaceHolder("time", this.countdownTime + "")));
        }
        if (current <= 0) {
            Bukkit.broadcastMessage((String)ConfigOptions.CLEARING.getFormattedMessage(new PlaceHolder[0]));
            this.loadWorkloadRunnable.run();
        }
    }

    public LoadWorkloadRunnable getLoadWorkloadRunnable() {
        return this.loadWorkloadRunnable;
    }

    public class LoadWorkloadRunnable
    implements Runnable {
        @Override
        public void run() {
            List<EntityType> removableEntities = ListUtils.getRemovable(ResetTask.this.plugin, EntityType.class, "entities");
            List<Material> removableItems = ListUtils.getRemovable(ResetTask.this.plugin, Material.class, "items");
            for (World world : Bukkit.getWorlds()) {
                Chunk[] loadedChunks;
                if (world == null) continue;
                for (Chunk chunk : loadedChunks = world.getLoadedChunks()) {
                    if (chunk == null || !chunk.isLoaded() || chunk.getEntities().length == 0) continue;
                    ResetTask.this.plugin.getWorkloadThread().addWorkload(new ChunkWorkload(chunk, removableEntities, removableItems));
                }
            }
            ResetTask.this.countdownTime.set(ResetTask.this.plugin.getConfig().getInt("reset-time"));
        }
    }
}

