/*
 * Decompiled with CFR 0.152.
 */
package me.alexmc.epicclearlag.enums;

import me.alexmc.epicclearlag.EpicClearLag;
import me.alexmc.epicclearlag.objects.PlaceHolder;
import me.alexmc.epicclearlag.utils.ColorUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public enum ConfigOptions {
    CLEAR_IN("clear-in"),
    CLEARING("clearing"),
    RELOADED("reloaded"),
    NO_PERMS("no-perms"),
    NO_ARGS("no-args"),
    UNKNOWN_ARG("unknown-arg"),
    NOT_PLAYER("not-player"),
    IGNORE_NAMETAG("ignore-nametag"),
    IGNORE_TAMED("ignore-tamed"),
    SILENT_CLEAR("silent-clear");

    private final String path;
    private static final EpicClearLag plugin;

    private ConfigOptions(String path) {
        this.path = path;
    }

    public void send(CommandSender commandSender, PlaceHolder ... placeHolders) {
        commandSender.sendMessage(ColorUtils.color(this.getMessage(placeHolders)));
    }

    public String getMessage(PlaceHolder ... placeHolders) {
        String message = plugin.getConfig().getString(this.path);
        if (message == null || message.isEmpty()) {
            return "";
        }
        for (PlaceHolder placeHolder : placeHolders) {
            message = message.replace(placeHolder.getKey(), placeHolder.getValue());
        }
        return message;
    }

    public String getFormattedMessage(PlaceHolder ... placeHolders) {
        return ColorUtils.color(this.getMessage(placeHolders));
    }

    public boolean getBoolean() {
        return plugin.getConfig().getBoolean(this.path);
    }

    static {
        plugin = (EpicClearLag)JavaPlugin.getPlugin(EpicClearLag.class);
    }
}

