/*
 * Decompiled with CFR 0.152.
 */
package me.alexmc.epicclearlag.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.alexmc.epicclearlag.EpicClearLag;
import me.alexmc.epicclearlag.commands.subcommands.ClearSubCommand;
import me.alexmc.epicclearlag.commands.subcommands.ReloadSubCommand;
import me.alexmc.epicclearlag.commands.subcommands.SubCommand;
import me.alexmc.epicclearlag.enums.ConfigOptions;
import me.alexmc.epicclearlag.objects.PlaceHolder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class ClearLagCommand
implements TabExecutor {
    private final Map<String, SubCommand> subCommandMap = Maps.newHashMap();

    public ClearLagCommand(EpicClearLag plugin) {
        this.subCommandMap.put("reload", new ReloadSubCommand(plugin));
        this.subCommandMap.put("clear", new ClearSubCommand(plugin));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            ConfigOptions.NO_ARGS.send(sender, new PlaceHolder[0]);
            return true;
        }
        Optional<SubCommand> subCommandOptional = Optional.ofNullable(this.subCommandMap.get(args[0].toLowerCase()));
        if (!subCommandOptional.isPresent()) {
            ConfigOptions.UNKNOWN_ARG.send(sender, new PlaceHolder[0]);
            return true;
        }
        SubCommand subCommand = subCommandOptional.get();
        if (!sender.hasPermission(subCommand.getPermission())) {
            ConfigOptions.NO_PERMS.send(sender, new PlaceHolder[0]);
            return true;
        }
        if (subCommand.isPlayerOnly() && !(sender instanceof Player)) {
            ConfigOptions.NOT_PLAYER.send(sender, new PlaceHolder[0]);
            return true;
        }
        subCommand.perform(sender, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList completions = Lists.newArrayList();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], this.subCommandMap.keySet(), (Collection)completions);
            return completions;
        }
        return null;
    }
}

