/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.util;

import java.util.ArrayList;
import java.util.List;
import me.leoko.advancedban.manager.PunishmentManager;
import me.leoko.advancedban.manager.UUIDManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.settings.Settings;
import sk.adonikeoffice.epicchat.task.QuestionTask;

public final class Util {
    private static final Util instance = new Util();
    private int lastMessageTime = 0;

    public static void sendType(Player player, String message, boolean runnable) {
        if ((message = Variables.replace(message, (CommandSender)player)).contains("{prefix}")) {
            message = message.replace("{prefix}", Settings.PLUGIN_PREFIX);
        }
        String actionBarType = MessageType.ACTIONBAR.getType();
        String chatType = MessageType.CHAT.getType();
        String titleType = MessageType.TITLE.getType();
        if (message.startsWith(actionBarType)) {
            String replacedActionbarMessage = message.replace(actionBarType, "");
            if (runnable) {
                Common.runTimerAsync(20, () -> {
                    if (QuestionTask.questionIsRunning()) {
                        Remain.sendActionBar(player, replacedActionbarMessage);
                    }
                });
                QuestionTask.breakCycle = true;
            } else {
                Remain.sendActionBar(player, replacedActionbarMessage);
            }
        } else if (message.startsWith(chatType)) {
            if (runnable) {
                QuestionTask.breakCycle = true;
            }
            if (message.startsWith("<center>")) {
                message = message.replace("<center>", "");
                message = ChatUtil.center(message);
            }
            Common.tellNoPrefix((CommandSender)player, message.replace(chatType, ""));
        } else if (message.startsWith(titleType)) {
            String[] split;
            if (runnable) {
                QuestionTask.breakCycle = true;
            }
            if ((split = message.split("\\|")).length == 2) {
                Remain.sendTitle(player, split[0].replace(titleType, ""), split[1]);
            } else {
                Common.log("Invalid title message: " + message + ". Valid: " + titleType + "<title>|<subtitle>");
            }
        } else {
            Common.log("Unknown message type. Available: " + actionBarType + ", " + chatType + ", " + titleType);
        }
    }

    public static boolean hasPermission(Player player, String permission) {
        if (permission.equals("none")) {
            return true;
        }
        return player.hasPermission(permission) || player.isOp();
    }

    public static boolean canChat(Player player) {
        if (Util.isMuted(player)) {
            Common.tell((CommandSender)player, Settings.Message.MUTED);
            return false;
        }
        if (!HookManager.isLogged(player)) {
            Common.tell((CommandSender)player, Settings.Message.NOT_LOGGED);
            return false;
        }
        if (!Util.hasPermission(player, Settings.Chat.PERMISSION)) {
            Common.tell((CommandSender)player, Settings.Message.NO_PERMISSION.replace("{0}", Settings.Chat.PERMISSION));
            return false;
        }
        return true;
    }

    private static boolean isMuted(Player player) {
        if (Common.doesPluginExist("AdvancedBan") && PunishmentManager.get().isMuted(UUIDManager.get().getUUID(player.getName()))) {
            return true;
        }
        return HookManager.isMuted(player);
    }

    public static List<String> replaceVariables(Player player, List<String> list) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String item : list) {
            replaced.add(Variables.replace(item, (CommandSender)player));
        }
        return replaced;
    }

    public static Util getInstance() {
        return instance;
    }

    public int getLastMessageTime() {
        return this.lastMessageTime;
    }

    public void setLastMessageTime(int lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
    }

    private static enum MessageType {
        ACTIONBAR("{actionbar}"),
        CHAT("{chat}"),
        TITLE("{title}");

        private final String type;

        private MessageType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

