/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.task;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import sk.adonikeoffice.epicchat.data.AnnouncementData;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.settings.Settings;
import sk.adonikeoffice.epicchat.util.Util;

public class AnnouncementTask
extends BukkitRunnable {
    private int time;

    public void run() {
        if ((long)this.time == Settings.Chat.Announcement.REPEAT_EVERY.getTimeSeconds()) {
            AnnouncementData announcement = RandomUtil.nextItem(Settings.Chat.Announcement.ANNOUNCEMENTS);
            for (Player player : Remain.getOnlinePlayers()) {
                CompSound sound;
                boolean has = Util.hasPermission(player, announcement.getPermission());
                if (!has) continue;
                List<String> chatMessages = announcement.getChatMessage();
                for (String chatMessage : chatMessages) {
                    if (chatMessage.startsWith("<center>")) {
                        chatMessage = chatMessage.replace("<center>", "");
                        chatMessage = ChatUtil.center(chatMessage);
                    }
                    Common.tellNoPrefix((CommandSender)player, chatMessage);
                }
                CompSound compSound = sound = announcement.getSound() != null ? announcement.getSound() : null;
                if (sound != null) {
                    sound.play((Entity)player);
                }
                this.time = 0;
            }
        }
        for (Player player : Remain.getOnlinePlayers()) {
            if (!player.isOnline()) continue;
            ++this.time;
        }
    }
}

