/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.settings;

import java.util.List;
import java.util.Set;
import sk.adonikeoffice.epicchat.data.AnnouncementData;
import sk.adonikeoffice.epicchat.data.EmojiData;
import sk.adonikeoffice.epicchat.data.GroupData;
import sk.adonikeoffice.epicchat.data.QuestionData;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public final class Settings
extends SimpleSettings {
    @Override
    protected int getConfigVersion() {
        return 1;
    }

    public static class Message {
        public static String NO_CONSOLE;
        public static String NO_PERMISSION;
        public static String INVALID_ARGS;
        public static String MUTED;
        public static String NOT_LOGGED;

        private static void init() {
            Settings.setPathPrefix("Message");
            NO_CONSOLE = Settings.getString("No_Console");
            NO_PERMISSION = Settings.getString("No_Permission");
            INVALID_ARGS = Settings.getString("Invalid_Args");
            MUTED = Settings.getString("Muted");
            NOT_LOGGED = Settings.getString("Not_Logged");
        }

        public static class Question {
            public static String GUESSED;
            public static String INACTIVE_CANCEL;

            private static void init() {
                Settings.setPathPrefix("Message.Question_Message");
                GUESSED = Settings.getString("Guessed");
                INACTIVE_CANCEL = Settings.getString("Inactive_Cancel");
            }
        }
    }

    public static class Command {

        public static class Reload {
            public static String PERMISSION;

            private static void init() {
                Settings.setPathPrefix("Command.Reload");
                PERMISSION = Settings.getString("Permission");
            }
        }
    }

    public static class Chat {
        public static Boolean ENABLED;
        public static List<String> ALIASES;
        public static String PERMISSION;
        public static String PERMISSION_COLOR;
        public static Boolean LOG_ENABLED;
        public static String FORMAT;
        public static CompChatColor MESSAGE_COLOR;
        public static Set<GroupData> GROUP_FORMAT;
        public static List<String> HOVER;
        public static String HOVER_CLICK_COMMAND;

        private static void init() {
            Settings.setPathPrefix("Chat");
            ENABLED = Settings.getBoolean("Enabled");
            ALIASES = Settings.getStringList("Aliases");
            PERMISSION = Settings.getString("Permission");
            PERMISSION_COLOR = Settings.getString("Permission_Color");
            LOG_ENABLED = Settings.getBoolean("Log_Enabled");
            FORMAT = Settings.getString("Format");
            MESSAGE_COLOR = (CompChatColor)Settings.get("Message_Color", CompChatColor.class);
            GROUP_FORMAT = Settings.getSet("Group_Format", GroupData.class);
            HOVER = Settings.getStringList("Hover");
            HOVER_CLICK_COMMAND = Settings.getString("Hover_Click_Command");
        }

        public static class Announcement {
            public static Boolean ENABLED;
            public static SimpleTime REPEAT_EVERY;
            public static Set<AnnouncementData> ANNOUNCEMENTS;

            private static void init() {
                Settings.setPathPrefix("Chat.Announcement");
                ENABLED = Settings.getBoolean("Enabled");
                REPEAT_EVERY = Settings.getTime("Repeat_Every");
                ANNOUNCEMENTS = Settings.getSet("Announcements", AnnouncementData.class);
            }
        }

        public static class Question {
            public static Boolean ENABLED;
            public static SimpleTime REPEAT_EVERY;
            public static SimpleTime INACTIVE_CANCEL;
            public static Set<QuestionData> QUESTIONS;
            public static Set<String> REWARDS;

            private static void init() {
                Settings.setPathPrefix("Chat.Question");
                ENABLED = Settings.getBoolean("Enabled");
                REPEAT_EVERY = Settings.getTime("Repeat_Every");
                INACTIVE_CANCEL = Settings.getTime("Inactive_Cancel");
                QUESTIONS = Settings.getSet("Questions", QuestionData.class);
                REWARDS = Settings.getSet("Rewards", String.class);
            }
        }

        public static class Cooldown {
            public static Boolean ENABLED;
            public static String PERMISSION;
            public static String MESSAGE;
            public static Integer DELAY;

            private static void init() {
                Settings.setPathPrefix("Chat.Cooldown");
                ENABLED = Settings.getBoolean("Enabled");
                PERMISSION = Settings.getString("Permission");
                MESSAGE = Settings.getString("Message");
                DELAY = Settings.getInteger("Delay_Seconds");
            }
        }

        public static class Mention {
            public static Boolean ENABLED;
            public static String MESSAGE;
            public static String COLOR;
            public static CompSound SOUND;

            private static void init() {
                Settings.setPathPrefix("Chat.Mention");
                ENABLED = Settings.getBoolean("Enabled");
                MESSAGE = Settings.getString("Message");
                COLOR = Settings.getString("Color");
                SOUND = (CompSound)((Object)Settings.get("Sound", CompSound.class));
            }
        }

        public static class Emoji {
            public static Boolean ENABLED;
            public static CompChatColor COLOR;
            public static Set<EmojiData> EMOJIS;

            private static void init() {
                Settings.setPathPrefix("Chat.Emoji");
                ENABLED = Settings.getBoolean("Enabled");
                COLOR = (CompChatColor)Settings.get("Color", CompChatColor.class);
                EMOJIS = Settings.getSet("Emojis", EmojiData.class);
            }
        }
    }
}

