/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.listener;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import sk.adonikeoffice.epicchat.data.EmojiData;
import sk.adonikeoffice.epicchat.data.GroupData;
import sk.adonikeoffice.epicchat.data.PlayerData;
import sk.adonikeoffice.epicchat.data.QuestionData;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.settings.Settings;
import sk.adonikeoffice.epicchat.task.QuestionTask;
import sk.adonikeoffice.epicchat.util.Util;

public final class ChatListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PlayerData.isLoaded(player)) {
            PlayerData.createPlayer(player.getName());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onChat(AsyncPlayerChatEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (Settings.Chat.Cooldown.ENABLED.booleanValue() && !Util.hasPermission(player, Settings.Chat.Cooldown.PERMISSION)) {
            int messageDelay;
            int lastMessageTime;
            long now = System.currentTimeMillis() / 1000L;
            if (now - (long)(lastMessageTime = Util.getInstance().getLastMessageTime()) < (long)(messageDelay = Settings.Chat.Cooldown.DELAY.intValue())) {
                long time = (long)messageDelay - (now - (long)lastMessageTime);
                String replacedMessage = Replacer.replaceArray(Settings.Chat.Cooldown.MESSAGE, "time", time, "time_plural", Common.plural(time, "second"));
                Util.sendType(player, replacedMessage, false);
                return;
            }
            Util.getInstance().setLastMessageTime(Math.toIntExact(now));
        }
        if (Util.canChat(player)) {
            CompChatColor messageColor;
            int thisIndex;
            if (Settings.Chat.Question.ENABLED.booleanValue()) {
                QuestionData question = QuestionTask.getQuestion();
                if (QuestionTask.questionIsRunning() && message.toLowerCase().contains(question.getAnswer().toLowerCase())) {
                    String string = Replacer.replaceArray(Settings.Message.Question.GUESSED, "0", player.getName(), "1", question.getAnswer());
                    Common.runLater(2, () -> {
                        CompSound sound;
                        Common.broadcast(replacedMessage);
                        PlayerData.findPlayer(player).increaseReactedTimes();
                        for (String reward : Settings.Chat.Question.REWARDS) {
                            Common.dispatchCommand((CommandSender)player, reward);
                        }
                        CompSound compSound = sound = question.getSound() != null ? question.getSound() : null;
                        if (sound != null) {
                            sound.play((Entity)player);
                        }
                    });
                    QuestionTask.stopQuestion();
                    return;
                }
            }
            if (Settings.Chat.Mention.ENABLED.booleanValue()) {
                for (Player player2 : Remain.getOnlinePlayers()) {
                    String mentionColor;
                    String targetName = player2.getName();
                    thisIndex = message.indexOf(targetName);
                    if (thisIndex == -1) continue;
                    messageColor = Settings.Chat.MESSAGE_COLOR;
                    if (HookManager.isVaultLoaded()) {
                        for (GroupData group : Settings.Chat.GROUP_FORMAT) {
                            if (!HookManager.getPlayerPermissionGroup(player).equals(group.getName())) continue;
                            messageColor = group.getMessageColor();
                        }
                    }
                    if ((mentionColor = Settings.Chat.Mention.COLOR).startsWith("&") || mentionColor.startsWith("#") || mentionColor.startsWith("{#")) {
                        message = message.replace(targetName, Settings.Chat.Mention.COLOR + targetName + (messageColor != null ? messageColor : "&f"));
                    } else {
                        Common.log("Mention Color in the settings.yml must start with a color. (&, #, {#)");
                    }
                    Util.sendType(player2, Settings.Chat.Mention.MESSAGE.replace("{target_name}", player.getName()), false);
                    Settings.Chat.Mention.SOUND.play((Entity)player2);
                }
            }
            if (Settings.Chat.Emoji.ENABLED.booleanValue()) {
                for (EmojiData emojiData : Settings.Chat.Emoji.EMOJIS) {
                    String emojiToReplace = emojiData.getWhatToReplace();
                    thisIndex = message.indexOf(emojiToReplace);
                    if (thisIndex == -1) continue;
                    messageColor = Settings.Chat.MESSAGE_COLOR;
                    if (HookManager.isVaultLoaded()) {
                        for (GroupData group : Settings.Chat.GROUP_FORMAT) {
                            if (!HookManager.getPlayerPermissionGroup(player).equals(group.getName())) continue;
                            messageColor = group.getMessageColor();
                        }
                    }
                    message = message.replace(emojiToReplace, Settings.Chat.Emoji.COLOR + emojiData.getReplaceTo() + (messageColor != null ? messageColor : "&f"));
                }
            }
            this.chat(player, message);
        }
    }

    private void chat(Player player, String message) {
        String format = Variables.replace(Settings.Chat.FORMAT, (CommandSender)player);
        CompChatColor messageColor = Settings.Chat.MESSAGE_COLOR;
        if (HookManager.isVaultLoaded()) {
            for (GroupData group : Settings.Chat.GROUP_FORMAT) {
                if (!HookManager.getPlayerPermissionGroup(player).equals(group.getName())) continue;
                format = group.getFormat() != null ? Variables.replace(group.getFormat(), (CommandSender)player) : format;
                messageColor = group.getMessageColor() != null ? group.getMessageColor() : messageColor;
            }
        }
        boolean hasColorPermission = Util.hasPermission(player, Settings.Chat.PERMISSION_COLOR);
        String formattedMessage = Replacer.replaceArray(format, "message", hasColorPermission ? messageColor + message : messageColor + Common.stripColors(message));
        this.sendMessage(player, formattedMessage);
    }

    private void sendMessage(Player player, String message) {
        SimpleComponent chatComponent = SimpleComponent.of(message);
        List<String> hoverMessages = Settings.Chat.HOVER;
        hoverMessages = Util.replaceVariables(player, hoverMessages);
        chatComponent.onHover(hoverMessages);
        chatComponent.onClickSuggestCmd(Settings.Chat.HOVER_CLICK_COMMAND.replace("{0}", player.getName()));
        for (Player player2 : Remain.getOnlinePlayers()) {
            chatComponent.send((CommandSender[])new Player[]{player2});
        }
        if (Settings.Chat.LOG_ENABLED.booleanValue()) {
            Common.log(message);
        }
    }
}

