/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.visual;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.BlockUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.region.Region;
import sk.adonikeoffice.epicchat.lib.remain.CompParticle;

public final class VisualizedRegion
extends Region {
    @Deprecated
    public static final VisualizedRegion EMPTY = null;
    private final StrictMap<Player, Color> viewers = new StrictMap();
    private BukkitTask task;
    private CompParticle particle = CompParticle.VILLAGER_HAPPY;
    private int delayTicks = 23;

    public VisualizedRegion() {
        this(null, null);
    }

    public VisualizedRegion(Location primary, Location secondary) {
        super(primary, secondary);
    }

    public VisualizedRegion(String name, Location primary, Location secondary) {
        super(name, primary, secondary);
    }

    public void showParticles(Player player, int durationTicks) {
        this.showParticles(player, null, durationTicks);
    }

    public void showParticles(Player player, @Nullable Color color, int durationTicks) {
        this.showParticles(player, color);
        Common.runLater(durationTicks, () -> {
            if (this.canSeeParticles(player)) {
                this.hideParticles(player);
            }
        });
    }

    public void showParticles(Player player) {
        this.showParticles(player, null);
    }

    public void showParticles(Player player, @Nullable Color color) {
        Valid.checkBoolean(!this.canSeeParticles(player), "Player " + player.getName() + " already sees region " + this, new Object[0]);
        Valid.checkBoolean(this.isWhole(), "Cannot show particles of an incomplete region " + this, new Object[0]);
        this.viewers.put(player, color);
        if (this.task == null) {
            this.startVisualizing();
        }
    }

    public void hideParticles(Player player) {
        Valid.checkBoolean(this.canSeeParticles(player), "Player " + player.getName() + " is not seeing region " + this, new Object[0]);
        this.viewers.removeWeak(player);
        if (this.viewers.isEmpty() && this.task != null) {
            this.stopVisualizing();
        }
    }

    public boolean canSeeParticles(Player player) {
        return this.viewers.containsKey(player);
    }

    private void startVisualizing() {
        Valid.checkBoolean(this.task == null, "Already visualizing region " + this + "!", new Object[0]);
        Valid.checkBoolean(this.isWhole(), "Cannot visualize incomplete region " + this + "!", new Object[0]);
        this.task = Common.runTimer(this.delayTicks, (Runnable)new BukkitRunnable(){

            public void run() {
                if (VisualizedRegion.this.viewers.isEmpty()) {
                    VisualizedRegion.this.stopVisualizing();
                    return;
                }
                Set<Location> blocks = BlockUtil.getBoundingBox(VisualizedRegion.this.getPrimary(), VisualizedRegion.this.getSecondary());
                for (Location location : blocks) {
                    for (Map.Entry entry : VisualizedRegion.this.viewers.entrySet()) {
                        Player viewer = (Player)entry.getKey();
                        Color color = (Color)entry.getValue();
                        Location viewerLocation = viewer.getLocation();
                        if (!viewerLocation.getWorld().equals((Object)location.getWorld()) || !(viewerLocation.distance(location) < 100.0)) continue;
                        if (color != null) {
                            CompParticle.REDSTONE.spawn(viewer, location, color, 0.5f);
                            continue;
                        }
                        VisualizedRegion.this.particle.spawn(viewer, location);
                    }
                }
            }
        });
    }

    private void stopVisualizing() {
        Valid.checkNotNull(this.task, "Region " + this + " not visualized");
        this.task.cancel();
        this.task = null;
        this.viewers.clear();
    }

    public static VisualizedRegion deserialize(SerializedMap map) {
        if (map.isEmpty()) {
            return new VisualizedRegion();
        }
        Valid.checkBoolean(map.containsKey("Primary") && map.containsKey("Secondary"), "The region must have Primary and a Secondary location", new Object[0]);
        String name = map.getString("Name");
        Location prim = map.getLocation("Primary");
        Location sec = map.getLocation("Secondary");
        return new VisualizedRegion(name, prim, sec);
    }

    public CompParticle getParticle() {
        return this.particle;
    }

    public void setParticle(CompParticle particle) {
        this.particle = particle;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public void setDelayTicks(int delayTicks) {
        this.delayTicks = delayTicks;
    }
}

