/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.visual;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.menu.tool.BlockTool;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.visual.BlockVisualizer;
import sk.adonikeoffice.epicchat.lib.visual.VisualizedRegion;

public abstract class VisualTool
extends BlockTool {
    @Override
    protected final void onBlockClick(Player player, ClickType click, Block block) {
        this.stopVisualizing(player);
        this.handleBlockClick(player, click, block);
        this.visualize(player);
    }

    protected void handleBlockClick(Player player, ClickType click, Block block) {
        boolean isPrimary = click == ClickType.LEFT;
        Location location = block.getLocation();
        VisualizedRegion region = this.getVisualizedRegion(player);
        if (region != null) {
            if (!isPrimary && region.hasPrimary() && region.isPrimary(location)) {
                region.setPrimary(null);
            }
            if (isPrimary && region.hasSecondary() && region.isSecondary(location)) {
                region.setSecondary(null);
            }
            boolean removed = !region.toggleLocation(location, click);
            Messenger.success((CommandSender)player, (isPrimary ? "&cPrimary" : "&6Secondary") + " &7location has been " + (removed ? "&cremoved" : "&2set") + "&7.");
        }
    }

    @Override
    protected final void onAirClick(Player player, ClickType click) {
        this.stopVisualizing(player);
        this.handleAirClick(player, click);
        this.visualize(player);
    }

    protected void handleAirClick(Player player, ClickType click) {
    }

    @Override
    protected void onHotbarFocused(Player player) {
        this.visualize(player);
    }

    @Override
    protected void onHotbarDefocused(Player player) {
        this.stopVisualizing(player);
    }

    protected List<Location> getVisualizedPoints(Player player) {
        VisualizedRegion region = this.getVisualizedRegion(player);
        ArrayList<Location> points = new ArrayList<Location>();
        if (region != null) {
            if (region.hasPrimary()) {
                points.add(region.getPrimary());
            }
            if (region.hasSecondary()) {
                points.add(region.getSecondary());
            }
        }
        return points;
    }

    protected VisualizedRegion getVisualizedRegion(Player player) {
        return null;
    }

    protected String getBlockName(Block block, Player player) {
        VisualizedRegion region = this.getVisualizedRegion(player);
        String name = "&7Point";
        if (region != null) {
            Location location = block.getLocation();
            name = region.isPrimary(location) ? "&cPrimary" : (region.isSecondary(location) ? "&6Secondary" : name);
        }
        return "&8[" + name + "&8]";
    }

    protected abstract CompMaterial getBlockMask(Block var1, Player var2);

    protected final String[] getItemLore() {
        return new String[]{"", "&6&l<- &7(left) Primary", "Secondary (right) &6&l->", "", "Click a block to set."};
    }

    @Override
    protected boolean autoCancel() {
        return true;
    }

    private void visualize(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        VisualizedRegion region = this.getVisualizedRegion(player);
        if (region != null && region.isWhole() && !region.canSeeParticles(player)) {
            region.showParticles(player);
        }
        for (Location location : this.getVisualizedPoints(player)) {
            Block block;
            if (location == null || BlockVisualizer.isVisualized(block = location.getBlock())) continue;
            BlockVisualizer.visualize(block, this.getBlockMask(block, player), this.getBlockName(block, player));
        }
    }

    private void stopVisualizing(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        VisualizedRegion region = this.getVisualizedRegion(player);
        if (region != null && region.canSeeParticles(player)) {
            region.hideParticles(player);
        }
        for (Location location : this.getVisualizedPoints(player)) {
            Block block;
            if (location == null || !BlockVisualizer.isVisualized(block = location.getBlock())) continue;
            BlockVisualizer.stopVisualizing(block);
        }
    }

    protected VisualTool() {
    }
}

