/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.visual;

import java.util.HashSet;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompProperty;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class BlockVisualizer {
    private static final StrictMap<Location, Object> visualizedBlocks = new StrictMap();

    public static void visualize(@NonNull Block block, CompMaterial mask, String blockName) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        Valid.checkBoolean(!BlockVisualizer.isVisualized(block), "Block at " + block.getLocation() + " already visualized", new Object[0]);
        Location location = block.getLocation();
        FallingBlock falling = BlockVisualizer.spawnFallingBlock(location, mask, blockName);
        for (Player player : block.getWorld().getPlayers()) {
            Remain.sendBlockChange(2, player, location, MinecraftVersion.olderThan(MinecraftVersion.V.v1_9) ? mask : CompMaterial.BARRIER);
        }
        visualizedBlocks.put(location, falling == null ? Boolean.valueOf(false) : falling);
    }

    private static FallingBlock spawnFallingBlock(Location location, CompMaterial mask, String blockName) {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
            return null;
        }
        FallingBlock falling = Remain.spawnFallingBlock(location.clone().add(0.5, 0.0, 0.5), mask.getMaterial());
        falling.setDropItem(false);
        falling.setVelocity(new Vector(0, 0, 0));
        Remain.setCustomName((Entity)falling, blockName);
        CompProperty.GLOWING.apply(falling, true);
        CompProperty.GRAVITY.apply(falling, false);
        return falling;
    }

    public static void stopVisualizing(@NonNull Block block) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        Valid.checkBoolean(BlockVisualizer.isVisualized(block), "Block at " + block.getLocation() + " not visualized", new Object[0]);
        Object fallingBlock = visualizedBlocks.remove(block.getLocation());
        if (fallingBlock instanceof FallingBlock) {
            ((FallingBlock)fallingBlock).remove();
        }
        for (Player player : block.getWorld().getPlayers()) {
            Remain.sendBlockChange(1, player, block);
        }
    }

    public static void stopAll() {
        for (Location location : new HashSet<Location>(visualizedBlocks.keySet())) {
            Block block = location.getBlock();
            if (!BlockVisualizer.isVisualized(block)) continue;
            BlockVisualizer.stopVisualizing(block);
        }
    }

    public static boolean isVisualized(@NonNull Block block) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        return visualizedBlocks.containsKey(block.getLocation());
    }

    private BlockVisualizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

