/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.slider;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.slider.Slider;

public final class ItemSlider
implements Slider<List<ItemStack>> {
    private final ItemStack fillerItem;
    private final ItemStack highlightItem;
    private int width = 1;
    private int currentPointer = 0;

    public ItemSlider width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public List<ItemStack> next() {
        int i;
        if (this.currentPointer == this.width) {
            this.currentPointer = 0;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = this.width - 1; i > this.width - this.currentPointer - 1; --i) {
            items.add(this.fillerItem);
        }
        items.add(this.highlightItem);
        for (i = 0; i < this.width - this.currentPointer - 1; ++i) {
            items.add(this.fillerItem);
        }
        ++this.currentPointer;
        return items;
    }

    public static ItemSlider from(CompMaterial filler, CompMaterial highlighted) {
        return ItemSlider.from(ItemCreator.of(filler), ItemCreator.of(highlighted));
    }

    public static ItemSlider from(ItemCreator filler, ItemCreator highlighted) {
        return ItemSlider.from(filler.make(), highlighted.make());
    }

    public static ItemSlider from(ItemStack filler, ItemStack highlighted) {
        return new ItemSlider(filler, highlighted);
    }

    private ItemSlider(ItemStack fillerItem, ItemStack highlightItem) {
        this.fillerItem = fillerItem;
        this.highlightItem = highlightItem;
    }
}

