/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.slider;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.slider.Slider;

public class ItemFrameClockwiseSlider
implements Slider<Map<Integer, ItemStack>> {
    private final ItemStack fillerItem;
    private final ItemStack highlightItem;
    private int frameSize = 27;
    private int currentPointer = 0;

    public ItemFrameClockwiseSlider frameSize(int frameSize) {
        this.frameSize = frameSize;
        return this;
    }

    @Override
    public Map<Integer, ItemStack> next() {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int rowCount = this.frameSize / 9;
        for (int index = 0; index < this.frameSize; ++index) {
            int row = index / 9;
            int column = index % 9 + 1;
            if (row != 0 && row != rowCount - 1 && column != 1 && column != 9) continue;
            items.put(index, this.fillerItem);
        }
        if (this.currentPointer < 8) {
            ++this.currentPointer;
        } else if (this.currentPointer == 8) {
            this.currentPointer = 17;
        } else if (this.currentPointer <= this.frameSize - 1 && this.currentPointer > this.frameSize - 9) {
            --this.currentPointer;
        } else if (this.currentPointer == 9) {
            this.currentPointer = 0;
        } else if (rowCount >= 3) {
            if (this.currentPointer == 17) {
                this.currentPointer = 26;
            } else if (this.currentPointer == 18) {
                this.currentPointer = 9;
            } else if (rowCount >= 4) {
                if (this.currentPointer == 26) {
                    this.currentPointer = 35;
                } else if (this.currentPointer == 27) {
                    this.currentPointer = 18;
                } else if (rowCount >= 5) {
                    if (this.currentPointer == 35) {
                        this.currentPointer = 44;
                    } else if (this.currentPointer == 36) {
                        this.currentPointer = 27;
                    } else if (rowCount == 6) {
                        if (this.currentPointer == 44) {
                            this.currentPointer = 53;
                        } else if (this.currentPointer == 45) {
                            this.currentPointer = 36;
                        }
                    }
                }
            }
        }
        items.replace(this.currentPointer, this.highlightItem);
        return items;
    }

    public static ItemFrameClockwiseSlider from(CompMaterial filler, CompMaterial highlighted) {
        return ItemFrameClockwiseSlider.from(ItemCreator.of(filler), ItemCreator.of(highlighted));
    }

    public static ItemFrameClockwiseSlider from(ItemCreator filler, ItemCreator highlighted) {
        return ItemFrameClockwiseSlider.from(filler.make(), highlighted.make());
    }

    public static ItemFrameClockwiseSlider from(ItemStack filler, ItemStack highlighted) {
        return new ItemFrameClockwiseSlider(filler, highlighted);
    }

    private ItemFrameClockwiseSlider(ItemStack fillerItem, ItemStack highlightItem) {
        this.fillerItem = fillerItem;
        this.highlightItem = highlightItem;
    }
}

