/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.slider;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.slider.Slider;

public final class ItemFrameBounceSlider
implements Slider<Map<Integer, ItemStack>> {
    private final ItemStack fillerItem;
    private final ItemStack highlightItem;
    private final ItemStack sideItem;
    private final ItemStack cornerItem;
    private int frameSize = 27;
    private int topPointer = 0;
    private int bottomPointer = 44;
    boolean topDecreasing = false;
    boolean bottomDecreasing = true;

    public ItemFrameBounceSlider frameSize(int frameSize) {
        this.frameSize = frameSize;
        return this;
    }

    @Override
    public Map<Integer, ItemStack> next() {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int rowCount = this.frameSize / 9;
        for (int index = 0; index < this.frameSize; ++index) {
            int row = index / 9;
            int column = index % 9 + 1;
            if (row == 0 || row == rowCount - 1) {
                items.put(index, this.fillerItem);
            }
            if (column != 1 && column != 9) continue;
            items.put(index, this.sideItem);
        }
        this.topPointer = this.topDecreasing ? --this.topPointer : ++this.topPointer;
        if (this.topPointer == 0) {
            this.topDecreasing = false;
        } else if (this.topPointer == 8) {
            this.topDecreasing = true;
        }
        this.bottomPointer = this.bottomDecreasing ? --this.bottomPointer : ++this.bottomPointer;
        if (this.bottomPointer == this.frameSize - 9) {
            this.bottomDecreasing = false;
        } else if (this.bottomPointer == this.frameSize - 1) {
            this.bottomDecreasing = true;
        }
        items.replace(this.topPointer, this.highlightItem);
        items.replace(this.bottomPointer, this.highlightItem);
        if (this.topPointer == 0 || this.topPointer == 8) {
            items.replace(this.topPointer, this.cornerItem);
        }
        if (this.bottomPointer == this.frameSize - 9 || this.bottomPointer == this.frameSize - 1) {
            items.replace(this.bottomPointer, this.cornerItem);
        }
        return items;
    }

    public static ItemFrameBounceSlider from(CompMaterial filler, CompMaterial highlighted, CompMaterial side, CompMaterial corner) {
        return ItemFrameBounceSlider.from(ItemCreator.of(filler), ItemCreator.of(highlighted), ItemCreator.of(side), ItemCreator.of(corner));
    }

    public static ItemFrameBounceSlider from(ItemCreator filler, ItemCreator highlighted, ItemCreator side, ItemCreator corner) {
        return ItemFrameBounceSlider.from(filler.make(), highlighted.make(), side.make(), corner.make());
    }

    public static ItemFrameBounceSlider from(ItemStack filler, ItemStack highlighted, ItemStack side, ItemStack corner) {
        return new ItemFrameBounceSlider(filler, highlighted, side, corner);
    }

    private ItemFrameBounceSlider(ItemStack fillerItem, ItemStack highlightItem, ItemStack sideItem, ItemStack cornerItem) {
        this.fillerItem = fillerItem;
        this.highlightItem = highlightItem;
        this.sideItem = sideItem;
        this.cornerItem = cornerItem;
    }
}

