/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.slider;

import org.bukkit.ChatColor;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.slider.Slider;

public final class ColoredTextSlider
implements Slider<String> {
    private final String text;
    private int width = 5;
    private String primaryColor = ChatColor.BLACK.toString();
    private String secondaryColor = ChatColor.DARK_RED.toString();
    private int currentPointer = Integer.MIN_VALUE;

    public ColoredTextSlider width(int width) {
        this.width = width;
        return this;
    }

    public ColoredTextSlider primaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    public ColoredTextSlider secondaryColor(String secondaryColor) {
        this.secondaryColor = secondaryColor;
        return this;
    }

    @Override
    public String next() {
        if (this.currentPointer == Integer.MIN_VALUE || this.currentPointer == this.text.length()) {
            this.currentPointer = 1 - this.width;
        }
        int from = MathUtil.range(this.currentPointer, 0, this.text.length());
        int to = MathUtil.range(this.currentPointer + this.width, 0, this.text.length());
        String before = Common.colorize(this.primaryColor + this.text.substring(0, from));
        String part = Common.colorize(this.secondaryColor + this.text.substring(from, to));
        String after = Common.colorize(this.primaryColor + this.text.substring(to));
        ++this.currentPointer;
        return before + part + after;
    }

    public static ColoredTextSlider from(String text) {
        return new ColoredTextSlider(text);
    }

    public String getText() {
        return this.text;
    }

    public int getWidth() {
        return this.width;
    }

    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public String getSecondaryColor() {
        return this.secondaryColor;
    }

    public int getCurrentPointer() {
        return this.currentPointer;
    }

    private ColoredTextSlider(String text) {
        this.text = text;
    }
}

