/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.model.BoxedMessage;
import sk.adonikeoffice.epicchat.lib.model.IsInList;
import sk.adonikeoffice.epicchat.lib.model.SimpleSound;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.FileConfig;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public abstract class YamlStaticConfig {
    public static final String NO_DEFAULT = null;
    private static YamlConfig TEMPORARY_INSTANCE;

    protected YamlStaticConfig() {
        TEMPORARY_INSTANCE = new YamlConfig(){
            {
                YamlStaticConfig.this.beforeLoad();
            }

            @Override
            protected boolean saveComments() {
                return YamlStaticConfig.this.saveComments();
            }

            @Override
            protected List<String> getUncommentedSections() {
                return YamlStaticConfig.this.getUncommentedSections();
            }

            @Override
            protected void onLoad() {
                YamlStaticConfig.this.loadViaReflection();
            }
        };
    }

    public static final void load(Class<? extends YamlStaticConfig> clazz) {
        try {
            YamlStaticConfig config = clazz.newInstance();
            config.onLoad();
            TEMPORARY_INSTANCE = null;
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to load static settings " + clazz);
        }
    }

    protected void beforeLoad() {
    }

    protected void preLoad() {
    }

    protected abstract void onLoad() throws Exception;

    protected boolean saveComments() {
        return true;
    }

    protected List<String> getUncommentedSections() {
        return new ArrayList<String>();
    }

    private void loadViaReflection() {
        Valid.checkNotNull(TEMPORARY_INSTANCE, "Instance cannot be null " + YamlStaticConfig.getFileName());
        Valid.checkNotNull(YamlStaticConfig.TEMPORARY_INSTANCE.defaults, "Default config cannot be null for " + YamlStaticConfig.getFileName());
        try {
            this.preLoad();
            if (YamlStaticConfig.class.isAssignableFrom(this.getClass().getSuperclass())) {
                Class<?> superClass = this.getClass().getSuperclass();
                this.invokeAll(superClass);
            }
            this.invokeAll(this.getClass());
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            Remain.sneaky(t);
        }
    }

    private void invokeAll(Class<?> clazz) throws Exception {
        this.invokeMethodsIn(clazz);
        for (Class<?> subClazz : clazz.getDeclaredClasses()) {
            this.invokeAll(subClazz);
        }
    }

    private void invokeMethodsIn(Class<?> clazz) throws Exception {
        SimplePlugin instance = SimplePlugin.getInstance();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!instance.isEnabled()) {
                return;
            }
            int mod = method.getModifiers();
            if (!method.getName().equals("init")) continue;
            Valid.checkBoolean(Modifier.isPrivate(mod) && Modifier.isStatic(mod) && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0, "Method '" + method.getName() + "' in " + clazz + " must be 'private static void init()'", new Object[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        this.checkFields(clazz);
    }

    private void checkFields(Class<?> clazz) throws Exception {
        if (clazz == YamlStaticConfig.class) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (Modifier.isPublic(field.getModifiers())) {
                Valid.checkBoolean(!field.getType().isPrimitive(), "Field '" + field.getName() + "' in " + clazz + " must not be primitive!", new Object[0]);
            }
            Object result = null;
            try {
                result = field.get(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Valid.checkNotNull(result, "Null " + field.getType().getSimpleName() + " field '" + field.getName() + "' in " + clazz);
        }
    }

    protected final void loadConfiguration(String internalPath) {
        TEMPORARY_INSTANCE.loadConfiguration(internalPath, internalPath);
    }

    protected final void loadConfiguration(String from, String to) {
        TEMPORARY_INSTANCE.loadConfiguration(from, to);
    }

    protected static final void set(String path, Object value) {
        TEMPORARY_INSTANCE.set(path, value);
    }

    protected static final boolean isSet(String path) {
        return TEMPORARY_INSTANCE.isSet(path);
    }

    protected static final boolean isSetDefault(String path) {
        return TEMPORARY_INSTANCE.isSetDefault(path);
    }

    protected static final void move(String fromRelative, String toAbsolute) {
        TEMPORARY_INSTANCE.move(fromRelative, toAbsolute);
    }

    @Deprecated
    protected static final void pathPrefix(String pathPrefix) {
        YamlStaticConfig.setPathPrefix(pathPrefix);
    }

    protected static final void setPathPrefix(String pathPrefix) {
        TEMPORARY_INSTANCE.setPathPrefix(pathPrefix);
    }

    protected static final String getPathPrefix() {
        return TEMPORARY_INSTANCE.getPathPrefix();
    }

    protected static final String getFileName() {
        return TEMPORARY_INSTANCE.getFileName();
    }

    @Deprecated
    protected static YamlConfig getInstance() {
        return TEMPORARY_INSTANCE;
    }

    protected static final List<CompMaterial> getMaterialList(String path) {
        return TEMPORARY_INSTANCE.getMaterialList(path);
    }

    protected static final StrictList<String> getCommandList(String path) {
        return TEMPORARY_INSTANCE.getCommandList(path);
    }

    protected static final List<String> getStringList(String path) {
        return TEMPORARY_INSTANCE.getStringList(path);
    }

    protected static final <E> Set<E> getSet(String path, Class<E> typeOf) {
        return TEMPORARY_INSTANCE.getSet(path, typeOf, new Object[0]);
    }

    protected static final <E> List<E> getList(String path, Class<E> listType) {
        return TEMPORARY_INSTANCE.getList(path, listType, new Object[0]);
    }

    protected static final <E> IsInList<E> getIsInList(String path, Class<E> listType) {
        return TEMPORARY_INSTANCE.getIsInList(path, listType);
    }

    protected static final boolean getBoolean(String path) {
        return TEMPORARY_INSTANCE.getBoolean(path);
    }

    protected static final String getString(String path) {
        return TEMPORARY_INSTANCE.getString(path);
    }

    protected static final int getInteger(String path) {
        return TEMPORARY_INSTANCE.getInteger(path);
    }

    protected static final int getInteger(String path, int def) {
        return TEMPORARY_INSTANCE.getInteger(path, def);
    }

    protected static final double getDouble(String path) {
        return TEMPORARY_INSTANCE.getDouble(path);
    }

    protected static final SimpleSound getSound(String path) {
        return TEMPORARY_INSTANCE.getSound(path);
    }

    protected static final FileConfig.AccusativeHelper getCasus(String path) {
        return TEMPORARY_INSTANCE.getAccusativePeriod(path);
    }

    protected static final FileConfig.TitleHelper getTitle(String path) {
        return TEMPORARY_INSTANCE.getTitle(path);
    }

    protected static final SimpleTime getTime(String path) {
        return TEMPORARY_INSTANCE.getTime(path);
    }

    protected static final double getPercentage(String path) {
        return TEMPORARY_INSTANCE.getPercentage(path);
    }

    protected static final CompMaterial getMaterial(String path) {
        return TEMPORARY_INSTANCE.getMaterial(path);
    }

    protected static final BoxedMessage getBoxedMessage(String path) {
        return TEMPORARY_INSTANCE.getBoxedMessage(path);
    }

    protected static final <E> E get(String path, Class<E> typeOf) {
        return TEMPORARY_INSTANCE.get(path, typeOf, new Object[0]);
    }

    protected static final Object getObject(String path) {
        return TEMPORARY_INSTANCE.getObject(path);
    }

    protected static final SerializedMap getMap(String path) {
        return TEMPORARY_INSTANCE.getMap(path);
    }

    protected static final <Key, Value> LinkedHashMap<Key, Value> getMap(String path, Class<Key> keyType, Class<Value> valueType) {
        return TEMPORARY_INSTANCE.getMap(path, keyType, valueType, new Object[0]);
    }
}

