/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.settings.ConfigSection;
import sk.adonikeoffice.epicchat.lib.settings.FileConfig;
import sk.adonikeoffice.epicchat.lib.settings.YamlComments;

public class YamlConfig
extends FileConfig {
    private final Yaml yaml;
    private boolean saveEmptyValues = true;

    protected YamlConfig() {
        YamlConstructor constructor = new YamlConstructor();
        YamlRepresenter representer = new YamlRepresenter();
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(2);
        dumperOptions.setWidth(4096);
        if (ReflectionUtil.isClassAvailable("org.yaml.snakeyaml.LoaderOptions")) {
            Yaml yaml;
            try {
                LoaderOptions loaderOptions = new LoaderOptions();
                loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
                yaml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions);
            }
            catch (NoSuchMethodError ex) {
                yaml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions);
            }
            this.yaml = yaml;
        } else {
            this.yaml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions);
        }
    }

    protected boolean saveComments() {
        return true;
    }

    protected List<String> getUncommentedSections() {
        return new ArrayList<String>();
    }

    public final void setSaveEmptyValues(boolean saveEmptyValues) {
        this.saveEmptyValues = saveEmptyValues;
    }

    public boolean isValid() {
        return !this.section.map.isEmpty();
    }

    public final void loadConfiguration(String internalPath) {
        this.loadConfiguration(internalPath, internalPath);
    }

    public final void loadConfiguration(@Nullable String from, String to) {
        File file;
        if (from != null) {
            this.file = file = FileUtil.extract(from, to);
            YamlConfig defaultConfig = new YamlConfig();
            String defaultContent = String.join((CharSequence)"\n", FileUtil.getInternalFileContent(from));
            defaultConfig.file = file;
            defaultConfig.loadFromString(defaultContent);
            this.defaults = defaultConfig.section;
            this.defaultsPath = from;
        } else {
            file = FileUtil.getOrMakeFile(to);
        }
        this.load(file);
    }

    public final void loadInternal(String internalPath) {
        String content = String.join((CharSequence)"\n", FileUtil.getInternalFileContent(internalPath));
        this.loadFromString(content);
    }

    @Override
    @NonNull
    final String saveToString() {
        if (this.defaults == null || !this.saveComments()) {
            String dump;
            String header = this.getHeader() == null ? "" : "# " + String.join((CharSequence)"\n# ", this.getHeader().split("\n")) + "\n\n";
            Map<String, Object> values = this.section.getValues(false);
            if (!this.saveEmptyValues) {
                YamlConfig.removeEmptyValues(values);
            }
            if ((dump = this.yaml.dump(values)).equals("{}\n")) {
                dump = "";
            }
            return header + dump;
        }
        try {
            YamlComments.writeComments(this.defaultsPath, this.file, null, this.getUncommentedSections());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static void removeEmptyValues(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            Object value = entry.getValue();
            if (value instanceof ConfigSection) {
                Map<String, Object> childMap = ((ConfigSection)value).map;
                YamlConfig.removeEmptyValues(childMap);
                if (childMap.isEmpty()) {
                    it.remove();
                }
            }
            if (!(value == null || value instanceof Iterable && !((Iterable)value).iterator().hasNext() || value.getClass().isArray() && ((Object[])value).length == 0) && (!(value instanceof Map) || !((Map)value).isEmpty())) continue;
            it.remove();
        }
    }

    @Override
    final void loadFromString(@NonNull String contents) {
        Map input;
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        try {
            input = (Map)this.yaml.load(contents);
        }
        catch (YAMLException ex) {
            throw ex;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Top level is not a Map.");
        }
        String header = this.parseHeader(contents);
        if (header.trim().length() > 0) {
            this.setHeader(header);
        }
        this.section.map.clear();
        if (input != null) {
            this.convertMapsToSections(input, this.section);
        }
    }

    private void convertMapsToSections(@NonNull Map<?, ?> input, @NonNull ConfigSection section) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
                continue;
            }
            section.store(key, value);
        }
    }

    @NonNull
    private String parseHeader(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String commentPrefix = "# ";
        String[] lines = input.split("\r?\n", -1);
        StringBuilder result = new StringBuilder();
        boolean readingHeader = true;
        boolean foundHeader = false;
        for (int i = 0; i < lines.length && readingHeader; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("# ") || line.equals("#")) {
                if (i > 0) {
                    result.append("\n");
                }
                if (line.length() > "# ".length()) {
                    result.append(line.substring("# ".length()));
                }
                foundHeader = true;
                continue;
            }
            if (foundHeader && line.length() == 0) {
                result.append("\n");
                continue;
            }
            if (!foundHeader) continue;
            readingHeader = false;
        }
        String string = result.toString();
        return string.trim().isEmpty() ? "" : string + "\n";
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof YamlConfig && ((YamlConfig)obj).getFileName().equals(this.getFileName());
    }

    @NonNull
    public static final YamlConfig fromInternalPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        YamlConfig config = new YamlConfig();
        try {
            config.loadConfiguration(path);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + path, ex);
        }
        return config;
    }

    @NonNull
    public static final YamlConfig fromInternalPathFast(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        YamlConfig config = new YamlConfig();
        try {
            config.loadInternal(path);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + path, ex);
        }
        return config;
    }

    @NonNull
    public static final YamlConfig fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        YamlConfig config = new YamlConfig();
        try {
            config.load(file);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    @NonNull
    public static final YamlConfig fromFileFast(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        YamlConfig config = new YamlConfig();
        try {
            List<String> content = FileUtil.readLines(file);
            config.loadFromString(String.join((CharSequence)"\n", content));
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    private static final class YamlConstructor
    extends SafeConstructor {
        public YamlConstructor() {
            this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject());
        }

        private class ConstructCustomObject
        extends SafeConstructor.ConstructYamlMap {
            private ConstructCustomObject() {
                super((SafeConstructor)YamlConstructor.this);
            }

            public Object construct(@NonNull Node node) {
                if (node == null) {
                    throw new NullPointerException("node is marked non-null but is null");
                }
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
                }
                Map raw = (Map)super.construct(node);
                if (raw.containsKey("==")) {
                    LinkedHashMap typed = new LinkedHashMap(raw.size());
                    for (Map.Entry entry : raw.entrySet()) {
                        typed.put(entry.getKey().toString(), entry.getValue());
                    }
                    try {
                        return ConfigurationSerialization.deserializeObject(typed);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new YAMLException("Could not deserialize object", (Throwable)ex);
                    }
                }
                return raw;
            }

            public void construct2ndStep(@NonNull Node node, @NonNull Object object) {
                if (node == null) {
                    throw new NullPointerException("node is marked non-null but is null");
                }
                if (object == null) {
                    throw new NullPointerException("object is marked non-null but is null");
                }
                throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
            }
        }
    }

    private static final class YamlRepresenter
    extends Representer {
        public YamlRepresenter() {
            this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
            this.multiRepresenters.put(ConfigSection.class, new RepresentConfigurationSection());
            this.multiRepresenters.remove(Enum.class);
        }

        private class RepresentConfigurationSerializable
        extends SafeRepresenter.RepresentMap {
            private RepresentConfigurationSerializable() {
                super((SafeRepresenter)YamlRepresenter.this);
            }

            @NonNull
            public Node representData(@NonNull Object data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                ConfigurationSerializable serializable = (ConfigurationSerializable)data;
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                values.put("==", ConfigurationSerialization.getAlias((Class)serializable.getClass()));
                values.putAll(serializable.serialize());
                return super.representData(values);
            }
        }

        private class RepresentConfigurationSection
        extends SafeRepresenter.RepresentMap {
            private RepresentConfigurationSection() {
                super((SafeRepresenter)YamlRepresenter.this);
            }

            @NonNull
            public Node representData(@NonNull Object data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                return super.representData(((ConfigSection)data).getValues(false));
            }
        }
    }
}

