/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

final class YamlComments {
    YamlComments() {
    }

    static void writeComments(@NonNull String jarPath, @NonNull File diskFile, @Nullable String oldContents, @NonNull List<String> ignoredSections) throws IOException {
        if (jarPath == null) {
            throw new NullPointerException("jarPath is marked non-null but is null");
        }
        if (diskFile == null) {
            throw new NullPointerException("diskFile is marked non-null but is null");
        }
        if (ignoredSections == null) {
            throw new NullPointerException("ignoredSections is marked non-null but is null");
        }
        List<String> newLines = FileUtil.getInternalFileContent(jarPath);
        YamlConfiguration oldConfig = new YamlConfiguration();
        try {
            if (oldContents != null) {
                oldConfig.loadFromString(oldContents);
            } else {
                oldConfig.load(diskFile);
            }
        }
        catch (Throwable t) {
            Remain.sneaky(t);
        }
        YamlConfiguration newConfig = new YamlConfiguration();
        try {
            newConfig.loadFromString(String.join((CharSequence)"\n", newLines));
        }
        catch (Throwable t) {
            Remain.sneaky(t);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(diskFile), StandardCharsets.UTF_8));
        for (String ignoredSection : ignoredSections) {
            if (!newConfig.isSet(ignoredSection)) continue;
            Valid.checkBoolean(newConfig.isConfigurationSection(ignoredSection), "Can only ignore config sections in " + jarPath + " (file " + diskFile + ") not '" + ignoredSection + "' that is " + newConfig.get(ignoredSection), new Object[0]);
        }
        Set newKeys = newConfig.getKeys(true);
        HashMap removedKeys = new HashMap();
        block5: for (Map.Entry oldEntry : oldConfig.getValues(true).entrySet()) {
            String oldKey = (String)oldEntry.getKey();
            for (String ignoredKey : ignoredSections) {
                if (!oldKey.startsWith(ignoredKey)) continue;
                continue block5;
            }
            if (newKeys.contains(oldKey)) continue;
            removedKeys.put(oldKey, oldEntry.getValue());
        }
        if (!removedKeys.isEmpty()) {
            File backupFile = FileUtil.getOrMakeFile("unused/" + diskFile.getName());
            YamlConfiguration backupConfig = YamlConfiguration.loadConfiguration((File)backupFile);
            for (Map.Entry entry : removedKeys.entrySet()) {
                backupConfig.set((String)entry.getKey(), entry.getValue());
            }
            backupConfig.save(backupFile);
            Common.warning("The following entries in " + diskFile.getName() + " are unused and were moved into " + backupFile + ": " + removedKeys.keySet());
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setWidth(4096);
        Yaml yaml = new Yaml(dumperOptions);
        Map<String, String> comments = YamlComments.parseComments(newLines, ignoredSections, (FileConfiguration)oldConfig, yaml);
        YamlComments.write((FileConfiguration)newConfig, (FileConfiguration)oldConfig, comments, ignoredSections, writer, yaml);
    }

    private static void write(FileConfiguration newConfig, FileConfiguration oldConfig, Map<String, String> comments, List<String> ignoredSections, BufferedWriter writer, Yaml yaml) throws IOException {
        HashSet<String> copyAllowed = new HashSet<String>();
        HashSet<String> reverseCopy = new HashSet<String>();
        block0: for (String key : newConfig.getKeys(true)) {
            block8: {
                for (String allowed : copyAllowed) {
                    if (!key.startsWith(allowed)) continue;
                    break block8;
                }
                for (String allowed : reverseCopy) {
                    if (!key.startsWith(allowed)) continue;
                    continue block0;
                }
                for (String ignoredSection : ignoredSections) {
                    if (key.equals(ignoredSection)) {
                        if (!oldConfig.isSet(ignoredSection) || oldConfig.getConfigurationSection(ignoredSection).getKeys(false).isEmpty()) {
                            copyAllowed.add(ignoredSection);
                            break;
                        }
                        YamlComments.write0(key, true, newConfig, oldConfig, comments, ignoredSections, writer, yaml);
                        for (String oldKey : oldConfig.getConfigurationSection(ignoredSection).getKeys(true)) {
                            YamlComments.write0(ignoredSection + "." + oldKey, true, oldConfig, newConfig, comments, ignoredSections, writer, yaml);
                        }
                        reverseCopy.add(ignoredSection);
                        continue block0;
                    }
                    if (!key.startsWith(ignoredSection)) continue;
                    continue block0;
                }
            }
            YamlComments.write0(key, false, newConfig, oldConfig, comments, ignoredSections, writer, yaml);
        }
        String danglingComments = comments.get(null);
        if (danglingComments != null) {
            writer.write(danglingComments);
        }
        writer.close();
    }

    private static void write0(String key, boolean forceNew, FileConfiguration newConfig, FileConfiguration oldConfig, Map<String, String> comments, List<String> ignoredSections, BufferedWriter writer, Yaml yaml) throws IOException {
        String[] keys = key.split("\\.");
        String actualKey = keys[keys.length - 1];
        String comment = comments.remove(key);
        StringBuilder prefixBuilder = new StringBuilder();
        int indents = keys.length - 1;
        YamlComments.appendPrefixSpaces(prefixBuilder, indents);
        String prefixSpaces = prefixBuilder.toString();
        if (comment != null) {
            writer.write(comment);
        }
        Object newObj = newConfig.get(key);
        Object oldObj = oldConfig.get(key);
        if (newObj instanceof ConfigurationSection && !forceNew && oldObj instanceof ConfigurationSection) {
            YamlComments.writeSection(writer, actualKey, prefixSpaces, (ConfigurationSection)oldObj);
        } else if (newObj instanceof ConfigurationSection) {
            YamlComments.writeSection(writer, actualKey, prefixSpaces, (ConfigurationSection)newObj);
        } else if (oldObj != null && !forceNew) {
            YamlComments.write(oldObj, actualKey, prefixSpaces, yaml, writer);
        } else {
            YamlComments.write(newObj, actualKey, prefixSpaces, yaml, writer);
        }
    }

    private static void write(Object obj, String actualKey, String prefixSpaces, Yaml yaml, BufferedWriter writer) throws IOException {
        if (obj instanceof ConfigurationSerializable) {
            writer.write(prefixSpaces + actualKey + ": " + yaml.dump((Object)((ConfigurationSerializable)obj).serialize()));
        } else if (obj instanceof String || obj instanceof Character) {
            String string;
            if (obj instanceof String && (string = (String)obj).contains("\n")) {
                writer.write(prefixSpaces + actualKey + ": |-\n");
                for (String line : string.split("\n")) {
                    writer.write(prefixSpaces + "    " + line + "\n");
                }
                return;
            }
            writer.write(prefixSpaces + actualKey + ": " + yaml.dump(obj));
        } else if (obj instanceof List) {
            YamlComments.writeList((List)obj, actualKey, prefixSpaces, yaml, writer);
        } else {
            writer.write(prefixSpaces + actualKey + ": " + yaml.dump(obj));
        }
    }

    private static void writeSection(BufferedWriter writer, String actualKey, String prefixSpaces, ConfigurationSection section) throws IOException {
        if (section.getKeys(false).isEmpty()) {
            writer.write(prefixSpaces + actualKey + ":");
        } else {
            writer.write(prefixSpaces + actualKey + ":");
        }
        writer.write("\n");
    }

    private static void writeList(List<?> list, String actualKey, String prefixSpaces, Yaml yaml, BufferedWriter writer) throws IOException {
        writer.write(YamlComments.getListAsString(list, actualKey, prefixSpaces, yaml));
    }

    private static String getListAsString(List<?> list, String actualKey, String prefixSpaces, Yaml yaml) {
        StringBuilder builder = new StringBuilder(prefixSpaces).append(actualKey).append(":");
        if (list.isEmpty()) {
            builder.append(" []\n");
            return builder.toString();
        }
        builder.append("\n");
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof Map) {
                int entryIndex = 0;
                int mapSize = ((Map)o).size();
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    builder.append(prefixSpaces);
                    if (entryIndex == 0) {
                        builder.append("- ");
                    } else {
                        builder.append("  ");
                    }
                    builder.append(entry.getKey()).append(": ").append(yaml.dump(entry.getValue()));
                    if (++entryIndex == mapSize) continue;
                    builder.append("\n");
                }
            } else if (o instanceof String || o instanceof Character) {
                builder.append(prefixSpaces).append("- '").append(o.toString().replace("'", "''")).append("'");
            } else if (o instanceof List) {
                builder.append(prefixSpaces).append("- ").append(yaml.dump(o));
            } else {
                builder.append(prefixSpaces).append("- ").append(o);
            }
            if (i == list.size()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private static Map<String, String> parseComments(List<String> lines, List<String> ignoredSections, FileConfiguration oldConfig, Yaml yaml) {
        HashMap<String, String> comments = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        StringBuilder keyBuilder = new StringBuilder();
        int lastLineIndentCount = 0;
        for (String line : lines) {
            if (line != null && line.trim().startsWith("-")) continue;
            if (line == null || line.trim().equals("") || line.trim().startsWith("#")) {
                builder.append(line).append("\n");
                continue;
            }
            lastLineIndentCount = YamlComments.setFullKey(keyBuilder, line, lastLineIndentCount);
            if (keyBuilder.length() <= 0) continue;
            comments.put(keyBuilder.toString(), builder.toString());
            builder.setLength(0);
        }
        if (builder.length() > 0) {
            comments.put(null, builder.toString());
        }
        return comments;
    }

    private static int countIndents(String s) {
        int spaces = 0;
        for (char c : s.toCharArray()) {
            if (c != ' ') break;
            ++spaces;
        }
        return spaces / 2;
    }

    private static void removeLastKey(StringBuilder keyBuilder) {
        String temp = keyBuilder.toString();
        String[] keys = temp.split("\\.");
        if (keys.length == 1) {
            keyBuilder.setLength(0);
            return;
        }
        temp = temp.substring(0, temp.length() - keys[keys.length - 1].length() - 1);
        keyBuilder.setLength(temp.length());
    }

    private static int setFullKey(StringBuilder keyBuilder, String configLine, int lastLineIndentCount) {
        int currentIndents = YamlComments.countIndents(configLine);
        String key = configLine.trim().split(":")[0];
        if (keyBuilder.length() == 0) {
            keyBuilder.append(key);
        } else if (currentIndents == lastLineIndentCount) {
            YamlComments.removeLastKey(keyBuilder);
            if (keyBuilder.length() > 0) {
                keyBuilder.append(".");
            }
            keyBuilder.append(key);
        } else if (currentIndents > lastLineIndentCount) {
            keyBuilder.append(".").append(key);
        } else {
            int difference = lastLineIndentCount - currentIndents;
            for (int i = 0; i < difference + 1; ++i) {
                YamlComments.removeLastKey(keyBuilder);
            }
            if (keyBuilder.length() > 0) {
                keyBuilder.append(".");
            }
            keyBuilder.append(key);
        }
        return currentIndents;
    }

    private static String getPrefixSpaces(int indents) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indents; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }

    private static void appendPrefixSpaces(StringBuilder builder, int indents) {
        builder.append(YamlComments.getPrefixSpaces(indents));
    }
}

