/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.YamlStaticConfig;

public class SimpleSettings
extends YamlStaticConfig {
    private static boolean settingsClassCalled;
    public static Integer VERSION;
    public static DateFormat TIMESTAMP_FORMAT;
    public static String LOCATION_FORMAT;
    public static StrictList<String> DEBUG_SECTIONS;
    public static String PLUGIN_PREFIX;
    public static Integer LAG_THRESHOLD_MILLIS;
    public static Integer REGEX_TIMEOUT;
    public static StrictList<String> MAIN_COMMAND_ALIASES;
    public static String LOCALE_PREFIX;
    public static Boolean NOTIFY_UPDATES;

    @Override
    protected final void onLoad() throws Exception {
        this.loadConfiguration(this.getSettingsFileName());
    }

    protected String getSettingsFileName() {
        return "settings.yml";
    }

    @Override
    protected void preLoad() {
        SimpleSettings.setPathPrefix(null);
        VERSION = SimpleSettings.getInteger("Version");
        if (VERSION.intValue() != this.getConfigVersion()) {
            SimpleSettings.set("Version", this.getConfigVersion());
        }
    }

    protected int getConfigVersion() {
        return 1;
    }

    private static void init() {
        boolean keySet;
        Valid.checkBoolean(!settingsClassCalled, "Settings class already loaded!", new Object[0]);
        SimpleSettings.setPathPrefix(null);
        SimpleSettings.upgradeOldSettings();
        if (SimpleSettings.isSetDefault("Timestamp_Format")) {
            try {
                TIMESTAMP_FORMAT = new SimpleDateFormat(SimpleSettings.getString("Timestamp_Format"));
            }
            catch (IllegalArgumentException ex) {
                Common.throwError(ex, "Wrong 'Timestamp_Format '" + SimpleSettings.getString("Timestamp_Format") + "', see https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html for examples'");
            }
        }
        if (SimpleSettings.isSetDefault("Location_Format")) {
            LOCATION_FORMAT = SimpleSettings.getString("Location_Format");
        }
        if (SimpleSettings.isSetDefault("Prefix")) {
            PLUGIN_PREFIX = SimpleSettings.getString("Prefix");
        }
        if (SimpleSettings.isSetDefault("Log_Lag_Over_Milis")) {
            LAG_THRESHOLD_MILLIS = SimpleSettings.getInteger("Log_Lag_Over_Milis");
            Valid.checkBoolean(LAG_THRESHOLD_MILLIS == -1 || LAG_THRESHOLD_MILLIS >= 0, "Log_Lag_Over_Milis must be either -1 to disable, 0 to log all or greater!", new Object[0]);
            if (LAG_THRESHOLD_MILLIS == 0) {
                Common.log("&eLog_Lag_Over_Milis is 0, all performance is logged. Set to -1 to disable.");
            }
        }
        if (SimpleSettings.isSetDefault("Debug")) {
            DEBUG_SECTIONS = new StrictList<String>((Iterable<String>)SimpleSettings.getStringList("Debug"));
        }
        if (SimpleSettings.isSetDefault("Regex_Timeout_Milis")) {
            REGEX_TIMEOUT = SimpleSettings.getInteger("Regex_Timeout_Milis");
        }
        LOCALE_PREFIX = (keySet = SimpleSettings.isSetDefault("Locale")) ? SimpleSettings.getString("Locale") : LOCALE_PREFIX;
        keySet = SimpleSettings.isSetDefault("Command_Aliases");
        MAIN_COMMAND_ALIASES = keySet ? SimpleSettings.getCommandList("Command_Aliases") : MAIN_COMMAND_ALIASES;
        keySet = SimpleSettings.isSetDefault("Notify_Updates");
        NOTIFY_UPDATES = keySet ? SimpleSettings.getBoolean("Notify_Updates") : NOTIFY_UPDATES;
        settingsClassCalled = true;
    }

    private static void upgradeOldSettings() {
        if (SimpleSettings.isSet("Debugger")) {
            SimpleSettings.move("Debugger", "Debug");
        }
        if (SimpleSettings.isSet("Serialization_Number")) {
            SimpleSettings.move("Serialization_Number", "Serialization");
        }
        if (SimpleSettings.isSet("Debugger.Keys")) {
            SimpleSettings.move("Debugger.Keys", "Serialization");
            SimpleSettings.move("Debugger.Sections", "Debug");
        }
        if (SimpleSettings.isSet("Debug") && !(SimpleSettings.getObject("Debug") instanceof List)) {
            SimpleSettings.set("Debug", null);
        }
        if (SimpleSettings.isSet("Plugin_Prefix")) {
            SimpleSettings.move("Plugin_Prefix", "Prefix");
        }
        if (SimpleSettings.isSet("Check_Updates")) {
            SimpleSettings.move("Check_Updates", "Notify_Updates");
        }
    }

    public static final Boolean isSettingsCalled() {
        return settingsClassCalled;
    }

    public static final void resetSettingsCall() {
        settingsClassCalled = false;
    }

    static {
        TIMESTAMP_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        LOCATION_FORMAT = "{world} [{x}, {y}, {z}]";
        DEBUG_SECTIONS = new StrictList();
        PLUGIN_PREFIX = "&7" + SimplePlugin.getNamed() + " //";
        LAG_THRESHOLD_MILLIS = 100;
        REGEX_TIMEOUT = 100;
        MAIN_COMMAND_ALIASES = new StrictList();
        LOCALE_PREFIX = "en";
        NOTIFY_UPDATES = true;
    }
}

