/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.util.Arrays;
import java.util.List;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.JavaScriptExecutor;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class Lang
extends YamlConfig {
    private static volatile Lang instance;

    private Lang(String filePath) {
        this.loadConfiguration(filePath);
    }

    private String getStringStrict(String path) {
        String key = this.getString(path);
        Valid.checkNotNull(key, "Missing localization key '" + path + "' from " + this.getFileName());
        return key;
    }

    public static void init() {
        Lang.init("localization/messages_" + SimpleSettings.LOCALE_PREFIX + ".yml");
    }

    public static void init(String filePath) {
        instance = new Lang(filePath);
        Lang.loadPrefixes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void reloadLang() {
        if (instance != null) {
            Lang lang = instance;
            synchronized (lang) {
                instance.reload();
                instance.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void loadPrefixes() {
        if (instance != null) {
            Lang lang = instance;
            synchronized (lang) {
                if (instance.isSet("Prefix.Announce")) {
                    Messenger.setAnnouncePrefix(Lang.of("Prefix.Announce", new Object[0]));
                }
                if (instance.isSet("Prefix.Error")) {
                    Messenger.setErrorPrefix(Lang.of("Prefix.Error", new Object[0]));
                }
                if (instance.isSet("Prefix.Info")) {
                    Messenger.setInfoPrefix(Lang.of("Prefix.Info", new Object[0]));
                }
                if (instance.isSet("Prefix.Question")) {
                    Messenger.setQuestionPrefix(Lang.of("Prefix.Question", new Object[0]));
                }
                if (instance.isSet("Prefix.Success")) {
                    Messenger.setSuccessPrefix(Lang.of("Prefix.Success", new Object[0]));
                }
                if (instance.isSet("Prefix.Warn")) {
                    Messenger.setWarnPrefix(Lang.of("Prefix.Warn", new Object[0]));
                }
                instance.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getOption(String path) {
        Lang.checkInit();
        Lang lang = instance;
        synchronized (lang) {
            return instance.getBoolean(path);
        }
    }

    public static List<SimpleComponent> ofComponentList(String path, Object ... variables) {
        return Common.convert(Lang.ofList(path, variables), SimpleComponent::of);
    }

    public static List<String> ofList(String path, Object ... variables) {
        return Arrays.asList(Lang.ofArray(path, variables));
    }

    public static String[] ofArray(String path, Object ... variables) {
        return Lang.of(path, variables).split("\n");
    }

    public static SimpleComponent ofComponent(String path, Object ... variables) {
        return SimpleComponent.of(Lang.of(path, variables));
    }

    public static String ofCase(long amount, String path) {
        return amount + " " + Lang.ofCaseNoAmount(amount, path);
    }

    public static String ofCaseNoAmount(long amount, String path) {
        String key = Lang.of(path, new Object[0]);
        String[] split = key.split(", ");
        Valid.checkBoolean(split.length == 1 || split.length == 2, "Invalid syntax of key at '" + path + "', this key is a special one and it needs singular and plural form separated with , such as: second, seconds", new Object[0]);
        String singular = split[0];
        String plural = split[split.length == 2 ? 1 : 0];
        return amount == 0L || amount > 1L ? plural : singular;
    }

    public static String ofScript(String path, SerializedMap scriptVariables, Object ... stringVariables) {
        Object result;
        String script = Lang.of(path, stringVariables);
        if (!(script.contains("?") || script.contains(":") || script.contains("+") || script.startsWith("'") || script.endsWith("'"))) {
            script = "'" + script + "'";
        }
        try {
            result = JavaScriptExecutor.run(script, scriptVariables.asMap());
        }
        catch (Throwable t) {
            throw new FoException(t, "Failed to compile localization key '" + path + "' with script: " + script + " (this must be a valid JavaScript code)");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String of(String path, Object ... variables) {
        Lang.checkInit();
        Lang lang = instance;
        synchronized (lang) {
            String key = instance.getStringStrict(path);
            key = Messenger.replacePrefixes(key);
            key = Lang.translate(key, variables);
            return key;
        }
    }

    private static String translate(String key, Object ... variables) {
        Valid.checkNotNull(key, "Cannot translate a null key with variables " + Common.join(variables));
        if (variables != null) {
            for (int i = 0; i < variables.length; ++i) {
                Object variable = variables[i];
                variable = Common.getOrDefaultStrict(SerializeUtil.serialize(SerializeUtil.Mode.YAML, variable), SimpleLocalization.NONE);
                Valid.checkNotNull(variable, "Failed to replace {" + i + "} as " + variable + " (raw = " + variables[i] + ")");
                key = key.replace("{" + i + "}", variable.toString());
            }
        }
        return key;
    }

    private static void checkInit() {
        if (instance == null) {
            Lang.init();
        }
    }
}

