/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.BoxedMessage;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.model.IsInList;
import sk.adonikeoffice.epicchat.lib.model.SimpleSound;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.model.Tuple;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.ConfigSection;

public abstract class FileConfig {
    private static final Map<String, ConfigSection> loadedSections = new HashMap<String, ConfigSection>();
    public static final String NO_DEFAULT = null;
    final SerializeUtil.Mode mode = SerializeUtil.Mode.YAML;
    @Nullable
    File file;
    ConfigSection section = new ConfigSection();
    @Nullable
    ConfigSection defaults;
    @Nullable
    String defaultsPath;
    @Nullable
    private String header;
    private String pathPrefix = null;
    private boolean alwaysLoad = true;
    private boolean shouldSave = false;
    private boolean loading = false;

    protected FileConfig() {
    }

    @NonNull
    public final Set<String> getKeys(boolean deep) {
        return this.section.getKeys(deep);
    }

    @Deprecated
    public final Map<String, Object> getValues(boolean deep) {
        return this.section.getValues(deep);
    }

    public final <T> T get(String path, Class<T> type, Object ... deserializeParams) {
        return this.get(path, type, (T)null, deserializeParams);
    }

    public final <T> T get(@NonNull String path, Class<T> type, T def, Object ... deserializeParams) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        path = this.buildPathPrefix(path);
        this.copyDefault(path, type);
        Serializable raw = this.section.retrieve(path);
        if (this.defaults != null && def == null) {
            Valid.checkNotNull(raw, "Failed to set '" + path + "' to " + type.getSimpleName() + " from default config's value: " + this.defaults.retrieve(path));
        }
        if (raw != null) {
            if (((Object)raw).equals("[]") && type == List.class) {
                raw = new ArrayList();
            }
            if (type == Long.class && raw instanceof Integer) {
                raw = ((Integer)raw).longValue();
            }
            raw = SerializeUtil.deserialize(this.mode, type, raw, deserializeParams);
            this.checkAssignable(path, raw, type);
            return (T)raw;
        }
        return def;
    }

    private void copyDefault(String path, Class<?> type) {
        if (this.defaults != null && !this.section.isStored(path)) {
            Object object = this.defaults.retrieve(path);
            Valid.checkNotNull(object, "Inbuilt config " + this.getFileName() + " lacks " + (object == null ? "key" : object.getClass().getSimpleName()) + " at \"" + path + "\". Is it outdated?");
            Common.log("&7Updating " + this.getFileName() + " at &b'&f" + path + "&b' &7-> " + (object == null ? "&ckey removed" : "&b'&f" + object.toString().replace("\n", ", ") + "&b'") + "&r");
            this.section.store(path, object);
            this.shouldSave = true;
        }
    }

    private void checkAssignable(String path, Object object, Class<?> type) {
        if (!type.isAssignableFrom(object.getClass()) && !type.getSimpleName().equals(object.getClass().getSimpleName())) {
            if (ConfigSerializable.class.isAssignableFrom(type) && object instanceof ConfigSection) {
                return;
            }
            throw new FoException("Malformed configuration! Key '" + path + "' in " + this.getFileName() + " must be " + type.getSimpleName() + " but got " + object.getClass().getSimpleName() + ": '" + object + "'");
        }
    }

    public final String getString(String path) {
        return this.getString(path, null);
    }

    public final String getString(String path, String def) {
        Object object = this.getObject(path, def);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return Common.join((List)object, "\n");
        }
        if (object instanceof String[]) {
            return Common.join(Arrays.asList((String[])object), "\n");
        }
        if (object.getClass().isArray()) {
            return Common.join((Object[])object);
        }
        if (object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Float) {
            return Objects.toString(object);
        }
        if (object instanceof Number) {
            return ((Number)object).toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new FoException("Excepted string at '" + path + "' in " + this.getFileName() + ", got (" + object.getClass() + "): " + object);
    }

    public final Boolean getBoolean(String path) {
        return this.getBoolean(path, null);
    }

    public final Boolean getBoolean(String path, Boolean def) {
        return this.get(path, (Class<T>)Boolean.class, (T)def, new Object[0]);
    }

    public final Integer getInteger(String path) {
        return this.getInteger(path, null);
    }

    public final Integer getInteger(String path, Integer def) {
        return this.get(path, (Class<T>)Integer.class, (T)def, new Object[0]);
    }

    public final Long getLong(String path) {
        return this.getLong(path, null);
    }

    public final Long getLong(String path, Long def) {
        return this.get(path, (Class<T>)Long.class, (T)def, new Object[0]);
    }

    public final Double getDouble(String path) {
        return this.getDouble(path, null);
    }

    public final Double getDouble(String path, Double def) {
        Object raw = this.getObject(path, def);
        if (raw != null) {
            Valid.checkBoolean(raw instanceof Number, "Expected a number at '" + path + "', got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        }
        return raw != null ? Double.valueOf(((Number)raw).doubleValue()) : null;
    }

    public final Location getLocation(String path) {
        return this.getLocation(path, null);
    }

    public final Location getLocation(String path, Location def) {
        return this.get(path, (Class<T>)Location.class, (T)def, new Object[0]);
    }

    public final OfflinePlayer getOfflinePlayer(String path) {
        return this.getOfflinePlayer(path, null);
    }

    public final OfflinePlayer getOfflinePlayer(String path, OfflinePlayer def) {
        return this.get(path, (Class<T>)OfflinePlayer.class, (T)def, new Object[0]);
    }

    public final SimpleSound getSound(String path) {
        return this.getSound(path, null);
    }

    public final SimpleSound getSound(String path, SimpleSound def) {
        return this.get(path, (Class<T>)SimpleSound.class, (T)def, new Object[0]);
    }

    public final AccusativeHelper getAccusativePeriod(String path) {
        return this.getAccusativePeriod(path, null);
    }

    public final AccusativeHelper getAccusativePeriod(String path, String def) {
        String rawLine = this.getString(path, def);
        return rawLine != null ? new AccusativeHelper(rawLine) : null;
    }

    public final TitleHelper getTitle(String path) {
        return this.getTitle(path, null, null);
    }

    public final TitleHelper getTitle(String path, String defTitle, String defSubtitle) {
        String title = this.getString(path + ".Title", defTitle);
        String subtitle = this.getString(path + ".Subtitle", defSubtitle);
        return title != null ? new TitleHelper(title, subtitle) : null;
    }

    public final SimpleTime getTime(String path) {
        return this.getTime(path, null);
    }

    public final SimpleTime getTime(String path, SimpleTime def) {
        return this.get(path, (Class<T>)SimpleTime.class, (T)def, new Object[0]);
    }

    public final Double getPercentage(String path) {
        return this.getPercentage(path, null);
    }

    public final Double getPercentage(String path, Double def) {
        Object object = this.getObject(path, def);
        if (object != null) {
            String raw = object.toString();
            Valid.checkBoolean(raw.endsWith("%"), "Your " + path + " key in " + this.getPathPrefix() + "." + path + " must end with %! Got: " + raw, new Object[0]);
            String rawNumber = raw.substring(0, raw.length() - 1);
            Valid.checkInteger(rawNumber, "Your " + path + " key in " + this.getPathPrefix() + "." + path + " must be a whole number! Got: " + raw, new Object[0]);
            return (double)Integer.parseInt(rawNumber) / 100.0;
        }
        return null;
    }

    public final BoxedMessage getBoxedMessage(String path) {
        return this.getBoxedMessage(path, null);
    }

    public final BoxedMessage getBoxedMessage(String path, BoxedMessage def) {
        return this.get(path, (Class<T>)BoxedMessage.class, (T)def, new Object[0]);
    }

    public final CompMaterial getMaterial(String path) {
        return this.getMaterial(path, null);
    }

    public final CompMaterial getMaterial(String path, CompMaterial def) {
        return this.get(path, CompMaterial.class, def, new Object[0]);
    }

    public final ItemStack getItemStack(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.getItemStack(path, null);
    }

    public final ItemStack getItemStack(@NonNull String path, ItemStack def) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.get(path, (Class<T>)ItemStack.class, (T)def, new Object[0]);
    }

    public final <K, V> Tuple<K, V> getTuple(String key, Class<K> keyType, Class<V> valueType) {
        return this.getTuple(key, null, keyType, valueType);
    }

    public final <K, V> Tuple<K, V> getTuple(String key, Tuple<K, V> def, Class<K> keyType, Class<V> valueType) {
        return this.get(key, (Class<T>)Tuple.class, (T)def, new Object[]{keyType, valueType});
    }

    public final Object getObject(String path) {
        return this.getObject(path, null);
    }

    public final Object getObject(String path, Object def) {
        return this.get(path, (Class<T>)Object.class, (T)def, new Object[0]);
    }

    public final LocationList getLocationList(String path) {
        return new LocationList(this, this.getList(path, Location.class, new Object[0]));
    }

    public final List<SerializedMap> getMapList(String path) {
        return this.getList(path, SerializedMap.class, new Object[0]);
    }

    public final <T> IsInList<T> getIsInList(String path, Class<T> type) {
        List<String> stringList = this.getStringList(path);
        if (stringList.size() == 1 && "*".equals(stringList.get(0))) {
            return IsInList.fromStar();
        }
        return IsInList.fromList(this.getList(path, type, new Object[0]));
    }

    public final List<String> getStringList(String path) {
        Object raw = this.getObject(path);
        if (raw == null) {
            return new ArrayList<String>();
        }
        if (raw instanceof String) {
            String output = (String)raw;
            return "'[]'".equals(output) || "[]".equals(output) ? new ArrayList<String>() : this.fixYamlBooleansInList(output.split("\n"));
        }
        if (raw instanceof List) {
            return this.fixYamlBooleansInList(((List)raw).toArray());
        }
        throw new FoException("Excepted a list at '" + path + "' in " + this.getFileName() + ", got (" + raw.getClass() + "): " + raw);
    }

    private List<String> fixYamlBooleansInList(Object ... list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (Object obj : list) {
            if (obj == null) continue;
            newList.add(obj.toString());
        }
        return newList;
    }

    @Nullable
    public final StrictList<String> getCommandList(String path) {
        List<String> list = this.getStringList(path);
        Valid.checkBoolean(!list.isEmpty(), "Please set at least one command alias in '" + path + "' (" + this.getFileName() + ") for this will be used as your main command!", new Object[0]);
        for (int i = 0; i < list.size(); ++i) {
            String command = list.get(i);
            command = command.startsWith("/") ? command.substring(1) : command;
            list.set(i, command);
        }
        return new StrictList<String>((Iterable<String>)list);
    }

    public final List<CompMaterial> getMaterialList(String path) {
        return this.getList(path, CompMaterial.class, new Object[0]);
    }

    public final <T> Set<T> getSet(String key, Class<T> type, Object ... deserializeParameters) {
        List<T> list = this.getList(key, type, new Object[0]);
        return list == null ? new HashSet() : new HashSet<T>(list);
    }

    public final <K, V> List<Tuple<K, V>> getTupleList(String path, Class<K> tupleKey, Class<V> tupleValue) {
        ArrayList<Tuple<K, V>> list = new ArrayList<Tuple<K, V>>();
        for (Object object : this.getList(path)) {
            if (object == null) {
                list.add(null);
                continue;
            }
            Tuple<K, V> tuple = Tuple.deserialize(SerializedMap.of(object), tupleKey, tupleValue);
            list.add(tuple);
        }
        return list;
    }

    public final <T> List<T> getList(String path, Class<T> type, Object ... deserializeParameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Object> objects = this.getList(path);
        if (type == Map.class && deserializeParameters != null & deserializeParameters.length > 0 && deserializeParameters[0] != String.class) {
            throw new FoException("getList('" + path + "') that returns Map must have String.class as key, not " + deserializeParameters[0]);
        }
        if (objects != null) {
            for (Object object : objects) {
                Object object2 = object = object != null ? (Object)SerializeUtil.deserialize(this.mode, type, object, deserializeParameters) : null;
                if (object != null) {
                    list.add(object);
                    continue;
                }
                if (type.isPrimitive() || type == String.class) continue;
                list.add(null);
            }
        }
        return list;
    }

    public final List<Object> getList(String path) {
        Object obj = this.getObject(path);
        return obj instanceof Collection ? new ArrayList<Object>((Collection)obj) : (obj != null ? Arrays.asList(obj) : new ArrayList());
    }

    public final SerializedMap getMap(String path) {
        LinkedHashMap<Object, Object> map = this.getMap(path, Object.class, Object.class, new Object[0]);
        return SerializedMap.of(map);
    }

    public final <Key, Value> LinkedHashMap<Key, Value> getMap(@NonNull String path, Class<Key> keyType, Class<Value> valueType, Object ... valueDeserializeParams) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        LinkedHashMap<Key, Value> map = new LinkedHashMap<Key, Value>();
        boolean exists = this.isSet(path);
        path = this.buildPathPrefix(path);
        if (this.defaults != null && !exists) {
            Valid.checkBoolean(this.defaults.isStored(path), "Default '" + this.getFileName() + "' lacks a map at " + path, new Object[0]);
            for (String key : this.defaults.retrieveConfigurationSection(path).getKeys(false)) {
                this.copyDefault(path + "." + key, valueType);
            }
        }
        if (exists) {
            for (Map.Entry<String, Object> entry : SerializedMap.of(this.section.retrieve(path))) {
                Object value;
                Key key = SerializeUtil.deserialize(this.mode, keyType, (Object)entry.getKey());
                if (LocationList.class.isAssignableFrom(valueType)) {
                    List list = SerializeUtil.deserialize(this.mode, List.class, entry.getValue());
                    ArrayList copy = new ArrayList();
                    list.forEach(locationRaw -> copy.add(SerializeUtil.deserializeLocation(locationRaw)));
                    value = new LocationList(this, copy);
                } else {
                    value = SerializeUtil.deserialize(this.mode, valueType, entry.getValue(), valueDeserializeParams);
                }
                this.checkAssignable(path, key, keyType);
                this.checkAssignable(path, value, valueType);
                map.put(key, value);
            }
        }
        return map;
    }

    public final <Key, Value> LinkedHashMap<Key, List<Value>> getMapList(@NonNull String path, Class<Key> keyType, Class<Value> setType, Object ... setDeserializeParameters) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        LinkedHashMap<Key, List> map = new LinkedHashMap<Key, List>();
        boolean exists = this.isSet(path);
        path = this.buildPathPrefix(path);
        if (this.defaults != null && !exists) {
            Valid.checkBoolean(this.defaults.isStored(path), "Default '" + this.getFileName() + "' lacks a map at " + path, new Object[0]);
            for (String key : this.defaults.retrieveConfigurationSection(path).getKeys(false)) {
                this.copyDefault(path + "." + key, setType);
            }
        }
        if (exists) {
            for (Map.Entry<String, Object> entry : SerializedMap.of(this.section.retrieve(path)).entrySet()) {
                Key key = SerializeUtil.deserialize(this.mode, keyType, (Object)entry.getKey());
                List value = SerializeUtil.deserialize(this.mode, List.class, entry.getValue(), setDeserializeParameters);
                this.checkAssignable(path, key, keyType);
                if (!value.isEmpty()) {
                    for (Object item : value) {
                        this.checkAssignable(path, item, setType);
                    }
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public final void save(String path, Object value) {
        this.set(path, value);
        this.save();
    }

    public final void set(String path, Object value) {
        path = this.buildPathPrefix(path);
        value = SerializeUtil.serialize(this.mode, value);
        this.section.store(path, value);
        this.shouldSave = true;
    }

    public final boolean isSet(String path) {
        path = this.buildPathPrefix(path);
        return this.section.isStored(path);
    }

    public final boolean isSetDefault(String path) {
        path = this.buildPathPrefix(path);
        return this.defaults != null && this.defaults.isStored(path);
    }

    public final void move(String fromPathRel, String toPathAbs) {
        Object oldObject = this.getObject(fromPathRel);
        this.set(fromPathRel, null);
        this.section.store(toPathAbs, oldObject);
        Common.log("&7Update " + this.getFileName() + ". Move &b'&f" + this.buildPathPrefix(fromPathRel) + "&b' &7(was '" + oldObject + "&7') to &b'&f" + toPathAbs + "&b'&r");
    }

    public final void reload() {
        Valid.checkNotNull(this.file, "Cannot call reload() before loading a file!");
        this.load(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void load(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Map<String, ConfigSection> map = loadedSections;
        synchronized (map) {
            try {
                Valid.checkBoolean(!this.loading, "Called load(" + file + ") on already being loaded configuration!", new Object[0]);
                this.loading = true;
                FileInputStream stream = new FileInputStream(file);
                String path = file.getAbsolutePath();
                boolean loadedBefore = false;
                ConfigSection section = loadedSections.get(path);
                if (section == null) {
                    section = new ConfigSection();
                    loadedSections.put(path, section);
                } else {
                    loadedBefore = true;
                }
                this.section = section;
                this.file = file;
                if (!loadedBefore || this.alwaysLoad) {
                    this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                }
                try {
                    this.onLoad();
                    this.onLoadFinish();
                }
                catch (EventHandledException eventHandledException) {
                    // empty catch block
                }
                if (this.shouldSave) {
                    this.loading = false;
                    this.save();
                    this.shouldSave = false;
                }
            }
            catch (Exception ex) {
                Common.throwError(ex, "Error loading " + file + ": " + ex);
            }
            finally {
                this.loading = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        try {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
                String line;
                while ((line = input.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
            }
            this.loadFromString(builder.toString());
        }
        catch (Exception ex) {
            Remain.sneaky(ex);
        }
    }

    abstract void loadFromString(@NonNull String var1);

    protected void onLoad() {
    }

    @Deprecated
    protected void onLoadFinish() {
    }

    public final void save() {
        Valid.checkNotNull(this.file, "Cannot call save() for " + this + " when no file was set! Call load first!");
        this.save(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Map<String, ConfigSection> map = loadedSections;
        synchronized (map) {
            block18: {
                try {
                    String data;
                    if (this.loading) {
                        this.shouldSave = true;
                        return;
                    }
                    this.onPreSave();
                    if (!this.canSaveFile()) break block18;
                    try {
                        this.onSave();
                    }
                    catch (EventHandledException eventHandledException) {
                        // empty catch block
                    }
                    File parent = file.getCanonicalFile().getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    if ((data = this.saveToString()) != null) {
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                            writer.write(data);
                        }
                        catch (Exception ex) {
                            Remain.sneaky(ex);
                        }
                    }
                    this.file = file;
                }
                catch (Exception ex) {
                    Remain.sneaky(ex);
                }
            }
        }
    }

    protected void onPreSave() {
    }

    protected void onSave() {
        SerializedMap map = this.saveToMap();
        SerializedMap legacy = this.serialize();
        if (legacy != null) {
            map.put(legacy);
        }
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean canSaveFile() {
        return true;
    }

    @NonNull
    abstract String saveToString();

    public SerializedMap saveToMap() {
        return null;
    }

    @Deprecated
    protected SerializedMap serialize() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteFile() {
        Map<String, ConfigSection> map = loadedSections;
        synchronized (map) {
            Valid.checkNotNull(this.file, "Cannot unregister null file before settings were loaded!");
            if (this.file.exists()) {
                this.file.delete();
            }
            loadedSections.remove(this.file.getAbsolutePath());
        }
    }

    protected final String getPathPrefix() {
        return this.pathPrefix;
    }

    protected final void setPathPrefix(String pathPrefix) {
        if (pathPrefix != null) {
            Valid.checkBoolean(!pathPrefix.endsWith("."), "Path prefix must not end with a dot: " + pathPrefix, new Object[0]);
            Valid.checkBoolean(!pathPrefix.endsWith(".yml"), "Path prefix must not end with .yml!", new Object[0]);
        }
        this.pathPrefix = pathPrefix != null && !pathPrefix.isEmpty() ? pathPrefix : null;
    }

    private final String buildPathPrefix(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String prefixed = this.pathPrefix != null ? this.pathPrefix + (!path.isEmpty() ? "." + path : "") : path;
        String newPath = prefixed.endsWith(".") ? prefixed.substring(0, prefixed.length() - 1) : prefixed;
        Valid.checkBoolean(!newPath.endsWith("."), "Path '" + path + "' must not end with '.' after path prefix '" + this.pathPrefix + "': " + newPath, new Object[0]);
        return newPath;
    }

    public final String getHeader() {
        return this.header;
    }

    public final void setHeader(String ... values) {
        this.header = values == null ? null : String.join((CharSequence)"\n", values);
    }

    public final void clear() {
        this.section.clear();
    }

    public String getName() {
        int lastDot;
        String fileName = this.getFileName();
        if (fileName != null && (lastDot = fileName.lastIndexOf(".")) != -1) {
            return fileName.substring(0, lastDot);
        }
        return null;
    }

    public final String getFileName() {
        return this.file == null ? "null" : this.file.getName();
    }

    public final boolean isEmpty() {
        return this.section.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static final void clearLoadedSections() {
        Map<String, ConfigSection> map = loadedSections;
        synchronized (map) {
            loadedSections.clear();
        }
    }

    protected void setFile(@Nullable File file) {
        this.file = file;
    }

    protected void setAlwaysLoad(boolean alwaysLoad) {
        this.alwaysLoad = alwaysLoad;
    }

    public static final class AccusativeHelper {
        private final String accusativeSingural;
        private final String accusativePlural;
        private final String genitivePlural;

        private AccusativeHelper(String raw) {
            String[] values = raw.split(", ");
            if (values.length == 2) {
                this.accusativeSingural = values[0];
                this.genitivePlural = this.accusativePlural = values[1];
                return;
            }
            if (values.length != 3) {
                throw new FoException("Malformed type, use format: 'second, seconds' OR 'sekundu, sekundy, sekund' (if your language has it)");
            }
            this.accusativeSingural = values[0];
            this.accusativePlural = values[1];
            this.genitivePlural = values[2];
        }

        public String getPlural() {
            return this.genitivePlural;
        }

        public String formatWithCount(long count) {
            return count + " " + this.formatWithoutCount(count);
        }

        public String formatWithoutCount(long count) {
            if (count == 1L) {
                return this.accusativeSingural;
            }
            if (count > 1L && count < 5L) {
                return this.accusativePlural;
            }
            return this.genitivePlural;
        }
    }

    public static final class TitleHelper {
        private final String title;
        private final String subtitle;

        private TitleHelper(String title, String subtitle) {
            this.title = Common.colorize(title);
            this.subtitle = Common.colorize(subtitle);
        }

        public void playLong(Player player) {
            this.playLong(player, null);
        }

        public void playLong(Player player, Function<String, String> replacer) {
            this.play(player, 5, 80, 15, replacer);
        }

        public void playShort(Player player) {
            this.playShort(player, null);
        }

        public void playShort(Player player, Function<String, String> replacer) {
            this.play(player, 3, 40, 5, replacer);
        }

        public void play(Player player, int fadeIn, int stay, int fadeOut) {
            this.play(player, fadeIn, stay, fadeOut, null);
        }

        public void play(Player player, int fadeIn, int stay, int fadeOut, Function<String, String> replacer) {
            Remain.sendTitle(player, fadeIn, stay, fadeOut, replacer != null ? replacer.apply(this.title) : this.title, replacer != null ? replacer.apply(this.subtitle) : this.subtitle);
        }
    }

    public static final class LocationList
    implements Iterable<Location> {
        private final FileConfig settings;
        private final List<Location> points;

        public LocationList(FileConfig settings) {
            this(settings, new ArrayList<Location>());
        }

        private LocationList(FileConfig settings, List<Location> points) {
            this.settings = settings;
            this.points = points;
        }

        public boolean toggle(Location location) {
            for (Location point : this.points) {
                if (!Valid.locationEquals(point, location)) continue;
                this.points.remove(point);
                this.settings.save();
                return false;
            }
            this.points.add(location);
            this.settings.save();
            return true;
        }

        public void add(Location location) {
            Valid.checkBoolean(!this.hasLocation(location), "Location at " + location + " already exists!", new Object[0]);
            this.points.add(location);
            this.settings.save();
        }

        public void remove(Location location) {
            Location point = this.find(location);
            Valid.checkNotNull(point, "Location at " + location + " does not exist!");
            this.points.remove(point);
            this.settings.save();
        }

        public boolean hasLocation(Location location) {
            return this.find(location) != null;
        }

        public Location find(Location location) {
            for (Location entrance : this.points) {
                if (!Valid.locationEquals(entrance, location)) continue;
                return entrance;
            }
            return null;
        }

        public List<Location> getLocations() {
            return Collections.unmodifiableList(this.points);
        }

        @Override
        public Iterator<Location> iterator() {
            return this.points.iterator();
        }

        public int size() {
            return this.points.size();
        }
    }
}

