/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;

public class ConfigSection {
    final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final ConfigSection root;
    private final ConfigSection parent;
    private final String path;
    private final String fullPath;

    ConfigSection() {
        this.path = "";
        this.fullPath = "";
        this.parent = null;
        this.root = this;
    }

    ConfigSection(@NonNull ConfigSection parent, @NonNull String path) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
        this.parent = parent;
        this.root = parent.root;
        this.fullPath = ConfigSection.createPath(parent, path);
    }

    @NonNull
    public final Set<String> getKeys(boolean deep) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.mapChildrenKeys(result, this, deep);
        return result;
    }

    @NonNull
    public final Map<String, Object> getValues(boolean deep) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.mapChildrenValues(result, this, deep);
        return result;
    }

    public final void clear() {
        this.map.clear();
    }

    public final boolean isStored(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.root == null) {
            return false;
        }
        return this.retrieve(path) != null;
    }

    public final void store(@NonNull String path, Object value) {
        int trailingIndex;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Cannot set to an empty path");
        }
        if (this.root == null) {
            throw new IllegalStateException("Cannot use section without a root");
        }
        int leadingIndex = -1;
        ConfigSection section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            ConfigSection subSection = section.retrieveConfigurationSection(node);
            if (subSection == null) {
                if (value == null) {
                    return;
                }
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        } else {
            section.store(key, value);
        }
    }

    public final Object retrieve(@NonNull String path) {
        int trailingIndex;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.length() == 0) {
            return this;
        }
        if (this.root == null) {
            throw new IllegalStateException("Cannot access section without a root");
        }
        int leadingIndex = -1;
        ConfigSection section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String currentPath = path.substring(trailingIndex, leadingIndex);
            if (section.retrieve(currentPath) == null) {
                return null;
            }
            if ((section = section.retrieveConfigurationSection(currentPath)) != null) continue;
            return null;
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            return this.map.get(key);
        }
        return section.retrieve(key);
    }

    public final ConfigSection retrieveConfigurationSection(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Object val = this.retrieve(path);
        if (val != null) {
            return val instanceof ConfigSection ? (ConfigSection)val : null;
        }
        return val instanceof ConfigSection ? this.createSection(path) : null;
    }

    @NonNull
    final ConfigSection createSection(@NonNull String path) {
        int trailingIndex;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Cannot create section at empty path");
        }
        if (this.root == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        int leadingIndex = -1;
        ConfigSection section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            ConfigSection subSection = section.retrieveConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            ConfigSection result = new ConfigSection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    private void mapChildrenKeys(@NonNull Set<String> output, @NonNull ConfigSection section, boolean deep) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (section instanceof ConfigSection) {
            ConfigSection sec = section;
            for (Map.Entry<String, Object> entry : sec.map.entrySet()) {
                output.add(ConfigSection.createPath(section, entry.getKey(), this));
                if (!deep || !(entry.getValue() instanceof ConfigSection)) continue;
                ConfigSection subsection = (ConfigSection)entry.getValue();
                this.mapChildrenKeys(output, subsection, deep);
            }
        } else {
            Set<String> keys = section.getKeys(deep);
            for (String key : keys) {
                output.add(ConfigSection.createPath(section, key, this));
            }
        }
    }

    private void mapChildrenValues(@NonNull Map<String, Object> output, @NonNull ConfigSection section, boolean deep) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (section instanceof ConfigSection) {
            ConfigSection sec = section;
            for (Map.Entry<String, Object> entry : sec.map.entrySet()) {
                String childPath = ConfigSection.createPath(section, entry.getKey(), this);
                output.remove(childPath);
                output.put(childPath, entry.getValue());
                if (!(entry.getValue() instanceof ConfigSection) || !deep) continue;
                this.mapChildrenValues(output, (ConfigSection)entry.getValue(), deep);
            }
        } else {
            Map<String, Object> values = section.getValues(deep);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                output.put(ConfigSection.createPath(section, entry.getKey(), this), entry.getValue());
            }
        }
    }

    @NonNull
    private static String createPath(@NonNull ConfigSection section, String key) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        return ConfigSection.createPath(section, key, section == null ? null : section.root);
    }

    @NonNull
    private static String createPath(@NonNull ConfigSection section, String key, ConfigSection relativeTo) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        ConfigSection root = section.root;
        if (root == null) {
            throw new IllegalStateException("Cannot create path without a root");
        }
        StringBuilder builder = new StringBuilder();
        if (section != null) {
            ConfigSection parent = section;
            while (parent != null && parent != relativeTo) {
                if (builder.length() > 0) {
                    builder.insert(0, '.');
                }
                builder.insert(0, parent.path);
                parent = parent.parent;
            }
        }
        if (key != null && key.length() > 0) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(key);
        }
        return builder.toString();
    }

    public final SerializedMap serialize() {
        return SerializedMap.of(this.getValues(true));
    }

    public final boolean isEmpty() {
        return Valid.isNullOrEmptyValues(this.map);
    }

    public String toString() {
        ConfigSection root = this.root;
        return this.getClass().getSimpleName() + "[path='" + this.fullPath + "', root='" + (root == null ? null : root.getClass().getSimpleName()) + "']";
    }
}

