/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.settings;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.configuration.file.YamlConfiguration;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.settings.FileConfig;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class ConfigItems<T extends YamlConfig> {
    private volatile StrictMap<String, T> loadedItemsMap = new StrictMap();
    private final String type;
    private final String folder;
    private final Function<String, Class<T>> prototypeCreator;
    private final boolean singleFile;

    private ConfigItems(String type, String folder, Function<String, Class<T>> prototypeCreator, boolean singleFile) {
        this.type = type;
        this.folder = folder;
        this.prototypeCreator = prototypeCreator;
        this.singleFile = singleFile;
    }

    public static <P extends YamlConfig> ConfigItems<P> fromFolder(String folder, Class<P> prototypeClass) {
        return ConfigItems.fromFolder(folder, (String fileName) -> prototypeClass);
    }

    public static <P extends YamlConfig> ConfigItems<P> fromFolder(String folder, Function<String, Class<P>> prototypeCreator) {
        return new ConfigItems(folder.substring(0, folder.length() - (folder.endsWith("es") && !folder.contains("variable") ? 2 : (folder.endsWith("s") ? 1 : 0))), folder, prototypeCreator, false);
    }

    public static <P extends YamlConfig> ConfigItems<P> fromFile(String path, String file, Class<P> prototypeClass) {
        return ConfigItems.fromFile(path, file, (String fileName) -> prototypeClass);
    }

    public static <P extends YamlConfig> ConfigItems<P> fromFile(String path, String file, Function<String, Class<P>> prototypeCreator) {
        return new ConfigItems(path, file, prototypeCreator, true);
    }

    public void loadItems() {
        this.loadItems(null);
    }

    public void loadItems(@Nullable Function<File, T> loader) {
        block5: {
            File[] files;
            block4: {
                this.loadedItemsMap.clear();
                if (!this.singleFile) break block4;
                File file = FileUtil.extract(this.folder);
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (!config.isSet(this.type)) break block5;
                for (String name : config.getConfigurationSection(this.type).getKeys(false)) {
                    this.loadOrCreateItem(name);
                }
                break block5;
            }
            if (!FileUtil.getFile(this.folder).exists()) {
                FileUtil.extractFolderFromJar(this.folder + "/", this.folder);
            }
            for (File file : files = FileUtil.getFiles(this.folder, "yml")) {
                if (loader != null) {
                    loader.apply(file);
                    continue;
                }
                String name = FileUtil.getFileName(file);
                this.loadOrCreateItem(name);
            }
        }
    }

    public T loadOrCreateItem(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.loadOrCreateItem(name, null);
    }

    public T loadOrCreateItem(@NonNull String name, @Nullable Supplier<T> instantiator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Valid.checkBoolean(!this.isItemLoaded(name), "Item " + (this.type == null ? "" : this.type + " ") + "named " + name + " already exists! Available: " + this.getItemNames(), new Object[0]);
        YamlConfig item = null;
        try {
            if (instantiator != null) {
                item = (YamlConfig)instantiator.get();
            } else {
                Constructor<T> constructor;
                boolean nameConstructor = true;
                Class<T> prototypeClass = this.prototypeCreator.apply(name);
                Valid.checkNotNull(prototypeClass);
                try {
                    constructor = prototypeClass.getDeclaredConstructor(String.class);
                }
                catch (Exception e) {
                    constructor = prototypeClass.getDeclaredConstructor(new Class[0]);
                    nameConstructor = false;
                }
                Valid.checkBoolean(Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers()), "Your class " + prototypeClass + " must have a private or protected constructor taking a String or nothing!", new Object[0]);
                constructor.setAccessible(true);
                try {
                    item = nameConstructor ? (YamlConfig)constructor.newInstance(name) : (YamlConfig)constructor.newInstance(new Object[0]);
                }
                catch (InstantiationException ex) {
                    Common.throwError(ex, "Failed to create new" + (this.type == null ? prototypeClass.getSimpleName() : " " + this.type) + " " + name + " from " + constructor);
                }
            }
            this.loadedItemsMap.put(name, item);
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to load" + name + (this.singleFile ? "" : " from " + this.folder));
        }
        Valid.checkNotNull(item, "Failed to initiliaze " + name + " from " + this.folder);
        return (T)item;
    }

    public void removeItem(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.removeItemByName(((FileConfig)item).getName());
    }

    public void removeItemByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        T item = this.findItem(name);
        Valid.checkNotNull(item, ChatUtil.capitalize(this.type) + " " + name + " not loaded. Available: " + this.getItemNames());
        if (this.singleFile) {
            ((FileConfig)item).save("", null);
        } else {
            ((FileConfig)item).deleteFile();
        }
        this.loadedItemsMap.remove(name);
    }

    public boolean isItemLoaded(String name) {
        return this.findItem(name) != null;
    }

    public T findItem(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        YamlConfig item = (YamlConfig)this.loadedItemsMap.get(name);
        if (item == null) {
            for (Map.Entry<String, T> entry : this.loadedItemsMap.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(name)) continue;
                return (T)((YamlConfig)entry.getValue());
            }
        }
        return (T)item;
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(new ArrayList<T>(this.loadedItemsMap.values()));
    }

    public Set<String> getItemNames() {
        return this.loadedItemsMap.keySet();
    }
}

