/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.nbt;

import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTContainer;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTReflectionUtil;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || sk.adonikeoffice.epicchat.lib.remain.nbt.MinecraftVersion.isAtLeastVersion(sk.adonikeoffice.epicchat.lib.remain.nbt.MinecraftVersion.MC1_8_R3) && !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new FoException("BlockEntity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new FoException("BlockEntity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    public NBTCompound getPersistentDataContainer() {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_14), "getPersistentDataContainer requires Minecraft 1.14+", new Object[0]);
        if (this.hasTag("PublicBukkitValues")) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

