/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.nbt.ClassWrapper;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTContainer;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTList;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTType;
import sk.adonikeoffice.epicchat.lib.remain.nbt.ReflectionMethod;

public class NBTIntArrayList
extends NBTList<int[]> {
    private final NBTContainer tmpContainer = new NBTContainer();

    protected NBTIntArrayList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(int[] object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGINTARRAY.getClazz().getDeclaredConstructor(int[].class);
            con.setAccessible(true);
            return con.newInstance(new Object[]{object});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new FoException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public int[] get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(this.listObject, index);
            ReflectionMethod.COMPOUND_SET.run(this.tmpContainer.getCompound(), "tmp", obj);
            int[] val = this.tmpContainer.getIntArray("tmp");
            this.tmpContainer.removeKey("tmp");
            return val;
        }
        catch (NumberFormatException nf) {
            return null;
        }
        catch (Exception ex) {
            throw new FoException(ex);
        }
    }
}

