/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.nbt;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTPersistentDataContainer;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTReflectionUtil;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new FoException("Entity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new FoException("Entity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    public NBTCompound getPersistentDataContainer() {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_14), "getPersistentDataContainer requires Minecraft 1.14+", new Object[0]);
        return new NBTPersistentDataContainer(this.ent.getPersistentDataContainer());
    }
}

