/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.nbt;

import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.nbt.ClassWrapper;
import sk.adonikeoffice.epicchat.lib.remain.nbt.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTList;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTListCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTType;
import sk.adonikeoffice.epicchat.lib.remain.nbt.ReflectionMethod;

public class NBTCompoundList
extends NBTList<NBTListCompound> {
    protected NBTCompoundList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    public NBTListCompound addCompound() {
        return (NBTListCompound)this.addCompound(null);
    }

    public NBTCompound addCompound(NBTCompound comp) {
        try {
            Object compound = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, this.size(), compound);
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            this.getParent().saveCompound();
            NBTListCompound listcomp = new NBTListCompound(this, compound);
            if (comp != null) {
                listcomp.mergeCompound(comp);
            }
            return listcomp;
        }
        catch (Exception ex) {
            throw new FoException(ex);
        }
    }

    @Override
    @Deprecated
    public boolean add(NBTListCompound empty) {
        return this.addCompound(empty) != null;
    }

    @Override
    public void add(int index, NBTListCompound element) {
        if (element != null) {
            throw new FoException("You need to pass null! ListCompounds from other lists won't work.");
        }
        try {
            Object compound = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, index, compound);
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            super.getParent().saveCompound();
        }
        catch (Exception ex) {
            throw new FoException(ex);
        }
    }

    @Override
    public NBTListCompound get(int index) {
        try {
            Object compound = ReflectionMethod.LIST_GET_COMPOUND.run(this.listObject, index);
            return new NBTListCompound(this, compound);
        }
        catch (Exception ex) {
            throw new FoException(ex);
        }
    }

    @Override
    public NBTListCompound set(int index, NBTListCompound element) {
        throw new FoException("This method doesn't work in the ListCompound context.");
    }

    @Override
    protected Object asTag(NBTListCompound object) {
        return null;
    }
}

