/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.nbt;

import org.bukkit.Bukkit;

enum MinecraftVersion {
    UNKNOWN(Integer.MAX_VALUE),
    MC1_7_R4(174),
    MC1_8_R3(183),
    MC1_9_R1(191),
    MC1_9_R2(192),
    MC1_10_R1(1101),
    MC1_11_R1(1111),
    MC1_12_R1(1121),
    MC1_13_R1(1131),
    MC1_13_R2(1132),
    MC1_14_R1(1141),
    MC1_15_R1(1151),
    MC1_16_R1(1161),
    MC1_16_R2(1162),
    MC1_16_R3(1163),
    MC1_17_R1(1171),
    MC1_18_R1(1181, true),
    MC1_18_R2(1182, true),
    MC1_19_R1(1191, true);

    private static MinecraftVersion version;
    private static Boolean isForgePresent;
    private final int versionId;
    private final boolean mojangMapping;

    private MinecraftVersion(int versionId) {
        this(versionId, false);
    }

    private MinecraftVersion(int versionId, boolean mojangMapping) {
        this.versionId = versionId;
        this.mojangMapping = mojangMapping;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public boolean isMojangMapping() {
        return this.mojangMapping;
    }

    public String getPackageName() {
        if (this == UNKNOWN) {
            return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return this.name().replace("MC", "v");
    }

    public static boolean isAtLeastVersion(MinecraftVersion version) {
        return MinecraftVersion.getVersion().getVersionId() >= version.getVersionId();
    }

    public static boolean isNewerThan(MinecraftVersion version) {
        return MinecraftVersion.getVersion().getVersionId() > version.getVersionId();
    }

    public static MinecraftVersion getVersion() {
        if (version != null) {
            return version;
        }
        String ver = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            version = MinecraftVersion.valueOf(ver.replace("v", "MC"));
        }
        catch (IllegalArgumentException ex) {
            version = UNKNOWN;
        }
        return version;
    }

    public static boolean isForgePresent() {
        if (isForgePresent != null) {
            return isForgePresent;
        }
        try {
            if (MinecraftVersion.getVersion() == MC1_7_R4) {
                Class.forName("cpw.mods.fml.common.Loader");
            } else {
                Class.forName("net.minecraftforge.fml.common.Loader");
            }
            isForgePresent = true;
        }
        catch (Exception ex) {
            isForgePresent = false;
        }
        return isForgePresent;
    }
}

