/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompBarColor;
import sk.adonikeoffice.epicchat.lib.remain.CompBarStyle;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon_v1_6;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon_v1_7;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon_v1_8;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon_v1_8Hack;
import sk.adonikeoffice.epicchat.lib.remain.internal.NMSDragon_v1_9;

public final class BossBarInternals
implements Listener {
    private static BossBarInternals instance = new BossBarInternals();
    private final Class<?> entityClass;
    private final HashMap<UUID, NMSDragon> players = new HashMap();
    private final HashMap<UUID, Integer> timers = new HashMap();

    private BossBarInternals() {
        this.entityClass = MinecraftVersion.olderThan(MinecraftVersion.V.v1_6) ? null : (Remain.isProtocol18Hack() ? NMSDragon_v1_8Hack.class : (MinecraftVersion.equals(MinecraftVersion.V.v1_6) ? NMSDragon_v1_6.class : (MinecraftVersion.equals(MinecraftVersion.V.v1_7) ? NMSDragon_v1_7.class : (MinecraftVersion.equals(MinecraftVersion.V.v1_8) ? NMSDragon_v1_8.class : NMSDragon_v1_9.class))));
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_6)) {
            Valid.checkNotNull(this.entityClass, "Compatible does not support Boss bar on MC version " + MinecraftVersion.getServerVersion() + "!");
            Common.registerEvents(this);
            if (Remain.isProtocol18Hack()) {
                Common.runTimer(5, () -> {
                    for (UUID uuid : this.players.keySet()) {
                        Player player = Remain.getPlayerByUUID(uuid);
                        Remain.sendPacket(player, this.players.get(uuid).getTeleportPacket(this.getDragonLocation(player.getLocation())));
                    }
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)SimplePlugin.getInstance())) {
            this.stop();
        }
    }

    private void stop() {
        for (Player player : Remain.getOnlinePlayers()) {
            this.removeBar(player);
        }
        this.players.clear();
        Iterator<Object> iterator = this.timers.values().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Bukkit.getScheduler().cancelTask(n);
        }
        this.timers.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeBar(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        this.removeBar(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.handleTeleport(event.getPlayer(), event.getTo().clone());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerRespawnEvent event) {
        this.handleTeleport(event.getPlayer(), event.getRespawnLocation().clone());
    }

    private void handleTeleport(Player player, Location loc) {
        if (!this.hasBar(player)) {
            return;
        }
        NMSDragon oldDragon = this.getDragon(player, "");
        if (oldDragon instanceof NMSDragon_v1_9 || oldDragon == null) {
            return;
        }
        Common.runLater(2, () -> {
            if (!this.hasBar(player)) {
                return;
            }
            float health = oldDragon.getHealth();
            String message = oldDragon.getName();
            Remain.sendPacket(player, this.getDragon(player, "").getDestroyPacket());
            this.players.remove(player.getUniqueId());
            NMSDragon dragon = this.addDragon(player, loc, message);
            dragon.setHealthF(health);
            this.sendDragon(dragon, player);
        });
    }

    public void setMessage(Player player, String message, float percent, CompBarColor color, CompBarStyle style) {
        Valid.checkBoolean(0.0f <= percent && percent <= 100.0f, "Percent must be between 0F and 100F, but was: " + percent, new Object[0]);
        if (this.entityClass == null) {
            return;
        }
        if (this.hasBar(player)) {
            this.removeBar(player);
        }
        message = Common.colorize(message);
        NMSDragon dragon = this.getDragon(player, message);
        dragon.setName(BossBarInternals.cleanMessage(message));
        dragon.setHealthF(percent / 100.0f * dragon.getMaxHealth());
        if (color != null) {
            dragon.barColor = color;
        }
        if (style != null) {
            dragon.barStyle = style;
        }
        this.cancelTimer(player);
        this.sendDragon(dragon, player);
    }

    public void setMessage(Player player, String message, int seconds, CompBarColor color, CompBarStyle style) {
        Valid.checkBoolean(seconds > 0, "Seconds must be > 1 ", new Object[0]);
        if (this.entityClass == null) {
            return;
        }
        if (this.hasBar(player)) {
            this.removeBar(player);
        }
        message = Common.colorize(message);
        NMSDragon dragon = this.getDragon(player, message);
        dragon.setName(BossBarInternals.cleanMessage(message));
        dragon.setHealthF(dragon.getMaxHealth());
        if (color != null) {
            dragon.barColor = color;
        }
        if (style != null) {
            dragon.barStyle = style;
        }
        float dragonHealthMinus = dragon.getMaxHealth() / (float)seconds;
        this.cancelTimer(player);
        this.timers.put(player.getUniqueId(), Common.runTimer(20, 20, () -> {
            NMSDragon drag = this.getDragon(player, "");
            drag.setHealthF(drag.getHealth() - dragonHealthMinus);
            if (drag.getHealth() <= 1.0f) {
                this.removeBar(player);
                this.cancelTimer(player);
            } else {
                this.sendDragon(drag, player);
            }
        }).getTaskId());
        this.sendDragon(dragon, player);
    }

    public void removeBar(Player player) {
        if (this.entityClass == null) {
            return;
        }
        if (!this.hasBar(player)) {
            return;
        }
        NMSDragon dragon = this.getDragon(player, "");
        if (dragon instanceof NMSDragon_v1_9) {
            ((NMSDragon_v1_9)dragon).removePlayer(player);
        } else {
            Remain.sendPacket(player, this.getDragon(player, "").getDestroyPacket());
        }
        this.players.remove(player.getUniqueId());
        this.cancelTimer(player);
    }

    private boolean hasBar(Player player) {
        return this.players.containsKey(player.getUniqueId());
    }

    private static String cleanMessage(String message) {
        if (message.length() > 64) {
            message = message.substring(0, 63);
        }
        return message;
    }

    private void cancelTimer(Player player) {
        Integer timerID = this.timers.remove(player.getUniqueId());
        if (timerID != null) {
            Bukkit.getScheduler().cancelTask(timerID.intValue());
        }
    }

    private void sendDragon(NMSDragon dragon, Player player) {
        if (dragon instanceof NMSDragon_v1_9) {
            NMSDragon_v1_9 bar = (NMSDragon_v1_9)dragon;
            bar.addPlayer(player);
            bar.setProgress(dragon.getHealth() / dragon.getMaxHealth());
        } else {
            Remain.sendPacket(player, dragon.getMetaPacket(dragon.getWatcher()));
            Remain.sendPacket(player, dragon.getTeleportPacket(this.getDragonLocation(player.getLocation())));
        }
    }

    private NMSDragon getDragon(Player player, String message) {
        if (this.hasBar(player)) {
            return this.players.get(player.getUniqueId());
        }
        return this.addDragon(player, BossBarInternals.cleanMessage(message));
    }

    private NMSDragon addDragon(Player player, String message) {
        return this.addDragon(player, player.getLocation(), message);
    }

    private NMSDragon addDragon(Player player, Location loc, String message) {
        NMSDragon dragon = this.newDragon(message, this.getDragonLocation(loc));
        if (dragon instanceof NMSDragon_v1_9) {
            ((NMSDragon_v1_9)dragon).addPlayer(player);
        } else {
            Remain.sendPacket(player, dragon.getSpawnPacket());
        }
        this.players.put(player.getUniqueId(), dragon);
        return dragon;
    }

    private Location getDragonLocation(Location loc) {
        float pitch = loc.getPitch();
        if (pitch >= 55.0f) {
            loc.add(0.0, -3.0, 0.0);
        } else if (pitch <= -55.0f) {
            loc.add(0.0, 3.0, 0.0);
        } else {
            loc = loc.getBlock().getRelative(BossBarInternals.getDirection(loc), Bukkit.getViewDistance() * 16).getLocation();
        }
        loc.subtract(0.0, 10.0, 0.0);
        return loc;
    }

    private static BlockFace getDirection(Location loc) {
        float dir = Math.round(loc.getYaw() / 90.0f);
        if (dir == -4.0f || dir == 0.0f || dir == 4.0f) {
            return BlockFace.SOUTH;
        }
        if (dir == -1.0f || dir == 3.0f) {
            return BlockFace.EAST;
        }
        if (dir == -2.0f || dir == 2.0f) {
            return BlockFace.NORTH;
        }
        if (dir == -3.0f || dir == 1.0f) {
            return BlockFace.WEST;
        }
        return null;
    }

    private NMSDragon newDragon(String message, Location loc) {
        NMSDragon fakeDragon = null;
        try {
            fakeDragon = (NMSDragon)this.entityClass.getConstructor(String.class, Location.class).newInstance(message, loc);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return fakeDragon;
    }

    public static BossBarInternals getInstance() {
        return instance;
    }
}

