/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import com.google.gson.Gson;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.data.type.Bed;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Bed;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.UUIDToNameConverter;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.AdvancementAccessor;
import sk.adonikeoffice.epicchat.lib.remain.BungeeChatProvider;
import sk.adonikeoffice.epicchat.lib.remain.CompBarColor;
import sk.adonikeoffice.epicchat.lib.remain.CompBarStyle;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompParticle;
import sk.adonikeoffice.epicchat.lib.remain.CompProperty;
import sk.adonikeoffice.epicchat.lib.remain.CompToastStyle;
import sk.adonikeoffice.epicchat.lib.remain.PotionSetter;
import sk.adonikeoffice.epicchat.lib.remain.SneakyThrow;
import sk.adonikeoffice.epicchat.lib.remain.internal.BossBarInternals;
import sk.adonikeoffice.epicchat.lib.remain.internal.ChatInternals;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTEntity;

public final class Remain {
    private static final Pattern RGB_HEX_ENCODED_REGEX;
    private static final Gson gson;
    private static final Method getPlayersMethod;
    private static final Method getHealthMethod;
    private static Method getHandle;
    private static Field fieldPlayerConnection;
    private static Field fieldEntityInvulnerable;
    private static Method sendPacket;
    private static boolean isGetPlayersCollection;
    private static boolean isGetHealthDouble;
    private static boolean hasExtendedPlayerTitleAPI;
    private static boolean hasParticleAPI;
    private static boolean newScoreboardAPI;
    private static boolean hasBookEvent;
    private static boolean hasInventoryLocation;
    private static boolean hasScoreboardTags;
    private static boolean hasSpawnEggMeta;
    private static boolean hasAdvancements;
    private static boolean hasYamlReaderLoad;
    private static boolean bungeeApiPresent;
    private static boolean hasItemMeta;
    private static boolean hasAddPassenger;
    private static final StrictMap<UUID, StrictMap<Material, Integer>> cooldowns;
    private static Class<?> sectionPathDataClass;
    private static String serverName;

    private Remain() {
    }

    public static Object getHandleWorld(World world) {
        Object nms = null;
        Method handle = ReflectionUtil.getMethod(world.getClass(), "getHandle");
        try {
            nms = handle.invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return nms;
    }

    public static Object getHandleEntity(Entity entity) {
        Object nms_entity = null;
        Method handle = ReflectionUtil.getMethod(entity.getClass(), "getHandle");
        try {
            nms_entity = handle.invoke((Object)entity, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return nms_entity;
    }

    public static boolean isProtocol18Hack() {
        if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_9)) {
            return false;
        }
        try {
            ReflectionUtil.getNMSClass("PacketPlayOutEntityTeleport", "N/A").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object playerConnection = Remain.getPlayerConnection(player);
            if (playerConnection != null) {
                sendPacket.invoke(playerConnection, packet);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException(ex, "Error sending packet " + packet.getClass() + " to player " + player.getName());
        }
    }

    public static Object getPlayerConnection(Player player) {
        if (getHandle == null || fieldPlayerConnection == null || sendPacket == null) {
            Common.log("Cannot get player connection on your server sofware (known to be broken on Cauldron).");
            return null;
        }
        try {
            Object handle = getHandle.invoke((Object)player, new Object[0]);
            Object playerConnection = fieldPlayerConnection.get(handle);
            return playerConnection;
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException(ex, "Error getting player connection for player " + player.getName());
        }
    }

    public static int getHealth(LivingEntity entity) {
        return isGetHealthDouble ? (int)entity.getHealth() : Remain.getHealhLegacy(entity);
    }

    public static int getMaxHealth(LivingEntity entity) {
        return isGetHealthDouble ? (int)entity.getMaxHealth() : Remain.getMaxHealhLegacy(entity);
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return isGetPlayersCollection ? Bukkit.getOnlinePlayers() : Arrays.asList(Remain.getPlayersLegacy());
    }

    public static int getViewDistance(Player player) {
        try {
            return player.getClientViewDistance();
        }
        catch (NoSuchMethodError err) {
            Method getViewDistance = ReflectionUtil.getMethod(player.spigot().getClass(), "getViewDistance");
            return (Integer)ReflectionUtil.invoke(getViewDistance, (Object)player.spigot(), new Object[0]);
        }
    }

    public static FallingBlock spawnFallingBlock(Block block) {
        return Remain.spawnFallingBlock(block.getLocation().add(0.5, 0.0, 0.5), block.getType(), block.getData());
    }

    public static FallingBlock spawnFallingBlock(Location loc, Block block) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            return loc.getWorld().spawnFallingBlock(loc, block.getBlockData());
        }
        try {
            return (FallingBlock)loc.getWorld().getClass().getMethod("spawnFallingBlock", Location.class, Integer.TYPE, Byte.TYPE).invoke((Object)loc.getWorld(), loc, ReflectionUtil.invoke("getTypeId", (Object)block, new Object[0]), block.getData());
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material material) {
        return Remain.spawnFallingBlock(loc, material, (byte)0);
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material material, byte data) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            return loc.getWorld().spawnFallingBlock(loc, material, data);
        }
        try {
            return (FallingBlock)loc.getWorld().getClass().getMethod("spawnFallingBlock", Location.class, Integer.TYPE, Byte.TYPE).invoke((Object)loc.getWorld(), loc, material.getId(), data);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Item spawnItem(Location location, ItemStack item, Consumer<Item> modifier) {
        try {
            Class<?> nmsWorldClass = ReflectionUtil.getNMSClass("World", "net.minecraft.world.level.World");
            Class<?> nmsStackClass = ReflectionUtil.getNMSClass("ItemStack", "net.minecraft.world.item.ItemStack");
            Class<?> nmsEntityClass = ReflectionUtil.getNMSClass("Entity", "net.minecraft.world.entity.Entity");
            Class<?> nmsItemClass = ReflectionUtil.getNMSClass("EntityItem", "net.minecraft.world.entity.item.EntityItem");
            Constructor<?> entityConstructor = nmsItemClass.getConstructor(nmsWorldClass, Double.TYPE, Double.TYPE, Double.TYPE, nmsStackClass);
            Object nmsWorld = location.getWorld().getClass().getMethod("getHandle", new Class[0]).invoke((Object)location.getWorld(), new Object[0]);
            Method asNmsCopy = ReflectionUtil.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class);
            Object nmsEntity = entityConstructor.newInstance(nmsWorld, location.getX(), location.getY(), location.getZ(), asNmsCopy.invoke(null, item));
            Class<?> craftItemClass = ReflectionUtil.getOBCClass("entity.CraftItem");
            Class<?> craftServerClass = ReflectionUtil.getOBCClass("CraftServer");
            Object bukkitItem = craftItemClass.getConstructor(craftServerClass, nmsItemClass).newInstance(Bukkit.getServer(), nmsEntity);
            Valid.checkBoolean(bukkitItem instanceof Item, "Failed to make an dropped item, got " + bukkitItem.getClass().getSimpleName(), new Object[0]);
            modifier.accept((Item)bukkitItem);
            Method addEntity = location.getWorld().getClass().getMethod("addEntity", nmsEntityClass, CreatureSpawnEvent.SpawnReason.class);
            addEntity.invoke((Object)location.getWorld(), nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return (Item)bukkitItem;
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Error spawning item " + item.getType() + " at " + location);
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack itemStack) {
        try {
            Method asNmsCopy = ReflectionUtil.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class);
            return asNmsCopy.invoke(null, itemStack);
        }
        catch (ReflectiveOperationException ex) {
            Common.throwError(ex, "Unable to convert item to NMS item: " + itemStack);
            return null;
        }
    }

    public static void setData(Block block, int data) {
        try {
            Block.class.getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)data);
        }
        catch (NoSuchMethodException ex) {
            block.setBlockData(Bukkit.getUnsafe().fromLegacy(block.getType(), (byte)data), true);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    public static void setTypeAndData(Block block, Material material, byte data) {
        Remain.setTypeAndData(block, CompMaterial.fromLegacy(material.name(), data));
    }

    public static void setTypeAndData(Block block, CompMaterial material) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            block.setType(material.getMaterial());
        } else {
            try {
                block.getClass().getMethod("setTypeIdAndData", Integer.TYPE, Byte.TYPE, Boolean.TYPE).invoke((Object)block, material.getId(), material.getData(), true);
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setBed(Location initialLocation, BlockFace facing) {
        Remain.setBed(initialLocation.getBlock(), facing);
    }

    public static void setBed(Block initialBlock, BlockFace facing) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            for (Bed.Part part : Bed.Part.values()) {
                initialBlock.setBlockData(Bukkit.createBlockData((Material)CompMaterial.WHITE_BED.getMaterial(), data -> {
                    ((org.bukkit.block.data.type.Bed)data).setPart(part);
                    ((org.bukkit.block.data.type.Bed)data).setFacing(facing);
                }));
                initialBlock = initialBlock.getRelative(facing.getOppositeFace());
            }
        } else {
            initialBlock = initialBlock.getRelative(facing);
            Material bedMaterial = Material.valueOf((String)"BED_BLOCK");
            Block bedFootBlock = initialBlock.getRelative(facing.getOppositeFace());
            BlockState bedFootState = bedFootBlock.getState();
            bedFootState.setType(bedMaterial);
            Bed bedFootData = new Bed(bedMaterial);
            bedFootData.setHeadOfBed(false);
            bedFootData.setFacingDirection(facing);
            bedFootState.setData((MaterialData)bedFootData);
            bedFootState.update(true);
            BlockState bedHeadState = initialBlock.getState();
            bedHeadState.setType(bedMaterial);
            Bed bedHeadData = new Bed(bedMaterial);
            bedHeadData.setHeadOfBed(true);
            bedHeadData.setFacingDirection(facing);
            bedHeadState.setData((MaterialData)bedHeadData);
            bedHeadState.update(true);
        }
    }

    public static String toLegacyText(String json) throws InteractiveTextFoundException {
        return Remain.toLegacyText(json, true);
    }

    public static String toLegacyText(String json, boolean denyEvents) throws InteractiveTextFoundException {
        StringBuilder text;
        block5: {
            Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
            text = new StringBuilder();
            if (json.contains("\"translate\"")) {
                return text.append("").toString();
            }
            try {
                for (BaseComponent comp : ComponentSerializer.parse((String)json)) {
                    if ((comp.getHoverEvent() != null || comp.getClickEvent() != null) && denyEvents) {
                        throw new InteractiveTextFoundException();
                    }
                    text.append(comp.toLegacyText());
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof InteractiveTextFoundException)) break block5;
                throw throwable;
            }
        }
        return text.toString();
    }

    public static String toJson(Collection<String> list) {
        return gson.toJson(list);
    }

    public static List<String> fromJsonList(String json) {
        return (List)gson.fromJson(json, List.class);
    }

    public static String toJson(String message) {
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        return Remain.toJson(TextComponent.fromLegacyText((String)message));
    }

    public static String toJson(BaseComponent ... comps) {
        String json;
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        try {
            json = ComponentSerializer.toString((BaseComponent[])comps);
        }
        catch (Throwable t) {
            json = new Gson().toJson((Object)new TextComponent(comps).toLegacyText());
        }
        return json;
    }

    public static String toJson(ItemStack item) {
        Class<?> craftItemstack = ReflectionUtil.getOBCClass("inventory.CraftItemStack");
        Method asNMSCopyMethod = ReflectionUtil.getMethod(craftItemstack, "asNMSCopy", ItemStack.class);
        Class<?> nmsItemStack = ReflectionUtil.getNMSClass("ItemStack", "net.minecraft.world.item.ItemStack");
        Class<?> nbtTagCompound = ReflectionUtil.getNMSClass("NBTTagCompound", "net.minecraft.nbt.NBTTagCompound");
        Method saveItemstackMethod = ReflectionUtil.getMethod(nmsItemStack, MinecraftVersion.atLeast(MinecraftVersion.V.v1_18) ? "b" : "save", nbtTagCompound);
        Object nmsNbtTagCompoundObj = ReflectionUtil.instantiate(nbtTagCompound);
        Object nmsItemStackObj = ReflectionUtil.invoke(asNMSCopyMethod, null, item);
        Object itemAsJsonObject = ReflectionUtil.invoke(saveItemstackMethod, nmsItemStackObj, nmsNbtTagCompoundObj);
        return itemAsJsonObject.toString();
    }

    public static BaseComponent[] toComponent(String json) {
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        try {
            return ComponentSerializer.parse((String)json);
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to call toComponent!", "Json: " + json, "Error: %error%");
            return null;
        }
    }

    public static void sendJson(CommandSender sender, String json, SerializedMap placeholders) {
        try {
            BaseComponent[] components = ComponentSerializer.parse((String)json);
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
                Remain.replaceHexPlaceholders(Arrays.asList(components), placeholders);
            }
            Remain.sendComponent(sender, components);
        }
        catch (RuntimeException ex) {
            Common.error(ex, "Malformed JSON when sending message to " + sender.getName() + " with JSON: " + json);
        }
    }

    private static void replaceHexPlaceholders(List<BaseComponent> components, SerializedMap placeholders) {
        for (BaseComponent component : components) {
            if (component instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)component;
                String text = textComponent.getText();
                for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
                    String key = entry.getKey();
                    String value = Common.simplify(entry.getValue());
                    Matcher match = RGB_HEX_ENCODED_REGEX.matcher(text);
                    while (match.find()) {
                        String color = "#" + match.group(2).replace("\u00a7", "");
                        value = match.replaceAll("");
                        textComponent.setColor(ChatColor.of((String)color));
                    }
                    key = key.charAt(0) != '{' ? "{" + key : key;
                    key = key.charAt(key.length() - 1) != '}' ? key + "}" : key;
                    text = text.replace(key, value);
                    textComponent.setText(text);
                }
            }
            if (component.getExtra() != null) {
                Remain.replaceHexPlaceholders(component.getExtra(), placeholders);
            }
            if (component.getHoverEvent() == null) continue;
            Remain.replaceHexPlaceholders(Arrays.asList(component.getHoverEvent().getValue()), placeholders);
        }
    }

    public static void sendJson(CommandSender sender, String json) {
        try {
            Remain.sendComponent(sender, ComponentSerializer.parse((String)json));
        }
        catch (Throwable t) {
            if (t.toString().contains("missing 'text' property")) {
                return;
            }
            throw new RuntimeException("Malformed JSON when sending message to " + sender.getName() + " with JSON: " + json, t);
        }
    }

    public static void sendComponent(CommandSender sender, Object comps) {
        BungeeChatProvider.sendComponent(sender, comps);
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        Remain.sendTitle(player, 20, 60, 20, title, subtitle);
    }

    public static void sendTitle(Player player, int fadeIn, int stay, int fadeOut, String title, String subtitle) {
        if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
            if (hasExtendedPlayerTitleAPI) {
                player.sendTitle(Common.colorize(title), Common.colorize(subtitle), fadeIn, stay, fadeOut);
            } else {
                ChatInternals.sendTitleLegacy(player, fadeIn, stay, fadeOut, title, subtitle);
            }
        } else {
            Common.tell((CommandSender)player, title);
            Common.tell((CommandSender)player, subtitle);
        }
    }

    public static void resetTitle(Player player) {
        if (hasExtendedPlayerTitleAPI) {
            player.resetTitle();
        } else {
            ChatInternals.resetTitleLegacy(player);
        }
    }

    public static void sendTablist(Player player, String header, String footer) {
        Valid.checkBoolean(MinecraftVersion.newerThan(MinecraftVersion.V.v1_7), "Sending tab list requires Minecraft 1.8x or newer!", new Object[0]);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            player.setPlayerListHeaderFooter(Common.colorize(header), Common.colorize(footer));
        } else {
            ChatInternals.sendTablistLegacy(player, header, footer);
        }
    }

    public static void sendActionBar(Player player, String text) {
        if (!MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
            Common.tell((CommandSender)player, text);
            return;
        }
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)SimpleComponent.of(Common.colorize(text)).build((CommandSender)player));
        }
        catch (NoSuchMethodError err) {
            ChatInternals.sendActionBarLegacy(player, text);
        }
    }

    public static void sendBossbarPercent(Player player, String message, float percent) {
        Remain.sendBossbarPercent(player, message, percent, null, null);
    }

    public static void sendBossbarPercent(Player player, String message, float percent, CompBarColor color, CompBarStyle style) {
        BossBarInternals.getInstance().setMessage(player, message, percent, color, style);
    }

    public static void sendBossbarTimed(Player player, String message, int seconds) {
        Remain.sendBossbarTimed(player, message, seconds, null, null);
    }

    public static void sendBossbarTimed(Player player, String message, int seconds, CompBarColor color, CompBarStyle style) {
        BossBarInternals.getInstance().setMessage(player, message, seconds, color, style);
    }

    public static void removeBossbar(Player player) {
        BossBarInternals.getInstance().removeBar(player);
    }

    public static void sendChestClose(Block block) {
        Remain.sendChestAction(block, 0);
    }

    public static void sendChestOpen(Block block) {
        Remain.sendChestAction(block, 1);
    }

    private static void sendChestAction(Block block, int action) {
        BlockState state = block.getState();
        Valid.checkBoolean(state instanceof Chest, "You can only send chest action packet for chests not " + block, new Object[0]);
        try {
            if (action == 1) {
                ((Chest)state).open();
            } else {
                ((Chest)state).close();
            }
        }
        catch (NoSuchMethodError t) {
            Location location = block.getLocation();
            Class<?> blockClass = ReflectionUtil.getNMSClass("Block");
            Class<?> blocks = ReflectionUtil.getNMSClass("Blocks");
            Object position = ReflectionUtil.instantiate(ReflectionUtil.getConstructorNMS("BlockPosition", Double.TYPE, Double.TYPE, Double.TYPE), location.getX(), location.getY(), location.getZ());
            Object packet = ReflectionUtil.instantiate(ReflectionUtil.getConstructorNMS("PacketPlayOutBlockAction", ReflectionUtil.getNMSClass("BlockPosition"), blockClass, Integer.TYPE, Integer.TYPE), position, ReflectionUtil.getStaticFieldContent(blocks, "CHEST"), 1, action);
            for (Player player : Remain.getOnlinePlayers()) {
                Remain.sendPacket(player, packet);
            }
        }
    }

    public static PluginCommand newCommand(String label) {
        try {
            Constructor con = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            con.setAccessible(true);
            return (PluginCommand)con.newInstance(new Object[]{label, SimplePlugin.getInstance()});
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Unable to create command: /" + label);
        }
    }

    public static void setCommandName(PluginCommand command, String name) {
        try {
            command.setName(name);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void registerCommand(Command command) {
        SimpleCommandMap commandMap = Remain.getCommandMap();
        commandMap.register(command.getLabel(), command);
        Valid.checkBoolean(command.isRegistered(), "Command /" + command.getLabel() + " could not have been registered properly!", new Object[0]);
    }

    public static void unregisterCommand(String label) {
        Remain.unregisterCommand(label, true);
    }

    public static void unregisterCommand(String label, boolean removeAliases) {
        try {
            PluginCommand command = Bukkit.getPluginCommand((String)label);
            if (command != null) {
                Field commandField = Command.class.getDeclaredField("commandMap");
                commandField.setAccessible(true);
                if (command.isRegistered()) {
                    command.unregister((CommandMap)commandField.get(command));
                }
            }
            Field f = SimpleCommandMap.class.getDeclaredField("knownCommands");
            f.setAccessible(true);
            Map cmdMap = (Map)f.get(Remain.getCommandMap());
            cmdMap.remove(label);
            if (command != null && removeAliases) {
                for (String alias : command.getAliases()) {
                    cmdMap.remove(alias);
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Failed to unregister command /" + label);
        }
    }

    public static SimpleCommandMap getCommandMap() {
        Class<?> craftServer = ReflectionUtil.getOBCClass("CraftServer");
        try {
            return (SimpleCommandMap)craftServer.getDeclaredMethod("getCommandMap", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            try {
                return (SimpleCommandMap)ReflectionUtil.getFieldContent(Bukkit.getServer(), "commandMap");
            }
            catch (Throwable ex2) {
                throw new FoException(ex2, "Unable to get the command map");
            }
        }
    }

    public static void registerEnchantment(Enchantment enchantment) {
        Remain.unregisterEnchantment(enchantment);
        ReflectionUtil.setStaticField(Enchantment.class, "acceptingNew", true);
        Enchantment.registerEnchantment((Enchantment)enchantment);
    }

    public static void unregisterEnchantment(Enchantment enchantment) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            Map byKey = (Map)ReflectionUtil.getStaticFieldContent(Enchantment.class, "byKey");
            byKey.remove(enchantment.getKey());
        }
        Map byName = (Map)ReflectionUtil.getStaticFieldContent(Enchantment.class, "byName");
        byName.remove(enchantment.getName());
    }

    public static Location getLocation(Inventory inv) {
        if (hasInventoryLocation) {
            try {
                return inv.getLocation();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
        return inv.getHolder() instanceof BlockState ? ((BlockState)inv.getHolder()).getLocation() : (!inv.getViewers().isEmpty() ? ((HumanEntity)inv.getViewers().iterator().next()).getLocation() : null);
    }

    public static Biome getBiome(Location loc) {
        try {
            return loc.getWorld().getBiome(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
        catch (NoSuchMethodError err) {
            return loc.getWorld().getBiome(loc.getBlockX(), loc.getBlockZ());
        }
    }

    public static String getLocale(Player player) {
        try {
            return player.getLocale();
        }
        catch (Throwable t) {
            try {
                Player.Spigot spigot = player.spigot();
                Method method = ReflectionUtil.getMethod(spigot.getClass(), "getLocale");
                return (String)ReflectionUtil.invoke(method, (Object)spigot, new Object[0]);
            }
            catch (Throwable tt) {
                return null;
            }
        }
    }

    public static String getNMSStatisticName(Statistic stat, Material mat, EntityType en) {
        Class<?> craftStatistic = ReflectionUtil.getOBCClass("CraftStatistic");
        Object nmsStatistic = null;
        try {
            nmsStatistic = stat.getType() == Statistic.Type.UNTYPED ? craftStatistic.getMethod("getNMSStatistic", stat.getClass()).invoke(null, stat) : (stat.getType() == Statistic.Type.ENTITY ? craftStatistic.getMethod("getEntityStatistic", stat.getClass(), en.getClass()).invoke(null, stat, en) : craftStatistic.getMethod("getMaterialStatistic", stat.getClass(), mat.getClass()).invoke(null, stat, mat));
            Valid.checkNotNull(nmsStatistic, "Could not get NMS statistic from Bukkit's " + stat);
            if (MinecraftVersion.equals(MinecraftVersion.V.v1_8)) {
                Field f = nmsStatistic.getClass().getField("name");
                f.setAccessible(true);
                return f.get(nmsStatistic).toString();
            }
            return (String)nmsStatistic.getClass().getMethod(MinecraftVersion.atLeast(MinecraftVersion.V.v1_18) ? "d" : "getName", new Class[0]).invoke(nmsStatistic, new Object[0]);
        }
        catch (Throwable t) {
            throw new FoException(t, "Error getting NMS statistic name from " + stat);
        }
    }

    public static void respawn(Player player) {
        Remain.respawn(player, 2);
    }

    public static void respawn(Player player, int delayTicks) {
        Common.runLater(delayTicks, () -> {
            try {
                player.spigot().respawn();
            }
            catch (NoSuchMethodError err) {
                try {
                    Constructor<?>[] constructors;
                    Object respawnEnum = ReflectionUtil.getNMSClass("EnumClientCommand", "N/A").getEnumConstants()[0];
                    for (Constructor<?> constructor : constructors = ReflectionUtil.getNMSClass("PacketPlayInClientCommand", "N/A").getConstructors()) {
                        Class<?>[] args = constructor.getParameterTypes();
                        if (args.length != 1 || args[0] != respawnEnum.getClass()) continue;
                        Object packet = ReflectionUtil.getNMSClass("PacketPlayInClientCommand", "N/A").getConstructor(args).newInstance(respawnEnum);
                        Remain.sendPacket(player, packet);
                    }
                }
                catch (Throwable e) {
                    throw new FoException(e, "Failed to send respawn packet to " + player.getName());
                }
            }
        });
    }

    public static void openBook(Player player, ItemStack book) {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_8), "Opening books is only supported on MC 1.8 and greater", new Object[0]);
        Valid.checkBoolean(book.getItemMeta() instanceof BookMeta, "openBook method called for not a book item: " + book, new Object[0]);
        BookMeta meta = (BookMeta)book.getItemMeta();
        if (meta.getAuthor() == null) {
            meta.setAuthor("");
        }
        if (meta.getTitle() == null) {
            meta.setTitle("");
        }
        if (meta.getPageCount() == 0) {
            meta.setPages(new String[]{""});
        }
        book.setItemMeta((ItemMeta)meta);
        try {
            player.openBook(book);
        }
        catch (NoSuchMethodError ex) {
            ItemStack oldItem = player.getItemInHand();
            player.setItemInHand(book);
            Object craftPlayer = Remain.getHandleEntity((Entity)player);
            Object nmsItemstack = Remain.asNMSCopy(book);
            Common.runLater(() -> {
                Method openInventory = ReflectionUtil.getMethod(craftPlayer.getClass(), "openBook", nmsItemstack.getClass());
                ReflectionUtil.invoke(openInventory, craftPlayer, nmsItemstack);
                player.setItemInHand(oldItem);
            });
        }
    }

    @Deprecated
    public static void updateInventoryTitle(Player player, String title) {
        try {
            Object packetOpenWindow;
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_17) || MinecraftVersion.atLeast(MinecraftVersion.V.v1_18)) {
                String containerName;
                boolean is1_18 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_18);
                boolean is1_19 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_19);
                Object nmsPlayer = Remain.getHandleEntity((Entity)player);
                Object chatComponent = Remain.toIChatBaseComponentPlain(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title));
                int inventorySize = player.getOpenInventory().getTopInventory().getSize() / 9;
                if (inventorySize == 1) {
                    containerName = "a";
                } else if (inventorySize == 2) {
                    containerName = "b";
                } else if (inventorySize == 3) {
                    containerName = "c";
                } else if (inventorySize == 4) {
                    containerName = "d";
                } else if (inventorySize == 5) {
                    containerName = "e";
                } else if (inventorySize == 6) {
                    containerName = "f";
                } else {
                    throw new FoException("Cannot generate NMS container class to update inventory of size " + inventorySize);
                }
                Object container = ReflectionUtil.getStaticFieldContent(ReflectionUtil.lookupClass("net.minecraft.world.inventory.Containers"), containerName);
                Constructor<?> packetConstructor = ReflectionUtil.getConstructor("net.minecraft.network.protocol.game.PacketPlayOutOpenWindow", Integer.TYPE, container.getClass(), ReflectionUtil.lookupClass("net.minecraft.network.chat.IChatBaseComponent"));
                String version = MinecraftVersion.getServerVersion();
                Object activeContainer = ReflectionUtil.getFieldContent(nmsPlayer, is1_19 ? "bU" : (is1_18 ? (version.contains("R2") ? "bV" : "bW") : "bV"));
                int windowId = (Integer)ReflectionUtil.getFieldContent(activeContainer, "j");
                Method method = is1_18 ? ReflectionUtil.getMethod(nmsPlayer.getClass(), "a", ReflectionUtil.lookupClass("net.minecraft.world.inventory.Container")) : null;
                Remain.sendPacket(player, ReflectionUtil.instantiate(packetConstructor, windowId, container, chatComponent));
                if (is1_18) {
                    ReflectionUtil.invoke(method, nmsPlayer, activeContainer);
                } else {
                    ReflectionUtil.invoke("initMenu", nmsPlayer, activeContainer);
                }
                return;
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9) && title.length() > 32) {
                title = title.substring(0, 32);
            }
            Object entityPlayer = Remain.getHandleEntity((Entity)player);
            Object activeContainer = entityPlayer.getClass().getField("activeContainer").get(entityPlayer);
            Object windowId = activeContainer.getClass().getField("windowId").get(activeContainer);
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_8)) {
                Constructor<?> chatMessageConst = ReflectionUtil.getNMSClass("ChatMessage", "net.minecraft.network.chat.ChatMessage").getConstructor(String.class, Object[].class);
                Object chatMessage = chatMessageConst.newInstance(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title), new Object[0]);
                if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                    int inventorySize = player.getOpenInventory().getTopInventory().getSize() / 9;
                    if (inventorySize < 1 || inventorySize > 6) {
                        Common.log("Cannot update title for " + player.getName() + " as their inventory has non typical size: " + inventorySize + " rows");
                        return;
                    }
                    Class<?> containersClass = ReflectionUtil.getNMSClass("Containers", "net.minecraft.world.inventory.Containers");
                    Constructor<?> packetConst = ReflectionUtil.getNMSClass("PacketPlayOutOpenWindow", "net.minecraft.network.protocol.game.PacketPlayOutOpenWindow").getConstructor(Integer.TYPE, containersClass, ReflectionUtil.getNMSClass("IChatBaseComponent", "net.minecraft.network.chat.IChatBaseComponent"));
                    String containerName = "GENERIC_9X" + inventorySize;
                    Object container = containersClass.getField(containerName).get(null);
                    packetOpenWindow = packetConst.newInstance(windowId, container, chatMessage);
                } else {
                    Constructor<?> packetConst = ReflectionUtil.getNMSClass("PacketPlayOutOpenWindow", "N/A").getConstructor(Integer.TYPE, String.class, ReflectionUtil.getNMSClass("IChatBaseComponent", "net.minecraft.network.chat.IChatBaseComponent"), Integer.TYPE);
                    packetOpenWindow = packetConst.newInstance(windowId, "minecraft:chest", chatMessage, player.getOpenInventory().getTopInventory().getSize());
                }
            } else {
                Constructor<?> openWindow = ReflectionUtil.getConstructor(ReflectionUtil.getNMSClass(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7) ? "PacketPlayOutOpenWindow" : "Packet100OpenWindow", "N/A"), Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, Boolean.TYPE);
                packetOpenWindow = ReflectionUtil.instantiate(openWindow, windowId, 0, org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title), player.getOpenInventory().getTopInventory().getSize(), true);
            }
            Remain.sendPacket(player, packetOpenWindow);
            entityPlayer.getClass().getMethod("updateInventory", ReflectionUtil.getNMSClass("Container", "net.minecraft.world.inventory.Container")).invoke(entityPlayer, activeContainer);
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Error updating " + player.getName() + " inventory title to '" + title + "'");
        }
    }

    public static void sendBlockChange(int delayTicks, Player player, Location location, CompMaterial material) {
        Common.runLater(delayTicks, () -> Remain.sendBlockChange0(player, location, material));
    }

    private static void sendBlockChange0(Player player, Location location, CompMaterial material) {
        try {
            player.sendBlockChange(location, material.getMaterial().createBlockData());
        }
        catch (NoSuchMethodError ex) {
            player.sendBlockChange(location, material.getMaterial(), material.getData());
        }
    }

    public static void sendBlockChange(int delayTicks, Player player, Block block) {
        Common.runLater(delayTicks, () -> Remain.sendBlockChange0(player, block));
    }

    private static void sendBlockChange0(Player player, Block block) {
        try {
            player.sendBlockChange(block.getLocation(), block.getBlockData());
        }
        catch (NoSuchMethodError ex) {
            player.sendBlockChange(block.getLocation(), block.getType(), block.getData());
        }
    }

    public static long getPlaytimeMinutes(OfflinePlayer player) {
        return Remain.getPlaytimeSeconds(player) / 60L;
    }

    public static long getPlaytimeSeconds(OfflinePlayer player) {
        long value = PlayerUtil.getStatistic(player, Remain.getPlayTimeStatisticName());
        return value / 20L;
    }

    public static Statistic getPlayTimeStatisticName() {
        return Statistic.valueOf((String)(MinecraftVersion.olderThan(MinecraftVersion.V.v1_13) ? "PLAY_ONE_TICK" : "PLAY_ONE_MINUTE"));
    }

    public static boolean isPlaytimeStatisticTicks() {
        return MinecraftVersion.olderThan(MinecraftVersion.V.v1_13);
    }

    public static boolean isInteractEventPrimaryHand(PlayerInteractEvent event) {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
            return true;
        }
        try {
            return event.getHand() != null && event.getHand() == EquipmentSlot.HAND;
        }
        catch (NoSuchMethodError err) {
            return true;
        }
    }

    public static boolean isInteractEventPrimaryHand(PlayerInteractEntityEvent e) {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
            return true;
        }
        try {
            return e.getHand() != null && e.getHand() == EquipmentSlot.HAND;
        }
        catch (NoSuchMethodError err) {
            return true;
        }
    }

    public static Score getScore(Objective obj, String entry) {
        Valid.checkNotNull(obj, "Objective cannot be null");
        entry = Common.colorize(entry);
        try {
            return obj.getScore(entry);
        }
        catch (NoSuchMethodError err) {
            return obj.getScore(Bukkit.getOfflinePlayer((String)entry));
        }
    }

    public static OfflinePlayer getOfflinePlayerByUUID(UUID id) {
        try {
            return Bukkit.getOfflinePlayer((UUID)id);
        }
        catch (NoSuchMethodError err) {
            if (Bukkit.isPrimaryThread()) {
                Common.log("getOfflinePlayerByUUID required two blocking calls on main thread - please notify " + SimplePlugin.getNamed() + " plugin authors.");
            }
            UUIDToNameConverter f = new UUIDToNameConverter(id);
            try {
                String name = f.call();
                return Bukkit.getOfflinePlayer((String)name);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public static Player getPlayerByUUID(UUID id) {
        try {
            Player player = Bukkit.getPlayer((UUID)id);
            return player != null && player.isOnline() ? player : null;
        }
        catch (NoSuchMethodError err) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!player.getUniqueId().equals(id)) continue;
                return player;
            }
            return null;
        }
    }

    public static double getFinalDamage(EntityDamageEvent event) {
        try {
            return event.getFinalDamage();
        }
        catch (NoSuchMethodError err) {
            return event.getDamage();
        }
    }

    public static Inventory getClickedInventory(InventoryClickEvent event) {
        int slot = event.getRawSlot();
        InventoryView view = event.getView();
        return slot < 0 ? null : (view.getTopInventory() != null && slot < view.getTopInventory().getSize() ? view.getTopInventory() : view.getBottomInventory());
    }

    public static List<BaseComponent[]> getPages(Object metaObject) {
        Valid.checkBoolean(metaObject instanceof BookMeta);
        BookMeta meta = (BookMeta)metaObject;
        try {
            return meta.spigot().getPages();
        }
        catch (NoSuchMethodError ex) {
            ArrayList<BaseComponent[]> list = new ArrayList<BaseComponent[]>();
            for (String page : meta.getPages()) {
                list.add(TextComponent.fromLegacyText((String)page));
            }
            return list;
        }
    }

    public static void setPages(Object metaObject, List<BaseComponent[]> pages) {
        Valid.checkBoolean(metaObject instanceof BookMeta);
        BookMeta meta = (BookMeta)metaObject;
        try {
            meta.spigot().setPages(pages);
        }
        catch (NoSuchMethodError ex) {
            try {
                List chatComponentPages = (List)ReflectionUtil.getFieldContent(ReflectionUtil.getOBCClass("inventory.CraftMetaBook"), "pages", meta);
                for (BaseComponent[] text : pages) {
                    chatComponentPages.add(Remain.toIChatBaseComponent(text));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object toIChatBaseComponentPlain(String text) {
        return Remain.toIChatBaseComponent(TextComponent.fromLegacyText((String)text));
    }

    public static Object toIChatBaseComponent(BaseComponent[] baseComponents) {
        return Remain.toIChatBaseComponent(Remain.toJson(baseComponents));
    }

    public static Object toIChatBaseComponent(String json) {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7), "Serializing chat components requires Minecraft 1.7.10 and greater", new Object[0]);
        Class<?> chatSerializer = ReflectionUtil.getNMSClass((MinecraftVersion.equals(MinecraftVersion.V.v1_7) ? "" : "IChatBaseComponent$") + "ChatSerializer", "net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
        Method a = ReflectionUtil.getMethod(chatSerializer, "a", String.class);
        return ReflectionUtil.invoke(a, null, json);
    }

    public static String getName(Entity entity) {
        try {
            return entity.getName();
        }
        catch (NoSuchMethodError t) {
            return entity instanceof Player ? ((Player)entity).getName() : ItemUtil.bountifyCapitalized(entity.getType());
        }
    }

    public static void setCustomName(Entity entity, String name) {
        try {
            entity.setCustomNameVisible(true);
            entity.setCustomName(Common.colorize(name));
        }
        catch (NoSuchMethodError er) {
            Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7), "setCustomName requires Minecraft 1.7.10+", new Object[0]);
            NBTEntity nbt = new NBTEntity(entity);
            nbt.setInteger("CustomNameVisible", 1);
            nbt.setString("CustomName", Common.colorize(name));
        }
    }

    public static void removeCustomName(Entity entity) {
        try {
            entity.setCustomNameVisible(false);
            entity.setCustomName(null);
        }
        catch (NoSuchMethodError er) {
            Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7), "setCustomName requires Minecraft 1.7.10+", new Object[0]);
            NBTEntity nbt = new NBTEntity(entity);
            nbt.removeKey("CustomNameVisible");
            nbt.removeKey("CustomName");
        }
    }

    public static boolean isInvisible(Entity entity) {
        if (entity instanceof LivingEntity && MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
            return ((LivingEntity)entity).isInvisible();
        }
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_4)) {
            Object nmsEntity = Remain.getHandleEntity(entity);
            return (Boolean)ReflectionUtil.invoke("isInvisible", nmsEntity, new Object[0]);
        }
        return false;
    }

    @Deprecated
    public static void setInvisible(Object entity, boolean invisible) {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_4), "Entity#setInvisible requires Minecraft 1.4.7 or greater", new Object[0]);
        if (entity instanceof LivingEntity && MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
            ((LivingEntity)entity).setInvisible(invisible);
        } else {
            Object nmsEntity = entity.getClass().toString().contains("net.minecraft.server") ? entity : (entity instanceof LivingEntity ? Remain.getHandleEntity((Entity)((LivingEntity)entity)) : null);
            Valid.checkNotNull(nmsEntity, "setInvisible requires either a LivingEntity or a NMS Entity, got: " + entity.getClass());
            Common.runLater(2, () -> ReflectionUtil.invoke("setInvisible", nmsEntity, invisible));
        }
    }

    public static boolean isInvulnerable(Entity entity) {
        try {
            return entity.isInvulnerable();
        }
        catch (NoSuchMethodError ex) {
            if (fieldEntityInvulnerable != null) {
                try {
                    return (Boolean)fieldEntityInvulnerable.get(Remain.getHandleEntity(entity));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static void setInvulnerable(Entity entity, boolean invulnerable) {
        CompProperty.INVULNERABLE.apply(entity, invulnerable);
    }

    public static CompMaterial getMaterial(String material, CompMaterial fallback) {
        Material mat = null;
        try {
            mat = Material.getMaterial((String)material);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mat != null ? CompMaterial.fromMaterial(mat) : fallback;
    }

    public static Material getMaterial(String newMaterial, String oldMaterial) {
        try {
            return Material.getMaterial((String)newMaterial);
        }
        catch (Throwable t) {
            return Material.getMaterial((String)oldMaterial);
        }
    }

    public static Block getTargetBlock(LivingEntity en, int radius) {
        try {
            return en.getTargetBlock((Set)null, radius);
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                return null;
            }
            try {
                return (Block)en.getClass().getMethod("getTargetBlock", HashSet.class, Integer.TYPE).invoke((Object)en, null, radius);
            }
            catch (ReflectiveOperationException ex2) {
                throw new FoException(t, "Unable to get target block for " + en);
            }
        }
    }

    public static void sendToast(Player receiver, String message) {
        Remain.sendToast(receiver, message, CompMaterial.BOOK, CompToastStyle.TASK);
    }

    public static void sendToast(Player receiver, String message, CompToastStyle toastStyle) {
        Remain.sendToast(receiver, message, CompMaterial.BOOK, toastStyle);
    }

    public static void sendToast(Player receiver, String message, CompMaterial icon) {
        Remain.sendToast(receiver, message, icon, CompToastStyle.TASK);
    }

    public static void sendToast(Player receiver, String message, CompMaterial icon, CompToastStyle toastStyle) {
        String colorized;
        if (message != null && !message.isEmpty() && !(colorized = Common.colorize(message)).isEmpty()) {
            Valid.checkSync("Toasts may only be sent from the main thread");
            if (hasAdvancements) {
                new AdvancementAccessor(colorized, icon.toString().toLowerCase(), toastStyle).show(receiver);
            } else {
                receiver.sendMessage(colorized);
            }
        }
    }

    public static void sendToast(List<Player> receivers, Function<Player, String> message, CompMaterial icon) {
        Remain.sendToast(receivers, message, icon, CompToastStyle.GOAL);
    }

    public static void sendToast(List<Player> receivers, Function<Player, String> message, CompMaterial icon, CompToastStyle style) {
        if (hasAdvancements) {
            Common.runLaterAsync(() -> {
                for (Player receiver : receivers) {
                    Common.sleep(100);
                    Common.runLater(() -> {
                        String colorized = Common.colorize((String)message.apply(receiver));
                        if (!colorized.isEmpty()) {
                            AdvancementAccessor accessor = new AdvancementAccessor(colorized, icon.toString().toLowerCase(), style);
                            if (receiver.isOnline()) {
                                accessor.show(receiver);
                            }
                        }
                    });
                }
            });
        } else {
            for (Player receiver : receivers) {
                String colorized = Common.colorize(message.apply(receiver));
                if (colorized.isEmpty()) continue;
                receiver.sendMessage(colorized);
            }
        }
    }

    public static void setCooldown(Player player, Material material, int cooldownTicks) {
        try {
            player.setCooldown(material, cooldownTicks);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            cooldown.override(material, cooldownTicks);
            cooldowns.override(player.getUniqueId(), cooldown);
        }
    }

    public static boolean hasCooldown(Player player, Material material) {
        try {
            return player.hasCooldown(material);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            return cooldown.containsKey(material);
        }
    }

    public static int getCooldown(Player player, Material material) {
        try {
            return player.getCooldown(material);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            return cooldown.getOrDefault(material, 0);
        }
    }

    private static StrictMap<Material, Integer> getCooldown(Player player) {
        return cooldowns.getOrDefault(player.getUniqueId(), new StrictMap());
    }

    @Deprecated
    public static int getPing(Player player) {
        try {
            return player.getPing();
        }
        catch (NoSuchMethodError err) {
            Object entityPlayer = Remain.getHandleEntity((Entity)player);
            return (Integer)ReflectionUtil.getFieldContent(entityPlayer, "ping");
        }
    }

    public static Entity getEntity(UUID uuid) {
        Valid.checkSync("Remain#getEntity must be called on the main thread");
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static LivingEntity getHitEntity(ProjectileHitEvent event) {
        try {
            if (event.getHitEntity() instanceof LivingEntity) {
                return (LivingEntity)event.getHitEntity();
            }
        }
        catch (Throwable t) {
            double radius = 0.5;
            for (Entity nearby : event.getEntity().getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(nearby instanceof LivingEntity)) continue;
                return (LivingEntity)nearby;
            }
        }
        return null;
    }

    public static Block getHitBlock(ProjectileHitEvent event) {
        try {
            return event.getHitBlock();
        }
        catch (Throwable t) {
            Block entityBlock = event.getEntity().getLocation().getBlock();
            if (!CompMaterial.isAir(entityBlock)) {
                return entityBlock;
            }
            for (BlockFace face : Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH)) {
                Block adjucentBlock = entityBlock.getRelative(face);
                if (CompMaterial.isAir(adjucentBlock)) continue;
                return adjucentBlock;
            }
            return null;
        }
    }

    public static Collection<Entity> getNearbyEntities(Location location, double radius) {
        try {
            return location.getWorld().getNearbyEntities(location, radius, radius, radius);
        }
        catch (Throwable t) {
            ArrayList<Entity> found = new ArrayList<Entity>();
            for (Entity nearby : location.getWorld().getEntities()) {
                if (!(nearby.getLocation().distance(location) <= radius)) continue;
                found.add(nearby);
            }
            return found;
        }
    }

    public static void takeHandItem(Player player) {
        Remain.takeItemAndSetAsHand(player, player.getItemInHand());
    }

    public static void takeItemAndSetAsHand(Player player, ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItemInHand(item);
        } else {
            player.getInventory().setItemInHand(null);
        }
        player.updateInventory();
    }

    public static void takeItemOnePiece(Player player, ItemStack item) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_15)) {
            item.setAmount(item.getAmount() - 1);
        } else {
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                ItemStack[] content = player.getInventory().getContents();
                for (int slot = 0; slot < content.length; ++slot) {
                    ItemStack slotItem = content[slot];
                    if (slotItem == null || !slotItem.equals((Object)item)) continue;
                    content[slot] = null;
                    break;
                }
                player.getInventory().setContents(content);
            }
            player.updateInventory();
        }
    }

    public static void setPotion(ItemStack item, PotionEffectType type, int level) {
        Remain.setPotion(item, type, 12000, level);
    }

    public static void setPotion(ItemStack item, PotionEffectType type, int durationTicks, int level) {
        if (hasItemMeta) {
            PotionSetter.setPotion(item, type, durationTicks, level);
        }
    }

    public static String getI18NDisplayName(ItemStack item) {
        try {
            return (String)item.getClass().getDeclaredMethod("getI18NDisplayName", new Class[0]).invoke((Object)item, new Object[0]);
        }
        catch (Throwable t) {
            return ItemUtil.bountifyCapitalized(item.getType());
        }
    }

    public static double getMaxHealth() {
        try {
            String health = String.valueOf(Class.forName("org.spigotmc.SpigotConfig").getField("maxHealth").get(null));
            return health.contains(".") ? Double.parseDouble(health) : (double)Integer.parseInt(health);
        }
        catch (Throwable t) {
            return 2048.0;
        }
    }

    public static boolean isStatSavingDisabled() {
        try {
            return (Boolean)Class.forName("org.spigotmc.SpigotConfig").getField("disableStatSaving").get(null);
        }
        catch (ReflectiveOperationException ex) {
            try {
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)new File("spigot.yml"));
                return cfg.isSet("stats.disable-saving") ? cfg.getBoolean("stats.disable-saving") : false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public static void sneaky(Throwable throwable) {
        try {
            SneakyThrow.sneaky(throwable);
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError err) {
            throw new FoException(throwable);
        }
    }

    public static void setGameRule(World world, String gameRule, boolean value) {
        try {
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                GameRule rule = GameRule.getByName((String)gameRule);
                world.setGameRule(rule, (Object)value);
            } else {
                world.setGameRuleValue(gameRule, "" + value);
            }
        }
        catch (Throwable t) {
            Common.error(t, "Game rule " + gameRule + " not found.");
        }
    }

    public static void injectServerName() {
        try {
            YamlConfiguration settings;
            String previousNameRaw;
            File settingsFile = FileUtil.getFile("settings.yml");
            String previousName = null;
            if (settingsFile.exists() && (previousNameRaw = (settings = YamlConfiguration.loadConfiguration((File)settingsFile)).getString("Bungee_Server_Name")) != null && !previousNameRaw.isEmpty() && !"none".equals(previousNameRaw) && !"undefined".equals(previousNameRaw)) {
                Common.warning("Detected Bungee_Server_Name being used in your settings.yml that is now located in server.properties. It has been moved there and you can now delete this key from settings.yml if it was not deleted already.");
                previousName = previousNameRaw;
            }
            File serverProperties = new File(SimplePlugin.getData().getParentFile().getParentFile(), "server.properties");
            List<String> lines = FileUtil.readLines(serverProperties);
            lines.removeIf(line -> line.equals("server-name=undefined") || line.equals("server-name=Unknown Server"));
            boolean hasServerName = false;
            String oldName = null;
            for (String line2 : lines) {
                if (!line2.startsWith("server-name=")) continue;
                hasServerName = true;
                oldName = line2.replace("server-name=", "");
                break;
            }
            if (!hasServerName) {
                serverName = previousName == null ? "Undefined - see mineacademy.org/server-properties to configure" : previousName;
                lines.add("server-name=" + serverName);
                Files.write(serverProperties.toPath(), lines, StandardOpenOption.TRUNCATE_EXISTING);
            }
            serverName = oldName;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String getServerName() {
        Valid.checkBoolean(Remain.isServerNameChanged(), "Detected getServerName call, please configure your 'server-name' in server.properties according to mineacademy.org/server-properties", new Object[0]);
        return serverName;
    }

    public static boolean isServerNameChanged() {
        return !"see mineacademy.org/server-properties to configure".contains(serverName) && !"undefined".equals(serverName) && !"Unknown Server".equals(serverName);
    }

    public static int getJavaVersion() {
        return SimplePlugin.getJavaVersion();
    }

    public static int getTPS() {
        try {
            Method getTPS = Bukkit.class.getDeclaredMethod("getTPS", double[].class);
            return (int)MathUtil.floor(getTPS == null ? 20.0 : ((double[])getTPS.invoke(null, new Object[0]))[0]);
        }
        catch (ReflectiveOperationException ex) {
            return 20;
        }
    }

    public static boolean setViewDistance(Player player, int viewDistanceChunks) {
        try {
            Method setViewDistance = Player.class.getDeclaredMethod("setViewDistance", Integer.TYPE);
            ReflectionUtil.invoke(setViewDistance, (Object)player, viewDistanceChunks);
            return true;
        }
        catch (ReflectiveOperationException ex) {
            return false;
        }
    }

    @Deprecated
    public static Object getRootOfSectionPathData(Object objectOrSectionPathData) {
        if (objectOrSectionPathData != null && objectOrSectionPathData.getClass() == sectionPathDataClass) {
            objectOrSectionPathData = ReflectionUtil.invoke("getData", objectOrSectionPathData, new Object[0]);
        }
        return objectOrSectionPathData;
    }

    public static boolean isMemorySection(Object obj) {
        return obj != null && sectionPathDataClass == obj.getClass();
    }

    public static boolean isPaper() {
        try {
            Class.forName("co.aikar.timings.Timing");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isBungeeApiPresent() {
        return bungeeApiPresent;
    }

    public static boolean hasNewScoreboardAPI() {
        return newScoreboardAPI;
    }

    public static boolean hasParticleAPI() {
        return hasParticleAPI;
    }

    public static boolean hasBookEvent() {
        return hasBookEvent;
    }

    public static boolean hasScoreboardTags() {
        return hasScoreboardTags;
    }

    public static boolean hasSpawnEggMeta() {
        return hasSpawnEggMeta;
    }

    public static boolean hasYamlReaderLoad() {
        return hasYamlReaderLoad;
    }

    public static boolean hasItemMeta() {
        return hasItemMeta;
    }

    public static boolean hasHexColors() {
        return MinecraftVersion.atLeast(MinecraftVersion.V.v1_16);
    }

    public static boolean hasAddPassenger() {
        return hasAddPassenger;
    }

    private static Player[] getPlayersLegacy() {
        try {
            return (Player[])getPlayersMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    private static int getHealhLegacy(LivingEntity entity) {
        try {
            return (Integer)getHealthMethod.invoke((Object)entity, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    private static int getMaxHealhLegacy(LivingEntity entity) {
        try {
            Object number = LivingEntity.class.getMethod("getMaxHealth", new Class[0]).invoke((Object)entity, new Object[0]);
            if (number instanceof Double) {
                return ((Double)number).intValue();
            }
            if (number instanceof Integer) {
                return (Integer)number;
            }
            return (int)Double.parseDouble(number.toString());
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    static {
        block39: {
            RGB_HEX_ENCODED_REGEX = Pattern.compile("(?i)(\u00a7x)((\u00a7[0-9A-F]){6})");
            gson = new Gson();
            isGetPlayersCollection = false;
            isGetHealthDouble = false;
            hasExtendedPlayerTitleAPI = false;
            hasParticleAPI = true;
            newScoreboardAPI = true;
            hasBookEvent = true;
            hasInventoryLocation = true;
            hasScoreboardTags = true;
            hasSpawnEggMeta = true;
            hasAdvancements = true;
            hasYamlReaderLoad = true;
            bungeeApiPresent = true;
            hasItemMeta = true;
            hasAddPassenger = true;
            cooldowns = new StrictMap();
            sectionPathDataClass = null;
            Valid.checkBoolean(MinecraftVersion.getCurrent().isTested(), "Your Minecraft version " + (Object)((Object)MinecraftVersion.getCurrent()) + " is unsupported by " + SimplePlugin.getNamed(), new Object[0]);
            try {
                ChatInternals.callStatic();
                ((Object)((Object)CompParticle.CRIT)).getClass();
                for (Material material : Material.values()) {
                    CompMaterial.fromString(material.toString());
                }
                for (CompMaterial compMaterial : CompMaterial.values()) {
                    compMaterial.getMaterial();
                }
                ReflectionUtil.getNMSClass("Entity", "net.minecraft.world.entity.Entity");
            }
            catch (Throwable throwable) {
                boolean isThermos = false;
                try {
                    Class.forName("thermos.ThermosRemapper");
                    isThermos = true;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (isThermos) break block39;
                Bukkit.getLogger().severe("** COMPATIBILITY TEST FAILED - THIS PLUGIN WILL NOT FUNCTION PROPERLY **");
                Bukkit.getLogger().severe("** YOUR MINECRAFT VERSION APPEARS UNSUPPORTED: " + (Object)((Object)MinecraftVersion.getCurrent()) + " **");
                throwable.printStackTrace();
                Bukkit.getLogger().severe("***************************************************************");
            }
        }
        try {
            boolean bl = MinecraftVersion.atLeast(MinecraftVersion.V.v1_4);
            try {
                getHandle = ReflectionUtil.getOBCClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                fieldPlayerConnection = ReflectionUtil.getNMSClass("EntityPlayer", "net.minecraft.server.level.EntityPlayer").getField(MinecraftVersion.atLeast(MinecraftVersion.V.v1_17) ? "b" : (bl ? "playerConnection" : "netServerHandler"));
                sendPacket = ReflectionUtil.getNMSClass(bl ? "PlayerConnection" : "NetServerHandler", "net.minecraft.server.network.PlayerConnection").getMethod(MinecraftVersion.atLeast(MinecraftVersion.V.v1_18) ? "a" : "sendPacket", ReflectionUtil.getNMSClass("Packet", "net.minecraft.network.protocol.Packet"));
                if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_12)) {
                    try {
                        fieldEntityInvulnerable = ReflectionUtil.getNMSClass("Entity").getDeclaredField("invulnerable");
                        fieldEntityInvulnerable.setAccessible(true);
                    }
                    catch (Throwable isThermos) {}
                } else {
                    fieldEntityInvulnerable = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7)) {
                    Bukkit.getLogger().warning("Unable to find setup some parts of reflection. Plugin will still function.");
                    Bukkit.getLogger().warning("Error: " + t.getClass().getSimpleName() + ": " + t.getMessage());
                    Bukkit.getLogger().warning("Ignore this if using Cauldron. Otherwise check if your server is compatibble.");
                }
                fieldPlayerConnection = null;
                sendPacket = null;
                getHandle = null;
            }
            getPlayersMethod = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]);
            isGetPlayersCollection = getPlayersMethod.getReturnType() == Collection.class;
            getHealthMethod = LivingEntity.class.getMethod("getHealth", new Class[0]);
            isGetHealthDouble = getHealthMethod.getReturnType() == Double.TYPE;
            hasExtendedPlayerTitleAPI = MinecraftVersion.atLeast(MinecraftVersion.V.v1_11);
            try {
                World.class.getMethod("spawnParticle", Particle.class, Location.class, Integer.TYPE);
            }
            catch (Throwable ex) {
                hasParticleAPI = false;
            }
            try {
                Class.forName("net.md_5.bungee.chat.ComponentSerializer");
            }
            catch (Throwable ex) {
                bungeeApiPresent = false;
                throw new FoException("&cYour server version (&f" + Bukkit.getBukkitVersion().replace("-SNAPSHOT", "") + "&c) doesn't\n &cinclude &elibraries required&c for this plugin to\n &crun. Install the following plugin for compatibility:\n &fhttps://mineacademy.org/plugins/#misc");
            }
            try {
                Objective.class.getMethod("getScore", String.class);
            }
            catch (Throwable e) {
                newScoreboardAPI = false;
            }
            try {
                Class.forName("org.bukkit.event.player.PlayerEditBookEvent").getName();
            }
            catch (Throwable ex) {
                hasBookEvent = false;
            }
            try {
                Inventory.class.getMethod("getLocation", new Class[0]);
            }
            catch (Throwable ex) {
                hasInventoryLocation = false;
            }
            try {
                Entity.class.getMethod("getScoreboardTags", new Class[0]);
            }
            catch (Throwable ex) {
                hasScoreboardTags = false;
            }
            try {
                Class.forName("org.bukkit.inventory.meta.SpawnEggMeta");
            }
            catch (Throwable err) {
                hasSpawnEggMeta = false;
            }
            try {
                Class.forName("org.bukkit.advancement.Advancement");
                Class.forName("org.bukkit.NamespacedKey");
            }
            catch (Throwable err) {
                hasAdvancements = false;
            }
            try {
                YamlConfiguration.class.getMethod("load", Reader.class);
            }
            catch (Throwable err) {
                hasYamlReaderLoad = false;
            }
            try {
                ItemStack.class.getMethod("getItemMeta", new Class[0]);
            }
            catch (Throwable ex) {
                hasItemMeta = false;
            }
            try {
                Entity.class.getMethod("addPassenger", Entity.class);
            }
            catch (Throwable ex) {
                hasAddPassenger = false;
            }
            try {
                sectionPathDataClass = ReflectionUtil.lookupClass("org.bukkit.configuration.SectionPathData");
            }
            catch (Throwable throwable) {}
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new UnsupportedOperationException("Failed to set up reflection, " + SimplePlugin.getNamed() + " won't work properly", reflectiveOperationException);
        }
    }

    public static class InteractiveTextFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InteractiveTextFoundException() {
        }
    }
}

