/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.util.ArrayList;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;

class PotionSetter {
    PotionSetter() {
    }

    public static void setPotion(ItemStack item, PotionEffectType type, int durationTicks, int level) {
        Valid.checkBoolean(item.getItemMeta() instanceof PotionMeta, "Can only use setPotion for items with PotionMeta not: " + item.getItemMeta(), new Object[0]);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        PotionType wrapped = PotionType.getByEffect((PotionEffectType)type);
        try {
            if (level > 0 && wrapped == null) {
                PotionData data = new PotionData(level > 0 && wrapped != null ? wrapped : PotionType.WATER);
                meta.setBasePotionData(data);
                meta.addEnchant(Enchantment.DURABILITY, 1, true);
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError data) {
            // empty catch block
        }
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Common.colorize("&7" + ItemUtil.bountifyCapitalized(type) + " (" + TimeUtil.formatTimeColon(durationTicks / 20) + ")"));
            if (meta.getLore() != null) {
                lore.addAll(meta.getLore());
            }
            meta.setLore(lore);
        }
        meta.setMainEffect(type);
        meta.addCustomEffect(new PotionEffect(type, durationTicks, level - 1), true);
        item.setItemMeta((ItemMeta)meta);
    }
}

