/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.entity.CreatureSpawnEvent;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

final class NmsAccessor {
    static final Method createEntity;
    static final Method getBukkitEntity;
    static Method addEntity;
    private static volatile boolean hasEntityConsumer;
    private static volatile boolean hasRandomizeData;
    private static volatile boolean olderThan18;

    NmsAccessor() {
    }

    static void call() {
    }

    static Object addEntity(World bukkitWorld, Object nmsEntity, CreatureSpawnEvent.SpawnReason reason) throws ReflectiveOperationException {
        if (olderThan18) {
            addEntity.invoke(Remain.getHandleWorld(bukkitWorld), nmsEntity, reason);
            return getBukkitEntity.invoke(nmsEntity, new Object[0]);
        }
        if (hasEntityConsumer) {
            if (hasRandomizeData) {
                return addEntity.invoke((Object)bukkitWorld, nmsEntity, reason, null, false);
            }
            return addEntity.invoke((Object)bukkitWorld, nmsEntity, reason, null);
        }
        return addEntity.invoke((Object)bukkitWorld, nmsEntity, reason);
    }

    static {
        hasEntityConsumer = false;
        hasRandomizeData = false;
        try {
            Class<?> nmsEntity = ReflectionUtil.getNMSClass("Entity", "net.minecraft.world.entity.Entity");
            Class<?> ofcWorld = ReflectionUtil.getOBCClass("CraftWorld");
            olderThan18 = MinecraftVersion.olderThan(MinecraftVersion.V.v1_8);
            createEntity = MinecraftVersion.newerThan(MinecraftVersion.V.v1_7) ? ReflectionUtil.getDeclaredMethod(ofcWorld, "createEntity", Location.class, Class.class) : null;
            getBukkitEntity = nmsEntity.getMethod("getBukkitEntity", new Class[0]);
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_10)) {
                hasEntityConsumer = true;
                try {
                    addEntity = ReflectionUtil.getDeclaredMethod(ofcWorld, "addEntity", nmsEntity, CreatureSpawnEvent.SpawnReason.class, Class.forName("org.bukkit.util.Consumer"));
                }
                catch (ReflectionUtil.ReflectionException ex) {
                    addEntity = ReflectionUtil.getDeclaredMethod(ofcWorld, "addEntity", nmsEntity, CreatureSpawnEvent.SpawnReason.class, Class.forName("org.bukkit.util.Consumer"), Boolean.TYPE);
                    hasRandomizeData = true;
                }
            } else {
                addEntity = MinecraftVersion.newerThan(MinecraftVersion.V.v1_7) ? ReflectionUtil.getDeclaredMethod(ofcWorld, "addEntity", nmsEntity, CreatureSpawnEvent.SpawnReason.class) : ReflectionUtil.getNMSClass("World", "net.minecraft.world.level.World").getDeclaredMethod("addEntity", nmsEntity, CreatureSpawnEvent.SpawnReason.class);
            }
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            Runtime.getRuntime().halt(-3505);
            throw new FoException(ex, "Error setting up nms entity accessor!");
        }
    }
}

