/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONArray;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParseException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public class JsonItemStack {
    private static final String[] BYPASS_CLASS = new String[]{"CraftMetaBlockState", "GlowMetaItem"};

    public static String toJsonString(@Nullable ItemStack itemStack) {
        Gson gson = new Gson();
        return gson.toJson((Object)JsonItemStack.toJson(itemStack));
    }

    public static JSONObject toJson(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("type", item.getType().name());
        if (item.getDurability() > 0) {
            json.put("data", item.getDurability());
        }
        if (item.getAmount() != 1) {
            json.put("amount", item.getAmount());
        }
        if (item.hasItemMeta()) {
            JSONObject metaJson = new JSONObject();
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                metaJson.put("displayname", meta.getDisplayName());
            }
            if (meta.hasLore()) {
                JSONArray jSONArray = new JSONArray();
                meta.getLore().forEach(line -> lore.add(line));
                metaJson.put("lore", jSONArray);
            }
            if (meta.hasEnchants()) {
                JSONArray jSONArray = new JSONArray();
                meta.getEnchants().forEach((enchantment, integer) -> enchants.add(enchantment.getName() + ":" + integer));
                metaJson.put("enchants", jSONArray);
            }
            if (!meta.getItemFlags().isEmpty()) {
                JSONArray jSONArray = new JSONArray();
                meta.getItemFlags().stream().map(Enum::name).forEach(flag -> jSONArray.add(flag));
                metaJson.put("flags", jSONArray);
            }
            for (String clazz : BYPASS_CLASS) {
                if (!meta.getClass().getSimpleName().equals(clazz)) continue;
                json.put("item-meta", metaJson);
                return json;
            }
            if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                if (skullMeta.hasOwner()) {
                    JSONObject extraMeta = new JSONObject();
                    extraMeta.put("owner", skullMeta.getOwner());
                    metaJson.put("extra-meta", extraMeta);
                }
            } else if (meta instanceof BannerMeta) {
                BannerMeta bannerMeta = (BannerMeta)meta;
                JSONObject extraMeta = new JSONObject();
                extraMeta.put("base-color", bannerMeta.getBaseColor().name());
                if (bannerMeta.numberOfPatterns() > 0) {
                    JSONArray patterns = new JSONArray();
                    bannerMeta.getPatterns().stream().map(pattern -> pattern.getColor().name() + ":" + pattern.getPattern().getIdentifier()).forEach(str -> patterns.add(new JsonPrimitive(str)));
                    extraMeta.put("patterns", patterns);
                }
                metaJson.put("extra-meta", extraMeta);
            } else if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
                if (enchantmentStorageMeta.hasStoredEnchants()) {
                    JSONObject extraMeta = new JSONObject();
                    JSONArray storedEnchants = new JSONArray();
                    enchantmentStorageMeta.getStoredEnchants().forEach((enchantment, integer) -> storedEnchants.add(new JsonPrimitive(enchantment.getName() + ":" + integer)));
                    extraMeta.put("stored-enchants", storedEnchants);
                    metaJson.put("extra-meta", extraMeta);
                }
            } else if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                JSONObject extraMeta = new JSONObject();
                extraMeta.put("color", Integer.toHexString(leatherArmorMeta.getColor().asRGB()));
                metaJson.put("extra-meta", extraMeta);
            } else if (meta instanceof BookMeta) {
                BookMeta bookMeta = (BookMeta)meta;
                if (bookMeta.hasAuthor() || bookMeta.hasPages() || bookMeta.hasTitle()) {
                    JSONObject extraMeta = new JSONObject();
                    if (bookMeta.hasTitle()) {
                        extraMeta.put("title", bookMeta.getTitle());
                    }
                    if (bookMeta.hasAuthor()) {
                        extraMeta.put("author", bookMeta.getAuthor());
                    }
                    if (bookMeta.hasPages()) {
                        JSONArray pages = new JSONArray();
                        bookMeta.getPages().forEach(str -> pages.add(str));
                        extraMeta.put("pages", pages);
                    }
                    metaJson.put("extra-meta", extraMeta);
                }
            } else if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                JSONObject extraMeta = new JSONObject();
                if (potionMeta.hasCustomEffects()) {
                    JSONArray customEffects = new JSONArray();
                    potionMeta.getCustomEffects().forEach(potionEffect -> customEffects.add(new JsonPrimitive(potionEffect.getType().getName() + ":" + potionEffect.getAmplifier() + ":" + potionEffect.getDuration() / 20)));
                    extraMeta.put("custom-effects", customEffects);
                } else {
                    try {
                        PotionType type = potionMeta.getBasePotionData().getType();
                        boolean isExtended = potionMeta.getBasePotionData().isExtended();
                        boolean isUpgraded = potionMeta.getBasePotionData().isUpgraded();
                        JSONObject baseEffect = new JSONObject();
                        baseEffect.put("type", type.getEffectType().getName());
                        baseEffect.put("isExtended", isExtended);
                        baseEffect.put("isUpgraded", isUpgraded);
                        extraMeta.put("base-effect", baseEffect);
                    }
                    catch (NoSuchMethodError type) {
                        // empty catch block
                    }
                }
                metaJson.put("extra-meta", extraMeta);
            } else if (meta instanceof FireworkEffectMeta) {
                FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)meta;
                if (fireworkEffectMeta.hasEffect()) {
                    FireworkEffect effect2 = fireworkEffectMeta.getEffect();
                    JSONObject extraMeta = new JSONObject();
                    extraMeta.put("type", effect2.getType().name());
                    if (effect2.hasFlicker()) {
                        extraMeta.put("flicker", true);
                    }
                    if (effect2.hasTrail()) {
                        extraMeta.put("trail", true);
                    }
                    if (!effect2.getColors().isEmpty()) {
                        JSONArray colors = new JSONArray();
                        effect2.getColors().forEach(color -> colors.add(Integer.toHexString(color.asRGB())));
                        extraMeta.put("colors", colors);
                    }
                    if (!effect2.getFadeColors().isEmpty()) {
                        JSONArray fadeColors = new JSONArray();
                        effect2.getFadeColors().forEach(color -> fadeColors.add(Integer.toHexString(color.asRGB())));
                        extraMeta.put("fade-colors", fadeColors);
                    }
                    metaJson.put("extra-meta", extraMeta);
                }
            } else if (meta instanceof FireworkMeta) {
                FireworkMeta fireworkMeta = (FireworkMeta)meta;
                JSONObject extraMeta = new JSONObject();
                extraMeta.put("power", fireworkMeta.getPower());
                if (fireworkMeta.hasEffects()) {
                    JSONArray effects = new JSONArray();
                    fireworkMeta.getEffects().forEach(effect -> {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", effect.getType().name());
                        if (effect.hasFlicker()) {
                            jsonObject.put("flicker", true);
                        }
                        if (effect.hasTrail()) {
                            jsonObject.put("trail", true);
                        }
                        if (!effect.getColors().isEmpty()) {
                            JSONArray colors = new JSONArray();
                            effect.getColors().forEach(color -> colors.add(Integer.toHexString(color.asRGB())));
                            jsonObject.put("colors", colors);
                        }
                        if (!effect.getFadeColors().isEmpty()) {
                            JSONArray fadeColors = new JSONArray();
                            effect.getFadeColors().forEach(color -> fadeColors.add(Integer.toHexString(color.asRGB())));
                            jsonObject.put("fade-colors", fadeColors);
                        }
                        effects.add(jsonObject);
                    });
                    extraMeta.put("effects", effects);
                }
                metaJson.put("extra-meta", extraMeta);
            } else if (meta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)meta;
                JSONObject extraMeta = new JSONObject();
                try {
                    if (mapMeta.hasLocationName()) {
                        extraMeta.put("location-name", mapMeta.getLocationName());
                    }
                    if (mapMeta.hasColor()) {
                        extraMeta.put("color", Integer.toHexString(mapMeta.getColor().asRGB()));
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                extraMeta.put("scaling", mapMeta.isScaling());
                metaJson.put("extra-meta", extraMeta);
            }
            json.put("item-meta", metaJson);
        }
        return json;
    }

    public static ItemStack fromJson(@Nullable String string) {
        ItemMeta meta;
        ItemStack item;
        block74: {
            JSONObject metaJson;
            Object element;
            if (string == null || string.isEmpty() || "{}".equals(string)) {
                return null;
            }
            try {
                element = JSONParser.deserialize(string);
            }
            catch (JSONParseException ex) {
                Remain.sneaky(ex);
                return null;
            }
            Valid.checkBoolean(element instanceof JSONObject, "Expected JSONObject from JSON ItemStack, got " + (element == null ? "null" : element.getClass().getSimpleName()) + ": " + element, new Object[0]);
            JSONObject itemJson = (JSONObject)element;
            String type = itemJson.getString("type");
            Integer data = itemJson.getInteger("data");
            Integer amount = itemJson.getInteger("amount");
            item = new ItemStack(Material.getMaterial((String)type));
            if (data != null) {
                item.setDurability(data.shortValue());
            }
            if (amount != null) {
                item.setAmount(amount.intValue());
            }
            if ((metaJson = itemJson.getObject("item-meta")) == null) {
                return item;
            }
            meta = item.getItemMeta();
            String displayName = metaJson.getString("displayname");
            JSONArray lore = metaJson.getArray("lore");
            JSONArray enchants = metaJson.getArray("enchants");
            JSONArray flags = metaJson.getArray("flags");
            if (displayName != null) {
                meta.setDisplayName(displayName);
            }
            if (lore != null) {
                meta.setLore(Arrays.asList(lore.toStringArray()));
            }
            if (enchants != null) {
                for (String enchant : enchants.toStringArray()) {
                    Valid.checkBoolean(enchant.contains(":"), "Expected : when parsing enchants from JSON item, got: " + enchants + ". Full item: " + itemJson, new Object[0]);
                    try {
                        String[] split = enchant.split(":");
                        String[] enchantment = Enchantment.getByName((String)split[0]);
                        int level = Integer.parseInt(split[1]);
                        if (enchantment == null || level <= 0) continue;
                        meta.addEnchant((Enchantment)enchantment, level, true);
                    }
                    catch (NumberFormatException split) {
                        // empty catch block
                    }
                }
            }
            if (flags != null) {
                try {
                    for (String jsonFlag : flags.toStringArray()) {
                        ItemFlag flag = ReflectionUtil.lookupEnumSilent(ItemFlag.class, jsonFlag);
                        if (flag == null) continue;
                        meta.addItemFlags(new ItemFlag[]{flag});
                    }
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            for (String clazz : BYPASS_CLASS) {
                if (!meta.getClass().getSimpleName().equals(clazz)) continue;
                return item;
            }
            JSONObject extraJson = metaJson.getObject("extra-meta");
            if (extraJson != null) {
                try {
                    if (meta instanceof SkullMeta) {
                        String owner = extraJson.getString("owner");
                        if (owner != null) {
                            ((SkullMeta)meta).setOwner(owner);
                        }
                        break block74;
                    }
                    if (meta instanceof BannerMeta) {
                        BannerMeta bmeta = (BannerMeta)meta;
                        String baseColor = extraJson.getString("base-color");
                        String[] patterns = extraJson.getArray("patterns");
                        if (baseColor != null) {
                            try {
                                Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(dyeColor -> dyeColor.name().equalsIgnoreCase(baseColor)).findFirst();
                                if (color.isPresent()) {
                                    bmeta.setBaseColor(color.get());
                                }
                            }
                            catch (NumberFormatException color) {
                                // empty catch block
                            }
                        }
                        if (patterns != null) {
                            ArrayList<Pattern> bukkitPatterns = new ArrayList<Pattern>();
                            for (String pattern : patterns.toStringArray()) {
                                Valid.checkBoolean(pattern.contains(":"), "Expected : when parsing banner patterns from JSON item, got: " + pattern + ". Full item: " + itemJson, new Object[0]);
                                if (!pattern.contains(":")) continue;
                                String[] splitPattern = pattern.split(":");
                                Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(dyeColor -> dyeColor.name().equalsIgnoreCase(splitPattern[0])).findFirst();
                                PatternType patternType = PatternType.getByIdentifier((String)splitPattern[1]);
                                if (!color.isPresent() || patternType == null) continue;
                                bukkitPatterns.add(new Pattern(color.get(), patternType));
                            }
                            if (!patterns.isEmpty()) {
                                bmeta.setPatterns(bukkitPatterns);
                            }
                        }
                        break block74;
                    }
                    if (meta instanceof EnchantmentStorageMeta) {
                        JSONArray storedEnchants = extraJson.getArray("stored-enchants");
                        if (storedEnchants != null) {
                            EnchantmentStorageMeta esmeta = (EnchantmentStorageMeta)meta;
                            for (String enchant : storedEnchants.toStringArray()) {
                                Valid.checkBoolean(enchant.contains(":"), "Expected : when parsing enchants from JSON item, got: " + enchants + ". Full item: " + itemJson, new Object[0]);
                                try {
                                    String[] splitEnchant = enchant.split(":");
                                    Enchantment enchantment = Enchantment.getByName((String)splitEnchant[0]);
                                    int level = Integer.parseInt(splitEnchant[1]);
                                    if (enchantment == null || level <= 0) continue;
                                    esmeta.addStoredEnchant(enchantment, level, true);
                                }
                                catch (NumberFormatException splitEnchant) {
                                    // empty catch block
                                }
                            }
                        }
                    } else if (meta instanceof LeatherArmorMeta) {
                        String color = extraJson.getString("color");
                        if (color != null) {
                            try {
                                ((LeatherArmorMeta)meta).setColor(Color.fromRGB((int)Integer.parseInt(color, 16)));
                            }
                            catch (NumberFormatException esmeta) {}
                        }
                    } else if (meta instanceof BookMeta) {
                        BookMeta bmeta = (BookMeta)meta;
                        String title = extraJson.getString("title");
                        String[] author = extraJson.getString("author");
                        JSONArray pages = extraJson.getArray("pages");
                        if (title != null) {
                            bmeta.setTitle(title);
                        }
                        if (author != null) {
                            bmeta.setAuthor((String)author);
                        }
                        if (pages != null) {
                            bmeta.setPages(Arrays.asList(pages.toStringArray()));
                        }
                    } else if (meta instanceof PotionMeta) {
                        JSONArray effects = extraJson.getArray("custom-effects");
                        PotionMeta pmeta = (PotionMeta)meta;
                        if (effects != null) {
                            for (String effect : effects.toStringArray()) {
                                Valid.checkBoolean(effect.contains(":"), "Expected : when parsing effects from JSON item, got: " + effects + ". Full item: " + itemJson, new Object[0]);
                                try {
                                    String[] splitPotions = effect.split(":");
                                    PotionEffectType potionType = PotionEffectType.getByName((String)splitPotions[0]);
                                    int amplifier = Integer.parseInt(splitPotions[1]);
                                    int duration = Integer.parseInt(splitPotions[2]) * 20;
                                    if (potionType == null) continue;
                                    pmeta.addCustomEffect(new PotionEffect(potionType, amplifier, duration), true);
                                }
                                catch (NumberFormatException splitPotions) {
                                    // empty catch block
                                }
                            }
                        } else {
                            JSONObject basePotion = extraJson.getObject("base-effect");
                            PotionType potionType = PotionType.valueOf((String)basePotion.getString("type"));
                            boolean isExtended = basePotion.getBoolean("isExtended");
                            boolean isUpgraded = basePotion.getBoolean("isUpgraded");
                            try {
                                PotionData potionData = new PotionData(potionType, isExtended, isUpgraded);
                                pmeta.setBasePotionData(potionData);
                            }
                            catch (Throwable potionData) {}
                        }
                    } else if (meta instanceof FireworkEffectMeta) {
                        String effectTypeName = extraJson.getString("type");
                        boolean flicker = extraJson.getBoolean("flicker");
                        boolean trail = extraJson.getBoolean("trail");
                        JSONArray colorsElement = extraJson.getArray("colors");
                        JSONArray fadeColorsElement = extraJson.getArray("fade-colors");
                        if (effectTypeName != null) {
                            FireworkEffectMeta femeta = (FireworkEffectMeta)meta;
                            FireworkEffect.Type effectType = FireworkEffect.Type.valueOf((String)effectTypeName);
                            if (effectType != null) {
                                ArrayList colors = new ArrayList();
                                if (colorsElement != null) {
                                    colorsElement.forEach(colorElement -> colors.add(Color.fromRGB((int)Integer.parseInt(colorElement.toString(), 16))));
                                }
                                ArrayList fadeColors = new ArrayList();
                                if (fadeColorsElement != null) {
                                    fadeColorsElement.forEach(colorElement -> fadeColors.add(Color.fromRGB((int)Integer.parseInt(colorElement.toString(), 16))));
                                }
                                FireworkEffect.Builder builder = FireworkEffect.builder().with(effectType);
                                builder.flicker(flicker);
                                builder.trail(trail);
                                if (!colors.isEmpty()) {
                                    builder.withColor(colors);
                                }
                                if (!fadeColors.isEmpty()) {
                                    builder.withFade(fadeColors);
                                }
                                femeta.setEffect(builder.build());
                            }
                        }
                    } else if (meta instanceof FireworkMeta) {
                        FireworkMeta fmeta = (FireworkMeta)meta;
                        JSONArray effectArrayElement = extraJson.getArray("effects");
                        Integer powerElement = extraJson.getInteger("power");
                        if (powerElement != null) {
                            fmeta.setPower(powerElement.intValue());
                        }
                        if (effectArrayElement != null) {
                            for (JSONObject jsonObject : effectArrayElement.toObjectArray()) {
                                FireworkEffect.Type effectType;
                                String effectTypeElement = jsonObject.getString("type");
                                boolean flicker = jsonObject.getBoolean("flicker");
                                boolean trail = jsonObject.getBoolean("trail");
                                JSONArray colorsElement = jsonObject.getArray("colors");
                                JSONArray fadeColorsElement = jsonObject.getArray("fade-colors");
                                if (effectTypeElement == null || (effectType = FireworkEffect.Type.valueOf((String)effectTypeElement)) == null) continue;
                                ArrayList colors = new ArrayList();
                                if (colorsElement != null) {
                                    colorsElement.forEach(colorElement -> colors.add(Color.fromRGB((int)Integer.parseInt(colorElement.toString(), 16))));
                                }
                                ArrayList fadeColors = new ArrayList();
                                if (fadeColorsElement != null) {
                                    fadeColorsElement.forEach(colorElement -> fadeColors.add(Color.fromRGB((int)Integer.parseInt(colorElement.toString(), 16))));
                                }
                                FireworkEffect.Builder builder = FireworkEffect.builder().with(effectType);
                                builder.flicker(flicker);
                                builder.trail(trail);
                                if (!colors.isEmpty()) {
                                    builder.withColor(colors);
                                }
                                if (!fadeColors.isEmpty()) {
                                    builder.withFade(fadeColors);
                                }
                                fmeta.addEffect(builder.build());
                            }
                        }
                    } else if (meta instanceof MapMeta) {
                        MapMeta mmeta = (MapMeta)meta;
                        Boolean scaling = extraJson.getBoolean("scaling");
                        if (scaling != null) {
                            mmeta.setScaling(scaling.booleanValue());
                        }
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }
}

