/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.meta.ItemMeta;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTEntity;

public enum CompProperty {
    UNBREAKABLE(ItemMeta.class, Boolean.TYPE),
    GLOWING(Entity.class, Boolean.TYPE),
    AI(Entity.class, Boolean.TYPE),
    GRAVITY(Entity.class, Boolean.TYPE),
    SILENT(Entity.class, Boolean.TYPE),
    INVULNERABLE(Entity.class, Boolean.TYPE);

    private final Class<?> requiredClass;
    private final Class<?> setterMethodType;
    private final Map<Class<?>, Boolean> isAvailable = new HashMap();
    private final Map<Class<?>, Method> cachedMethods = new HashMap();

    public void apply(Object instance, Object key) {
        Valid.checkNotNull(instance, "instance is null!");
        Valid.checkBoolean(this.requiredClass.isAssignableFrom(instance.getClass()), (Object)((Object)this) + " accepts " + this.requiredClass.getSimpleName() + ", not " + instance.getClass().getSimpleName(), new Object[0]);
        Method method = this.getMethod(instance.getClass());
        if (method == null) {
            this.applyLegacy(instance, key);
        } else {
            try {
                ReflectionUtil.invoke(method, instance, key);
            }
            catch (Throwable t) {
                if (MinecraftVersion.olderThan(MinecraftVersion.V.values()[0])) {
                    this.applyLegacy(instance, key);
                }
                t.printStackTrace();
            }
        }
    }

    private void applyLegacy(Object instance, Object key) {
        block9: {
            if (instance instanceof Entity) {
                NBTEntity nbtEntity = new NBTEntity((Entity)instance);
                boolean has = Boolean.parseBoolean(key.toString());
                if (this == INVULNERABLE) {
                    nbtEntity.setInteger("Invulnerable", has ? 1 : 0);
                } else if (this == AI) {
                    nbtEntity.setInteger("NoAI", has ? 0 : 1);
                } else if (this == GRAVITY) {
                    nbtEntity.setInteger("NoGravity", has ? 0 : 1);
                }
            }
            if (Remain.hasItemMeta() && instance instanceof ItemMeta && this == UNBREAKABLE) {
                try {
                    boolean has = Boolean.parseBoolean(key.toString());
                    Method spigotMethod = instance.getClass().getMethod("spigot", new Class[0]);
                    spigotMethod.setAccessible(true);
                    Object spigot = spigotMethod.invoke(instance, new Object[0]);
                    Method setUnbreakable = spigot.getClass().getMethod("setUnbreakable", Boolean.TYPE);
                    setUnbreakable.setAccessible(true);
                    setUnbreakable.invoke(spigot, has);
                }
                catch (Throwable t) {
                    if (!MinecraftVersion.atLeast(MinecraftVersion.V.v1_8)) break block9;
                    t.printStackTrace();
                }
            }
        }
    }

    public boolean isAvailable(Class<?> clazz) {
        if (this.isAvailable.containsKey(clazz)) {
            return this.isAvailable.get(clazz);
        }
        return this.getMethod(clazz) != null;
    }

    private Method getMethod(Class<?> clazz) {
        if (this.isAvailable.containsKey(clazz) && !this.isAvailable.get(clazz).booleanValue()) {
            return null;
        }
        Method method = this.cachedMethods.get(clazz);
        if (method == null) {
            try {
                method = clazz.getMethod("set" + (this.toString().equals("AI") ? "AI" : ChatUtil.capitalize(this.toString().toLowerCase())), this.setterMethodType);
                method.setAccessible(true);
                this.isAvailable.put(clazz, true);
                this.cachedMethods.put(clazz, method);
            }
            catch (Throwable t) {
                this.isAvailable.put(clazz, false);
                return null;
            }
        }
        return method;
    }

    private CompProperty(Class<?> requiredClass, Class<?> setterMethodType) {
        this.requiredClass = requiredClass;
        this.setterMethodType = setterMethodType;
    }

    public Class<?> getRequiredClass() {
        return this.requiredClass;
    }
}

