/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public enum CompParticle {
    EXPLOSION_NORMAL("explode"),
    EXPLOSION_LARGE("largeexplode"),
    EXPLOSION_HUGE("hugeexplosion"),
    FIREWORKS_SPARK("fireworksSpark"),
    WATER_BUBBLE("bubble"),
    WATER_SPLASH("splash"),
    WATER_WAKE("wake"),
    SUSPENDED("suspend"),
    SUSPENDED_DEPTH("depthsuspend"),
    CRIT("crit"),
    CRIT_MAGIC("magicCrit"),
    SMOKE_NORMAL("smoke"),
    SMOKE_LARGE("largesmoke"),
    SPELL("spell"),
    SPELL_INSTANT("instantSpell"),
    SPELL_MOB("mobSpell"),
    SPELL_MOB_AMBIENT("mobSpellAmbient"),
    SPELL_WITCH("witchMagic"),
    DRIP_WATER("dripWater"),
    DRIP_LAVA("dripLava"),
    VILLAGER_ANGRY("angryVillager"),
    VILLAGER_HAPPY("happyVillager"),
    TOWN_AURA("townaura"),
    NOTE("note"),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchantmenttable"),
    FLAME("flame"),
    LAVA("lava"),
    FOOTSTEP("footstep"),
    CLOUD("cloud"),
    REDSTONE("reddust"),
    SNOWBALL("snowballpoof"),
    SNOW_SHOVEL("snowshovel"),
    SLIME("slime"),
    HEART("heart"),
    BARRIER("barrier"),
    ITEM_CRACK("iconcrack_"),
    BLOCK_CRACK("blockcrack_"),
    BLOCK_DUST("blockdust_"),
    WATER_DROP("droplet"),
    ITEM_TAKE("take"),
    MOB_APPEARANCE("mobappearance"),
    DRAGON_BREATH,
    END_ROD,
    DAMAGE_INDICATOR,
    SWEEP_ATTACK,
    FALLING_DUST,
    TOTEM,
    SPIT,
    SQUID_INK,
    BUBBLE_POP,
    CURRENT_DOWN,
    BUBBLE_COLUMN_UP,
    NAUTILUS,
    DOLPHIN,
    SNEEZE,
    CAMPFIRE_COSY_SMOKE,
    CAMPFIRE_SIGNAL_SMOKE,
    COMPOSTER,
    FLASH,
    FALLING_LAVA,
    LANDING_LAVA,
    FALLING_WATER,
    DRIPPING_HONEY,
    FALLING_HONEY,
    LANDING_HONEY,
    FALLING_NECTAR,
    SOUL_FIRE_FLAME,
    ASH,
    CRIMSON_SPORE,
    WARPED_SPORE,
    SOUL,
    DRIPPING_OBSIDIAN_TEAR,
    FALLING_OBSIDIAN_TEAR,
    LANDING_OBSIDIAN_TEAR,
    REVERSE_PORTAL,
    WHITE_ASH,
    LIGHT,
    DUST_COLOR_TRANSITION,
    VIBRATION,
    FALLING_SPORE_BLOSSOM,
    SPORE_BLOSSOM_AIR,
    SMALL_FLAME,
    SNOWFLAKE,
    DRIPPING_DRIPSTONE_LAVA,
    FALLING_DRIPSTONE_LAVA,
    DRIPPING_DRIPSTONE_WATER,
    FALLING_DRIPSTONE_WATER,
    GLOW_SQUID_INK,
    GLOW,
    WAX_ON,
    WAX_OFF,
    ELECTRIC_SPARK,
    SCRAPE;

    private static final boolean atLeast1_13;
    private static final boolean atLeast1_12;
    private static final boolean atLeast1_8;
    private final String name1_7;
    @Nullable
    private final Object nmsEnumParticle;
    @Nullable
    private final Object bukkitEnumParticle;
    private final Constructor<?> packetConstructor;

    private CompParticle() {
        this(null);
    }

    private CompParticle(String name1_7) {
        this.name1_7 = name1_7;
        try {
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7) && MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                Class<?> packetClass;
                try {
                    packetClass = ReflectionUtil.getNMSClass("PacketPlayOutWorldParticles", "N/A");
                }
                catch (ReflectionUtil.ReflectionException ex) {
                    this.nmsEnumParticle = null;
                    this.packetConstructor = null;
                    this.bukkitEnumParticle = null;
                    return;
                }
                if (MinecraftVersion.equals(MinecraftVersion.V.v1_7)) {
                    this.nmsEnumParticle = null;
                    this.packetConstructor = ReflectionUtil.getConstructor(packetClass, String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                } else {
                    Class<?> particleClass = ReflectionUtil.getNMSClass("EnumParticle");
                    this.nmsEnumParticle = ReflectionUtil.lookupEnumSilent(particleClass, this.name());
                    this.packetConstructor = this.nmsEnumParticle == null ? null : ReflectionUtil.getConstructor(packetClass, particleClass, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
                }
            } else {
                this.nmsEnumParticle = null;
                this.packetConstructor = null;
            }
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_12)) {
                Class particleClass = ReflectionUtil.lookupClass("org.bukkit.Particle");
                this.bukkitEnumParticle = ReflectionUtil.lookupEnumSilent(particleClass, this.name());
            } else {
                this.bukkitEnumParticle = null;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Fatal error setting up CompParticle, see above");
        }
    }

    public void spawn(Location location, Color color, float particleSize) {
        Valid.checkBoolean(this == REDSTONE, "Can only send colors for REDSTONE particle, not: " + (Object)((Object)this), new Object[0]);
        if (atLeast1_13) {
            location.getWorld().spawnParticle((Particle)this.bukkitEnumParticle, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(color, particleSize));
        } else {
            float red = color.getRed() == 0 ? Float.MIN_VALUE : (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            this.spawn(location, red, (double)green, (double)blue, 1.0, 0, 1.0, null);
        }
    }

    public void spawn(Player player, Location location, Color color, float particleSize) {
        Valid.checkBoolean(this == REDSTONE, "Can only send colors for REDSTONE particle, not: " + (Object)((Object)this), new Object[0]);
        if (atLeast1_13) {
            player.spawnParticle((Particle)this.bukkitEnumParticle, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(color, particleSize));
        } else {
            float red = color.getRed() == 0 ? Float.MIN_VALUE : (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            this.spawn(player, location, (double)red, (double)green, (double)blue, 1.0, 0, 1.0, null);
        }
    }

    public void spawn(Location location) {
        this.spawn(location, 0.0, 0.0, 0.0, 0.0, 0, 0.0, null);
    }

    public final void spawn(Location location, CompMaterial data) {
        Valid.checkBoolean(this == ITEM_CRACK || this == BLOCK_CRACK || this == BLOCK_DUST || this == FALLING_DUST, "Can only call particle spawn with data on crack or dust particles, not: " + (Object)((Object)this), new Object[0]);
        if (atLeast1_12) {
            if (atLeast1_13) {
                location.getWorld().spawnParticle((Particle)this.bukkitEnumParticle, location, 1, (Object)data.getMaterial().createBlockData());
            } else {
                location.getWorld().spawnParticle((Particle)this.bukkitEnumParticle, location, 1, (Object)data.getMaterial().getNewData(data.getData()));
            }
        } else {
            this.spawn(location, 0.0, 0.0, 0.0, 0.0, 1, 0.0, data.getData());
        }
    }

    public final void spawn(Location location, double extra) {
        this.spawn(location, 0.0, extra);
    }

    public final void spawn(Location location, double speed, double extra) {
        this.spawn(location, 0.0, 0.0, 0.0, speed, 0, extra, null);
    }

    public void spawn(Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double extra, int ... data) {
        if (this.bukkitEnumParticle != null) {
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) && this == REDSTONE) {
                location.getWorld().spawnParticle((Particle)this.bukkitEnumParticle, location, count, offsetX, offsetY, offsetZ, extra, (Object)new Particle.DustOptions(Color.RED, 1.0f));
            } else {
                location.getWorld().spawnParticle((Particle)this.bukkitEnumParticle, location, count, offsetX, offsetY, offsetZ, extra, (Object)data);
            }
        } else if (this.packetConstructor != null) {
            Object packet = this.preparePacket(location.getX(), location.getY(), location.getZ(), offsetX, offsetY, offsetZ, speed, count, extra, data);
            for (Player player : Remain.getOnlinePlayers()) {
                Remain.sendPacket(player, packet);
            }
        }
    }

    public void spawn(Player player, Location location) {
        this.spawn(player, location, 0.0, 0.0, 0.0, 0.0, 0, 0.0, null);
    }

    public void spawn(Player player, Location location, double extra) {
        this.spawn(player, location, 0.0, 0.0, 0.0, 0.0, 0, extra, null);
    }

    public final void spawn(Player player, Location location, CompMaterial data) {
        Valid.checkBoolean(this == ITEM_CRACK || this == BLOCK_CRACK || this == BLOCK_DUST || this == FALLING_DUST, "Can only call particle spawn with data on crack or dust particles, not: " + (Object)((Object)this), new Object[0]);
        if (atLeast1_12) {
            if (atLeast1_13) {
                player.spawnParticle((Particle)this.bukkitEnumParticle, location, 1, (Object)data.getMaterial().createBlockData());
            } else {
                player.spawnParticle((Particle)this.bukkitEnumParticle, location, 1, (Object)data.getMaterial().getNewData(data.getData()));
            }
        } else {
            this.spawn(player, location, 0.0, 0.0, 0.0, 0.0, 1, 0.0, data.getData());
        }
    }

    public void spawn(Player player, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double extra, int ... data) {
        if (this.bukkitEnumParticle != null && this != REDSTONE) {
            player.spawnParticle((Particle)this.bukkitEnumParticle, location, count, offsetX, offsetY, offsetZ, extra, (Object)data);
        } else if (this.packetConstructor != null) {
            Remain.sendPacket(player, this.preparePacket(location.getX(), location.getY(), location.getZ(), offsetX, offsetY, offsetZ, speed, count, extra, data));
        }
    }

    private Object preparePacket(double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ, double speed, int count, double extra, int ... data) {
        if (atLeast1_8) {
            if (this == BLOCK_CRACK) {
                int materialId = 0;
                int materialData = 0;
                if (data.length > 0) {
                    materialId = data[0];
                }
                if (data.length > 1) {
                    materialData = data[1];
                }
                data = new int[]{materialId, materialId | materialData << 12};
            }
            return ReflectionUtil.instantiate(this.packetConstructor, this.nmsEnumParticle, true, Float.valueOf((float)posX), Float.valueOf((float)posY), Float.valueOf((float)posZ), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)speed), count, data);
        }
        String correctedName = this.name1_7;
        if (this == BLOCK_CRACK || this == ITEM_CRACK || this == BLOCK_DUST) {
            int materialId = 0;
            int materialData = 0;
            if (data.length > 0) {
                materialId = data[0];
            }
            if (data.length > 1) {
                materialData = data[1];
            }
            correctedName = correctedName + materialId + "_" + materialData;
        }
        return ReflectionUtil.instantiate(this.packetConstructor, correctedName, Float.valueOf((float)posX), Float.valueOf((float)posY), Float.valueOf((float)posZ), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)speed), count);
    }

    static {
        atLeast1_13 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13);
        atLeast1_12 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_12);
        atLeast1_8 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_8);
    }
}

