/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.annotation.AutoRegister;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.constants.FoConstants;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTCompound;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTItem;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class CompMetadata {
    private static final String DELIMITER = "%-%";

    public static ItemStack setMetadata(ItemStack item, String key, String value) {
        Valid.checkNotNull(item, "Setting NBT tag got null item");
        NBTItem nbt = new NBTItem(item);
        NBTCompound tag = nbt.addCompound(FoConstants.NBT.TAG);
        tag.setString(key, value);
        return nbt.getItem();
    }

    public static void setMetadata(Entity entity, String tag) {
        CompMetadata.setMetadata(entity, tag, tag);
    }

    public static void setMetadata(Entity entity, String key, String value) {
        Valid.checkNotNull(entity);
        if (Remain.hasScoreboardTags()) {
            String tag = CompMetadata.format(key, value);
            if (!entity.getScoreboardTags().contains(tag)) {
                entity.addScoreboardTag(tag);
            }
        } else {
            entity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
            MetadataFile.getInstance().addMetadata(entity, key, value);
        }
    }

    private static String format(String key, String value) {
        return SimplePlugin.getNamed() + DELIMITER + key + DELIMITER + value;
    }

    public static void setMetadata(BlockState tileEntity, String key, String value) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        Valid.checkNotNull(value);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            CompMetadata.setNamedspaced((TileState)tileEntity, key, value);
            tileEntity.update();
        } else {
            tileEntity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
            tileEntity.update();
            MetadataFile.getInstance().addMetadata(tileEntity, key, value);
        }
    }

    private static void setNamedspaced(TileState tile, String key, String value) {
        tile.getPersistentDataContainer().set(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING, (Object)value);
    }

    public static String getMetadata(ItemStack item, String key) {
        Valid.checkNotNull(item, "Reading NBT tag got null item");
        if (item == null || CompMaterial.isAir(item.getType())) {
            return null;
        }
        NBTItem nbt = new NBTItem(item);
        String compoundTag = FoConstants.NBT.TAG;
        String value = nbt.hasKey(compoundTag) != false ? nbt.getCompound(compoundTag).getString(key) : null;
        return Common.getOrNull(value);
    }

    public static String getMetadata(Entity entity, String key) {
        Valid.checkNotNull(entity);
        if (Remain.hasScoreboardTags()) {
            for (String line : entity.getScoreboardTags()) {
                String tag = CompMetadata.getTag(line, key);
                if (tag == null || tag.isEmpty()) continue;
                return tag;
            }
        }
        String value = entity.hasMetadata(key) ? ((MetadataValue)entity.getMetadata(key).get(0)).asString() : null;
        return Common.getOrNull(value);
    }

    private static String getTag(String raw, String key) {
        String[] parts = raw.split(DELIMITER);
        return parts.length == 3 && parts[0].equals(SimplePlugin.getNamed()) && parts[1].equals(key) ? parts[2] : null;
    }

    public static String getMetadata(BlockState tileEntity, String key) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            return CompMetadata.getNamedspaced((TileState)tileEntity, key);
        }
        String value = tileEntity.hasMetadata(key) ? ((MetadataValue)tileEntity.getMetadata(key).get(0)).asString() : null;
        return Common.getOrNull(value);
    }

    private static String getNamedspaced(TileState tile, String key) {
        String value = (String)tile.getPersistentDataContainer().get(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING);
        return Common.getOrNull(value);
    }

    public static boolean hasMetadata(ItemStack item, String key) {
        Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_7), "NBT ItemStack tags only support MC 1.7.10+", new Object[0]);
        Valid.checkNotNull(item);
        if (CompMaterial.isAir(item.getType())) {
            return false;
        }
        NBTItem nbt = new NBTItem(item);
        NBTCompound tag = nbt.getCompound(FoConstants.NBT.TAG);
        return tag != null && tag.hasKey(key) != false;
    }

    public static boolean hasMetadata(Entity entity, String key) {
        Valid.checkNotNull(entity);
        if (Remain.hasScoreboardTags()) {
            for (String line : entity.getScoreboardTags()) {
                if (!CompMetadata.hasTag(line, key)) continue;
                return true;
            }
        }
        return entity.hasMetadata(key);
    }

    public static boolean hasMetadata(BlockState tileEntity, String key) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            return CompMetadata.hasNamedspaced((TileState)tileEntity, key);
        }
        return tileEntity.hasMetadata(key);
    }

    private static boolean hasNamedspaced(TileState tile, String key) {
        return tile.getPersistentDataContainer().has(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING);
    }

    private static boolean hasTag(String raw, String tag) {
        String[] parts = raw.split(DELIMITER);
        return parts.length == 3 && parts[0].equals(SimplePlugin.getNamed()) && parts[1].equals(tag);
    }

    public static void setTempMetadata(Entity entity, String tag) {
        entity.setMetadata(tag, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)tag));
    }

    public static void setTempMetadata(Entity entity, String tag, Object key) {
        entity.setMetadata(tag, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), key));
    }

    public static MetadataValue getTempMetadata(Entity entity, String key) {
        return entity.hasMetadata(key) ? (MetadataValue)entity.getMetadata(key).get(0) : null;
    }

    public static boolean hasTempMetadata(Entity player, String tag) {
        return player.hasMetadata(tag);
    }

    public static void removeTempMetadata(Entity player, String key) {
        if (player.hasMetadata(key)) {
            player.removeMetadata(key, (Plugin)SimplePlugin.getInstance());
        }
    }

    private CompMetadata() {
    }

    @AutoRegister
    public static final class MetadataFile
    extends YamlConfig {
        private static volatile Object LOCK = new Object();
        private static volatile MetadataFile instance = new MetadataFile();
        private final StrictMap<UUID, List<String>> entityMetadataMap = new StrictMap();
        private final StrictMap<Location, BlockCache> blockMetadataMap = new StrictMap();

        private MetadataFile() {
            this.setPathPrefix("Metadata");
            this.setSaveEmptyValues(false);
            this.loadConfiguration(NO_DEFAULT, "data.db");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onLoad() {
            Object object = LOCK;
            synchronized (object) {
                this.loadEntities();
                this.loadBlockStates();
            }
        }

        @Override
        protected void onSave() {
            this.set("Entity", this.entityMetadataMap);
            this.set("Block", this.blockMetadataMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadEntities() {
            Object object = LOCK;
            synchronized (object) {
                this.entityMetadataMap.clear();
                for (String uuidName : this.getMap("Entity").keySet()) {
                    UUID uuid = UUID.fromString(uuidName);
                    if (!(this.getObject("Entity." + uuidName) instanceof List)) {
                        this.set("Entity." + uuidName, null);
                        continue;
                    }
                    List<String> metadata = this.getStringList("Entity." + uuidName);
                    Entity entity = Remain.getEntity(uuid);
                    if (metadata.isEmpty() || entity == null || !entity.isValid() || entity.isDead()) continue;
                    this.entityMetadataMap.put(uuid, metadata);
                    this.applySavedMetadata(metadata, (Metadatable)entity);
                }
                this.set("Entity", this.entityMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadBlockStates() {
            Object object = LOCK;
            synchronized (object) {
                this.blockMetadataMap.clear();
                for (String locationRaw : this.getMap("Block").keySet()) {
                    Location location = SerializeUtil.deserializeLocation(locationRaw);
                    BlockCache blockCache = this.get("Block." + locationRaw, BlockCache.class, new Object[0]);
                    Block block = location.getBlock();
                    if (CompMaterial.isAir(block) || CompMaterial.fromBlock(block) != blockCache.getType()) continue;
                    this.blockMetadataMap.put(location, blockCache);
                    this.applySavedMetadata(blockCache.getMetadata(), (Metadatable)block);
                }
                this.set("Block", this.blockMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applySavedMetadata(List<String> metadata, Metadatable entity) {
            Object object = LOCK;
            synchronized (object) {
                for (String metadataLine : metadata) {
                    if (metadataLine.isEmpty()) continue;
                    String[] lines = metadataLine.split(CompMetadata.DELIMITER);
                    Valid.checkBoolean(lines.length == 3, "Malformed metadata line for " + entity + ". Length 3 != " + lines.length + ". Data: " + metadataLine, new Object[0]);
                    String key = lines[1];
                    String value = lines[2];
                    entity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMetadata(Entity entity, @NonNull String key, String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            Object object = LOCK;
            synchronized (object) {
                List metadata = this.entityMetadataMap.getOrPut(entity.getUniqueId(), new ArrayList());
                Iterator i = metadata.iterator();
                while (i.hasNext()) {
                    String meta = (String)i.next();
                    if (CompMetadata.getTag(meta, key) == null) continue;
                    i.remove();
                }
                if (value != null && !value.isEmpty()) {
                    String formatted = CompMetadata.format(key, value);
                    metadata.add(formatted);
                }
                this.save("Entity", this.entityMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMetadata(BlockState blockState, String key, String value) {
            Object object = LOCK;
            synchronized (object) {
                BlockCache blockCache = this.blockMetadataMap.getOrPut(blockState.getLocation(), new BlockCache(CompMaterial.fromBlock(blockState.getBlock()), new ArrayList<String>()));
                Iterator<String> i = blockCache.getMetadata().iterator();
                while (i.hasNext()) {
                    String meta = i.next();
                    if (CompMetadata.getTag(meta, key) == null) continue;
                    i.remove();
                }
                if (value != null && !value.isEmpty()) {
                    String formatted = CompMetadata.format(key, value);
                    blockCache.getMetadata().add(formatted);
                }
                for (Map.Entry<Location, BlockCache> entry : this.blockMetadataMap.entrySet()) {
                    this.set("Block." + SerializeUtil.serializeLoc(entry.getKey()), entry.getValue().serialize());
                }
                this.save();
            }
        }

        public static MetadataFile getInstance() {
            return instance;
        }

        public static final class BlockCache
        implements ConfigSerializable {
            private final CompMaterial type;
            private final List<String> metadata;

            public static BlockCache deserialize(SerializedMap map) {
                CompMaterial type = map.getMaterial("Type");
                List<String> metadata = map.getStringList("Metadata");
                return new BlockCache(type, metadata);
            }

            @Override
            public SerializedMap serialize() {
                SerializedMap map = new SerializedMap();
                map.put("Type", this.type.toString());
                map.put("Metadata", this.metadata);
                return map;
            }

            public CompMaterial getType() {
                return this.type;
            }

            public List<String> getMetadata() {
                return this.metadata;
            }

            public BlockCache(CompMaterial type, List<String> metadata) {
                this.type = type;
                this.metadata = metadata;
            }
        }
    }
}

