/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompColor;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public enum CompEquipmentSlot {
    HAND("HAND", "HAND"),
    OFF_HAND("OFF_HAND", "OFF_HAND"),
    HEAD("HEAD", "HELMET"),
    CHEST("CHEST", "CHESTPLATE"),
    LEGS("LEGS", "LEGGINGS"),
    FEET("FEET", "BOOTS");

    private final String key;
    private final String bukkitName;

    public void applyTo(LivingEntity entity, ItemStack item) {
        this.applyTo(entity, item, null);
    }

    public void applyTo(LivingEntity entity, ItemStack item, @Nullable Double dropChance) {
        EntityEquipment equipment = entity instanceof LivingEntity ? entity.getEquipment() : null;
        Valid.checkNotNull(equipment);
        boolean lacksDropChance = entity instanceof HumanEntity || entity.getType().toString().equals("ARMOR_STAND");
        switch (this) {
            case HAND: {
                equipment.setItemInHand(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setItemInHandDropChance(dropChance.floatValue());
                break;
            }
            case OFF_HAND: {
                Valid.checkBoolean(MinecraftVersion.atLeast(MinecraftVersion.V.v1_9), "Setting off hand item requires Minecraft 1.9+", new Object[0]);
                equipment.setItemInOffHand(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setItemInOffHandDropChance(dropChance.floatValue());
                break;
            }
            case HEAD: {
                equipment.setHelmet(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setHelmetDropChance(dropChance.floatValue());
                break;
            }
            case CHEST: {
                equipment.setChestplate(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setChestplateDropChance(dropChance.floatValue());
                break;
            }
            case LEGS: {
                equipment.setLeggings(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setLeggingsDropChance(dropChance.floatValue());
                break;
            }
            case FEET: {
                equipment.setBoots(item);
                if (dropChance == null || lacksDropChance) break;
                equipment.setBootsDropChance(dropChance.floatValue());
            }
        }
    }

    public static CompEquipmentSlot fromKey(String key) {
        key = key.toUpperCase().replace(" ", "_");
        for (CompEquipmentSlot slot : CompEquipmentSlot.values()) {
            if (!slot.key.equals(key) && !slot.bukkitName.equals(key)) continue;
            return slot;
        }
        throw new FoException("No such equipment slot from key: " + key);
    }

    public static void applyArmor(LivingEntity entity, CompColor color) {
        CompEquipmentSlot.applyArmor(entity, color, (Double)0.0, new HashSet<CompEquipmentSlot>());
    }

    public static void applyArmor(LivingEntity entity, CompColor color, Set<CompEquipmentSlot> ignoredSlots) {
        CompEquipmentSlot.applyArmor(entity, color, (Double)0.0, ignoredSlots);
    }

    public static void applyArmor(LivingEntity entity, CompColor color, double dropChance) {
        CompEquipmentSlot.applyArmor(entity, color, (Double)dropChance, new HashSet<CompEquipmentSlot>());
    }

    public static void applyArmor(LivingEntity entity, CompColor color, Double dropChance, Set<CompEquipmentSlot> ignoredSlots) {
        if (!ignoredSlots.contains((Object)HEAD)) {
            HEAD.applyTo(entity, ItemCreator.of(CompMaterial.LEATHER_HELMET).color(color).make(), dropChance);
        }
        if (!ignoredSlots.contains((Object)CHEST)) {
            CHEST.applyTo(entity, ItemCreator.of(CompMaterial.LEATHER_CHESTPLATE).color(color).make(), dropChance);
        }
        if (!ignoredSlots.contains((Object)LEGS)) {
            LEGS.applyTo(entity, ItemCreator.of(CompMaterial.LEATHER_LEGGINGS).color(color).make(), dropChance);
        }
        if (!ignoredSlots.contains((Object)FEET)) {
            FEET.applyTo(entity, ItemCreator.of(CompMaterial.LEATHER_BOOTS).color(color).make(), dropChance);
        }
    }

    public static void applyArmor(LivingEntity entity, Type type) {
        CompEquipmentSlot.applyArmor(entity, type, (Double)0.0, new HashSet<CompEquipmentSlot>());
    }

    public static void applyArmor(LivingEntity entity, Type type, Set<CompEquipmentSlot> ignoredSlots) {
        CompEquipmentSlot.applyArmor(entity, type, (Double)0.0, ignoredSlots);
    }

    public static void applyArmor(LivingEntity entity, Type type, double dropChance) {
        CompEquipmentSlot.applyArmor(entity, type, (Double)dropChance, new HashSet<CompEquipmentSlot>());
    }

    public static void applyArmor(LivingEntity entity, Type type, Double dropChance, Set<CompEquipmentSlot> ignoredSlots) {
        String name;
        if (type == Type.NETHERITE && MinecraftVersion.olderThan(MinecraftVersion.V.v1_16)) {
            type = Type.DIAMOND;
        }
        String string = name = type == Type.GOLD ? "GOLDEN" : type.toString();
        if (!ignoredSlots.contains((Object)HEAD)) {
            HEAD.applyTo(entity, CompMaterial.valueOf(name + "_HELMET").toItem(), dropChance);
        }
        if (!ignoredSlots.contains((Object)CHEST)) {
            CHEST.applyTo(entity, CompMaterial.valueOf(name + "_CHESTPLATE").toItem(), dropChance);
        }
        if (!ignoredSlots.contains((Object)LEGS)) {
            LEGS.applyTo(entity, CompMaterial.valueOf(name + "_LEGGINGS").toItem(), dropChance);
        }
        if (!ignoredSlots.contains((Object)FEET)) {
            FEET.applyTo(entity, CompMaterial.valueOf(name + "_BOOTS").toItem(), dropChance);
        }
    }

    public String toString() {
        return this.key.toUpperCase();
    }

    private CompEquipmentSlot(String key, String bukkitName) {
        this.key = key;
        this.bukkitName = bukkitName;
    }

    public String getKey() {
        return this.key;
    }

    public String getBukkitName() {
        return this.bukkitName;
    }

    public static enum Type {
        LEATHER,
        CHAINMAIL,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;


        public static Type fromArmor(CompMaterial armorMaterial) {
            String n = armorMaterial.name();
            Valid.checkBoolean(n.contains("LEATHER") || n.contains("CHAINMAIL") || n.contains("IRON") || n.contains("GOLD") || n.contains("DIAMOND") || n.contains("NETHERITE"), "Only leather to netherite armors are supported, not: " + (Object)((Object)armorMaterial), new Object[0]);
            return Type.valueOf(n.split("_")[0]);
        }
    }
}

