/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public final class CompColor {
    private static final List<CompColor> values = new ArrayList<CompColor>();
    public static final CompColor BLUE = new CompColor("BLUE", DyeColor.BLUE);
    public static final CompColor BLACK = new CompColor("BLACK", DyeColor.BLACK);
    public static final CompColor DARK_AQUA = new CompColor("DARK_AQUA", DyeColor.CYAN);
    public static final CompColor DARK_BLUE = new CompColor("DARK_BLUE", DyeColor.BLUE);
    public static final CompColor AQUA = new CompColor("AQUA", DyeColor.LIGHT_BLUE);
    public static final CompColor GRAY = new CompColor("GRAY", CompColor.getEnum("LIGHT_GRAY", "SILVER", DyeColor.class), null, "SILVER");
    public static final CompColor DARK_GRAY = new CompColor("DARK_GRAY", DyeColor.GRAY);
    public static final CompColor DARK_GREEN = new CompColor("DARK_GREEN", DyeColor.GREEN);
    public static final CompColor GREEN = new CompColor("GREEN", DyeColor.LIME);
    public static final CompColor GOLD = new CompColor("GOLD", DyeColor.ORANGE);
    public static final CompColor BROWN = new CompColor("BROWN", DyeColor.BROWN, ChatColor.GOLD);
    public static final CompColor DARK_RED = new CompColor("DARK_RED", DyeColor.RED);
    public static final CompColor RED = new CompColor("RED", DyeColor.RED);
    public static final CompColor WHITE = new CompColor("WHITE", DyeColor.WHITE);
    public static final CompColor YELLOW = new CompColor("YELLOW", DyeColor.YELLOW);
    public static final CompColor DARK_PURPLE = new CompColor("DARK_PURPLE", DyeColor.PURPLE);
    public static final CompColor LIGHT_PURPLE = new CompColor("LIGHT_PURPLE", DyeColor.MAGENTA);
    public static final CompColor PINK = new CompColor("PINK", DyeColor.PINK, ChatColor.LIGHT_PURPLE);
    private final String name;
    private final DyeColor dye;
    private final ChatColor chatColor;
    private final String legacyName;
    private Color color;

    private CompColor(Color color) {
        this(null, null, null);
        this.color = color;
    }

    private CompColor(String name, DyeColor dye) {
        this(name, dye, null);
    }

    private CompColor(String name, DyeColor dye, ChatColor chatColor) {
        this(name, dye, chatColor, null);
    }

    private CompColor(String name, DyeColor dye, ChatColor chatColor, String legacyName) {
        this.name = name;
        this.dye = dye;
        this.chatColor = chatColor == null ? (name != null ? ChatColor.valueOf((String)name) : ChatColor.WHITE) : chatColor;
        this.legacyName = Common.getOrEmpty(legacyName);
        values.add(this);
    }

    public Color getColor() {
        return this.color != null ? this.color : this.dye.getColor();
    }

    public CompMaterial getWool() {
        return CompColor.toWool(this.chatColor);
    }

    private static <T extends Enum<T>> T getEnum(String newName, String oldName, Class<T> clazz) {
        T en = ReflectionUtil.lookupEnumSilent(clazz, newName);
        if (en == null) {
            en = ReflectionUtil.lookupEnumSilent(clazz, oldName);
        }
        return en;
    }

    public static CompColor fromWoolData(byte data) {
        return CompColor.fromDye(DyeColor.getByWoolData((byte)data));
    }

    public static CompColor fromColor(Color color) {
        return CompColor.fromName("#" + Integer.toHexString(color.asRGB()).substring(2));
    }

    public static CompColor fromName(String name) {
        if (name.startsWith("#") && name.length() == 7) {
            return new CompColor(Color.fromRGB((int)Integer.parseInt(name.substring(1, 3), 16), (int)Integer.parseInt(name.substring(3, 5), 16), (int)Integer.parseInt(name.substring(5, 7), 16)));
        }
        name = name.toUpperCase();
        for (CompColor comp : CompColor.values()) {
            if (!comp.chatColor.toString().equals(name) && !comp.dye.toString().equals(name) && !comp.legacyName.equals(name)) continue;
            return comp;
        }
        throw new IllegalArgumentException("Could not get CompColor from name: " + name);
    }

    public static CompColor fromDye(DyeColor dye) {
        for (CompColor comp : CompColor.values()) {
            if (comp.dye != dye && !comp.legacyName.equals(dye.toString())) continue;
            return comp;
        }
        throw new IllegalArgumentException("Could not get CompColor from DyeColor." + dye.toString());
    }

    public static CompColor fromChatColor(ChatColor color) {
        for (CompColor comp : CompColor.values()) {
            if (comp.chatColor != color && !comp.legacyName.equals(color.toString())) continue;
            return comp;
        }
        throw new IllegalArgumentException("Could not get CompColor from ChatColor." + color.name());
    }

    public static CompColor fromChatColor(CompChatColor color) {
        for (CompColor comp : CompColor.values()) {
            if (!comp.chatColor.name().equalsIgnoreCase(color.getName()) && !comp.legacyName.equalsIgnoreCase(color.toString())) continue;
            return comp;
        }
        throw new FoException("Could not get CompColor from ChatColor." + color.getName());
    }

    public static DyeColor toDye(ChatColor color) {
        CompColor c = CompColor.fromName(color.name());
        return c != null ? c.getDye() : DyeColor.WHITE;
    }

    public static ChatColor toColor(DyeColor dye) {
        for (CompColor c : CompColor.values()) {
            if (c.getDye() != dye) continue;
            return c.getChatColor();
        }
        return ChatColor.WHITE;
    }

    public static CompMaterial toConcrete(ChatColor color) {
        CompMaterial wool = CompColor.toWool(color);
        return CompMaterial.fromString(wool.toString().replace("_WOOL", MinecraftVersion.olderThan(MinecraftVersion.V.v1_12) ? "_STAINED_GLASS" : "_CONCRETE"));
    }

    public static CompMaterial toWool(ChatColor color) {
        CompColor comp = CompColor.fromChatColor(color);
        if (comp == AQUA) {
            return CompMaterial.LIGHT_BLUE_WOOL;
        }
        if (comp == BLACK) {
            return CompMaterial.BLACK_WOOL;
        }
        if (comp == BLUE) {
            return CompMaterial.BLUE_WOOL;
        }
        if (comp == BROWN) {
            return CompMaterial.BROWN_WOOL;
        }
        if (comp == DARK_AQUA) {
            return CompMaterial.CYAN_WOOL;
        }
        if (comp == DARK_BLUE) {
            return CompMaterial.BLUE_WOOL;
        }
        if (comp == DARK_GRAY) {
            return CompMaterial.GRAY_WOOL;
        }
        if (comp == DARK_GREEN) {
            return CompMaterial.GREEN_WOOL;
        }
        if (comp == DARK_PURPLE) {
            return CompMaterial.PURPLE_WOOL;
        }
        if (comp == DARK_RED) {
            return CompMaterial.RED_WOOL;
        }
        if (comp == GOLD) {
            return CompMaterial.ORANGE_WOOL;
        }
        if (comp == GRAY) {
            return CompMaterial.LIGHT_GRAY_WOOL;
        }
        if (comp == GREEN) {
            return CompMaterial.LIME_WOOL;
        }
        if (comp == LIGHT_PURPLE) {
            return CompMaterial.MAGENTA_WOOL;
        }
        if (comp == PINK) {
            return CompMaterial.PINK_WOOL;
        }
        if (comp == RED) {
            return CompMaterial.RED_WOOL;
        }
        if (comp == WHITE) {
            return CompMaterial.WHITE_WOOL;
        }
        if (comp == YELLOW) {
            return CompMaterial.YELLOW_WOOL;
        }
        return CompMaterial.WHITE_WOOL;
    }

    public static List<ChatColor> getChatColors() {
        ArrayList<ChatColor> list = new ArrayList<ChatColor>();
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor() || color.isFormat()) continue;
            list.add(color);
        }
        return list;
    }

    public static CompColor[] values() {
        return values.toArray(new CompColor[values.size()]);
    }

    public static CompColor valueOf(String name) {
        return CompColor.fromName(name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public DyeColor getDye() {
        return this.dye;
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }
}

