/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;

public final class CompChatColor {
    public static final char COLOR_CHAR = '\u00a7';
    public static final String ALL_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx";
    private static final Map<Character, CompChatColor> BY_CHAR = new HashMap<Character, CompChatColor>();
    private static final Map<String, CompChatColor> BY_NAME = new HashMap<String, CompChatColor>();
    private static final Color[] LEGACY_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 170), new Color(0, 170, 0), new Color(0, 170, 170), new Color(170, 0, 0), new Color(170, 0, 170), new Color(255, 170, 0), new Color(170, 170, 170), new Color(85, 85, 85), new Color(85, 85, 255), new Color(85, 255, 85), new Color(85, 255, 255), new Color(255, 85, 85), new Color(255, 85, 255), new Color(255, 255, 85), new Color(255, 255, 255)};
    public static final CompChatColor BLACK = new CompChatColor('0', "black", new Color(0));
    public static final CompChatColor DARK_BLUE = new CompChatColor('1', "dark_blue", new Color(170));
    public static final CompChatColor DARK_GREEN = new CompChatColor('2', "dark_green", new Color(43520));
    public static final CompChatColor DARK_AQUA = new CompChatColor('3', "dark_aqua", new Color(43690));
    public static final CompChatColor DARK_RED = new CompChatColor('4', "dark_red", new Color(0xAA0000));
    public static final CompChatColor DARK_PURPLE = new CompChatColor('5', "dark_purple", new Color(0xAA00AA));
    public static final CompChatColor GOLD = new CompChatColor('6', "gold", new Color(0xFFAA00));
    public static final CompChatColor GRAY = new CompChatColor('7', "gray", new Color(0xAAAAAA));
    public static final CompChatColor DARK_GRAY = new CompChatColor('8', "dark_gray", new Color(0x555555));
    public static final CompChatColor BLUE = new CompChatColor('9', "blue", new Color(0x5555FF));
    public static final CompChatColor GREEN = new CompChatColor('a', "green", new Color(0x55FF55));
    public static final CompChatColor AQUA = new CompChatColor('b', "aqua", new Color(0x55FFFF));
    public static final CompChatColor RED = new CompChatColor('c', "red", new Color(0xFF5555));
    public static final CompChatColor LIGHT_PURPLE = new CompChatColor('d', "light_purple", new Color(0xFF55FF));
    public static final CompChatColor YELLOW = new CompChatColor('e', "yellow", new Color(0xFFFF55));
    public static final CompChatColor WHITE = new CompChatColor('f', "white", new Color(0xFFFFFF));
    public static final CompChatColor MAGIC = new CompChatColor('k', "obfuscated");
    public static final CompChatColor BOLD = new CompChatColor('l', "bold");
    public static final CompChatColor STRIKETHROUGH = new CompChatColor('m', "strikethrough");
    public static final CompChatColor UNDERLINE = new CompChatColor('n', "underline");
    public static final CompChatColor ITALIC = new CompChatColor('o', "italic");
    public static final CompChatColor RESET = new CompChatColor('r', "reset");
    private final char code;
    private final String name;
    private final Color color;
    private final String toString;

    private CompChatColor(char code, String name) {
        this(code, name, null);
    }

    private CompChatColor(char code, String name, Color color) {
        this.code = code;
        this.name = name;
        this.color = color;
        this.toString = new String(new char[]{'\u00a7', code});
        BY_CHAR.put(Character.valueOf(code), this);
        BY_NAME.put(name.toUpperCase(Locale.ROOT), this);
    }

    private CompChatColor(String name, String toString, int rgb) {
        this.code = (char)35;
        this.name = name;
        this.color = new Color(rgb);
        this.toString = toString;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.toString);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.toString, ((CompChatColor)obj).toString);
    }

    public char getCode() {
        Valid.checkBoolean(this.code != '#', "Cannot retrieve color code for HEX colors", new Object[0]);
        return this.code;
    }

    public boolean isHex() {
        return this.code == '#';
    }

    public String toEscapedString() {
        return this.isHex() ? this.toString + "\\\\" + this.getName() : ItemUtil.bountify(this.getName());
    }

    public String toSaveableString() {
        return this.getName();
    }

    public String toString() {
        return this.toString;
    }

    public static CompChatColor getByChar(char code) {
        return BY_CHAR.get(Character.valueOf(code));
    }

    public static CompChatColor of(Color color) {
        return CompChatColor.of("#" + Integer.toHexString(color.getRGB()).substring(2));
    }

    public static CompChatColor of(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (string.startsWith("#") && string.length() == 7) {
            int rgb;
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_7)) {
                return WHITE;
            }
            if (!MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
                Color color = CompChatColor.getColorFromHex(string);
                return CompChatColor.getClosestLegacyColor(color);
            }
            try {
                rgb = Integer.parseInt(string.substring(1), 16);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Illegal hex string " + string);
            }
            StringBuilder magic = new StringBuilder("\u00a7x");
            for (char c : string.substring(1).toCharArray()) {
                magic.append('\u00a7').append(c);
            }
            return new CompChatColor(string, magic.toString(), rgb);
        }
        if (string.length() == 2) {
            if (string.charAt(0) != '&') {
                throw new IllegalArgumentException("Invalid syntax, please use & + color code. Got: " + string);
            }
            CompChatColor byChar = BY_CHAR.get(Character.valueOf(string.charAt(1)));
            if (byChar != null) {
                return byChar;
            }
        } else {
            CompChatColor byName = BY_NAME.get(string.toUpperCase(Locale.ROOT));
            if (byName != null) {
                return byName;
            }
            if (string.equalsIgnoreCase("magic")) {
                return MAGIC;
            }
        }
        throw new IllegalArgumentException("Could not parse CompChatColor " + string);
    }

    private static Color getColorFromHex(String hex) {
        return new Color(Integer.parseInt(hex.substring(1, 3), 16), Integer.parseInt(hex.substring(3, 5), 16), Integer.parseInt(hex.substring(5, 7), 16));
    }

    public static CompChatColor getClosestLegacyColor(Color color) {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_16)) {
            int i;
            if (color.getAlpha() < 128) {
                return null;
            }
            int index = 0;
            double best = -1.0;
            for (i = 0; i < LEGACY_COLORS.length; ++i) {
                if (!CompChatColor.areSimilar(LEGACY_COLORS[i], color)) continue;
                return CompChatColor.getColors().get(i);
            }
            for (i = 0; i < LEGACY_COLORS.length; ++i) {
                double distance = CompChatColor.getDistance(color, LEGACY_COLORS[i]);
                if (!(distance < best) && best != -1.0) continue;
                best = distance;
                index = i;
            }
            return CompChatColor.getColors().get(index);
        }
        return CompChatColor.of(color);
    }

    private static boolean areSimilar(Color first, Color second) {
        return Math.abs(first.getRed() - second.getRed()) <= 5 && Math.abs(first.getGreen() - second.getGreen()) <= 5 && Math.abs(first.getBlue() - second.getBlue()) <= 5;
    }

    private static double getDistance(Color first, Color second) {
        double rmean = (double)(first.getRed() + second.getRed()) / 2.0;
        double r = first.getRed() - second.getRed();
        double g = first.getGreen() - second.getGreen();
        int b = first.getBlue() - second.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + 4.0 * g * g + weightB * (double)b * (double)b;
    }

    public static CompChatColor[] values() {
        return BY_CHAR.values().toArray(new CompChatColor[BY_CHAR.values().size()]);
    }

    public static List<CompChatColor> getColors() {
        return Arrays.asList(BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE);
    }

    public static List<CompChatColor> getDecorations() {
        return Arrays.asList(MAGIC, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC);
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }
}

