/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import sk.adonikeoffice.epicchat.lib.Common;

public enum CompBarStyle {
    SOLID("SOLID", "SOLID"),
    SEGMENTED_6("SEGMENTED_6", "SEG6"),
    SEGMENTED_10("SEGMENTED_10", "SEG10"),
    SEGMENTED_12("SEGMENTED_12", "SEG12"),
    SEGMENTED_20("SEGMENTED_20", "SEG20");

    private final String key;
    private final String shortKey;

    public static CompBarStyle fromKey(String key) {
        for (CompBarStyle mode : CompBarStyle.values()) {
            if (!mode.key.equalsIgnoreCase(key) && !mode.shortKey.equalsIgnoreCase(key)) continue;
            return mode;
        }
        throw new IllegalArgumentException("No such CompBarStyle: " + key + ". Available: " + Common.join(CompBarStyle.values()));
    }

    public String toString() {
        return this.key;
    }

    private CompBarStyle(String key, String shortKey) {
        this.key = key;
        this.shortKey = shortKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getShortKey() {
        return this.shortKey;
    }
}

