/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import java.lang.reflect.Method;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;

public enum CompAttribute {
    GENERIC_MAX_HEALTH("generic.maxHealth", "maxHealth"),
    GENERIC_FOLLOW_RANGE("generic.followRange", "FOLLOW_RANGE"),
    GENERIC_KNOCKBACK_RESISTANCE("generic.knockbackResistance", "c"),
    GENERIC_MOVEMENT_SPEED("generic.movementSpeed", "MOVEMENT_SPEED"),
    GENERIC_FLYING_SPEED("generic.flyingSpeed"),
    GENERIC_ATTACK_DAMAGE("generic.attackDamage", "ATTACK_DAMAGE"),
    GENERIC_ATTACK_SPEED("generic.attackSpeed"),
    GENERIC_ARMOR("generic.armor"),
    GENERIC_ARMOR_TOUGHNESS("generic.armorToughness"),
    GENERIC_LUCK("generic.luck"),
    HORSE_JUMP_STRENGTH("horse.jumpStrength"),
    ZOMBIE_SPAWN_REINFORCEMENTS("zombie.spawnReinforcements");

    private final String minecraftName;
    private String genericFieldName;

    private CompAttribute(String name, String genericFieldName) {
        this.minecraftName = name;
        this.genericFieldName = genericFieldName;
    }

    public final boolean hasLegacy() {
        return this.genericFieldName != null;
    }

    public final Double get(LivingEntity entity) {
        try {
            AttributeInstance instance = entity.getAttribute(Attribute.valueOf((String)this.toString()));
            return instance != null ? Double.valueOf(instance.getBaseValue()) : null;
        }
        catch (IllegalArgumentException | NoClassDefFoundError | NoSuchMethodError ex) {
            try {
                return this.hasLegacy() ? Double.valueOf(this.getLegacy((Entity)entity)) : null;
            }
            catch (NullPointerException exx) {
                return null;
            }
            catch (Throwable t) {
                if (MinecraftVersion.equals(MinecraftVersion.V.v1_8)) {
                    t.printStackTrace();
                }
                return null;
            }
        }
    }

    public final void set(LivingEntity entity, double value) {
        block7: {
            Valid.checkNotNull(entity, "Entity cannot be null");
            Valid.checkNotNull(entity, "Attribute cannot be null");
            try {
                AttributeInstance instance = entity.getAttribute(Attribute.valueOf((String)this.toString()));
                instance.setBaseValue(value);
            }
            catch (NoClassDefFoundError | NoSuchMethodError | NullPointerException ex) {
                if (this == GENERIC_MAX_HEALTH) {
                    entity.setMaxHealth(value);
                }
                try {
                    if (this.hasLegacy()) {
                        this.setLegacy((Entity)entity, value);
                    }
                }
                catch (Throwable t) {
                    if (MinecraftVersion.equals(MinecraftVersion.V.v1_8)) {
                        t.printStackTrace();
                    }
                    if (!(t instanceof NullPointerException)) break block7;
                    throw new FoException("Attribute " + (Object)((Object)this) + " cannot be set for " + entity);
                }
            }
        }
    }

    private double getLegacy(Entity entity) {
        return (Double)ReflectionUtil.invoke("getValue", this.getLegacyAttributeInstance(entity), new Object[0]);
    }

    private void setLegacy(Entity entity, double value) {
        Object instance = this.getLegacyAttributeInstance(entity);
        ReflectionUtil.invoke(ReflectionUtil.getMethod(instance.getClass(), "setValue", Double.TYPE), instance, value);
    }

    private Object getLegacyAttributeInstance(Entity entity) {
        Object iAttribute;
        Object nmsEntity = ReflectionUtil.invoke("getHandle", (Object)entity, new Object[0]);
        Class<?> genericAttribute = ReflectionUtil.getNMSClass("GenericAttributes", "net.minecraft.world.entity.ai.attributes.GenericAttributes");
        try {
            iAttribute = ReflectionUtil.getStaticFieldContent(genericAttribute, this.genericFieldName);
        }
        catch (Throwable t) {
            iAttribute = ReflectionUtil.getStaticFieldContent(genericAttribute, this.minecraftName);
        }
        Class<?> nmsLiving = ReflectionUtil.getNMSClass("EntityLiving", "N/A");
        Method method = ReflectionUtil.getMethod(nmsLiving, "getAttributeInstance", ReflectionUtil.getNMSClass("IAttribute", "N/A"));
        Object ret = ReflectionUtil.invoke(method, nmsEntity, iAttribute);
        return ret;
    }

    private CompAttribute(String minecraftName) {
        this.minecraftName = minecraftName;
    }

    public String getMinecraftName() {
        return this.minecraftName;
    }
}

