/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

class BungeeChatProvider {
    BungeeChatProvider() {
    }

    static void sendComponent(CommandSender sender, Object comps) {
        if (comps instanceof TextComponent) {
            BungeeChatProvider.sendComponent0(sender, new BaseComponent[]{(TextComponent)comps});
        } else {
            BungeeChatProvider.sendComponent0(sender, (BaseComponent[])comps);
        }
    }

    private static void sendComponent0(CommandSender sender, BaseComponent ... comps) {
        StringBuilder plainMessage = new StringBuilder();
        for (BaseComponent comp : comps) {
            plainMessage.append(comp.toLegacyText().replaceAll("\u00a7x", ""));
        }
        if (!(sender instanceof Player)) {
            BungeeChatProvider.tell0(sender, plainMessage.toString());
            return;
        }
        try {
            if (MinecraftVersion.equals(MinecraftVersion.V.v1_7)) {
                Class<?> chatBaseComponentClass = ReflectionUtil.getNMSClass("IChatBaseComponent", "N/A");
                Class<?> packetClass = ReflectionUtil.getNMSClass("PacketPlayOutChat", "N/A");
                Object chatBaseComponent = Remain.toIChatBaseComponent(comps);
                Object packet = ReflectionUtil.instantiate(ReflectionUtil.getConstructor(packetClass, chatBaseComponentClass), chatBaseComponent);
                Remain.sendPacket((Player)sender, packet);
            } else {
                ((Player)sender).spigot().sendMessage(comps);
            }
        }
        catch (Throwable ex) {
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7) && !Bukkit.getName().contains("Cauldron")) {
                Common.throwError(ex, "Failed to send component: " + plainMessage.toString() + " to " + sender.getName());
            }
            BungeeChatProvider.tell0(sender, plainMessage.toString());
        }
    }

    private static void tell0(CommandSender sender, String msg) {
        Valid.checkNotNull(sender, "Sender cannot be null");
        if (msg.isEmpty() || "none".equals(msg)) {
            return;
        }
        String stripped = msg.startsWith("[JSON]") ? msg.replaceFirst("\\[JSON\\]", "").trim() : msg;
        for (String part : stripped.split("\n")) {
            sender.sendMessage(part);
        }
    }
}

