/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.remain;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompToastStyle;

class AdvancementAccessor {
    private final NamespacedKey key = new NamespacedKey((Plugin)SimplePlugin.getInstance(), UUID.randomUUID().toString());
    private final String icon;
    private final String message;
    private final CompToastStyle toastStyle;

    AdvancementAccessor(String message, String icon, CompToastStyle toastStyle) {
        this.message = message;
        this.icon = icon;
        this.toastStyle = toastStyle;
    }

    public void show(Player player) {
        this.loadAdvancement();
        this.grantAdvancement(player);
        Common.runLater(10, () -> {
            this.revokeAdvancement(player);
            this.removeAdvancement();
        });
    }

    private void loadAdvancement() {
        Bukkit.getUnsafe().loadAdvancement(this.key, this.compileJson0());
    }

    private String compileJson0() {
        JsonObject json = new JsonObject();
        JsonObject icon = new JsonObject();
        icon.addProperty("item", this.icon);
        JsonObject display = new JsonObject();
        display.add("icon", (JsonElement)icon);
        display.addProperty("title", this.message);
        display.addProperty("description", "");
        display.addProperty("background", "minecraft:textures/gui/advancements/backgrounds/adventure.png");
        display.addProperty("frame", this.toastStyle.getKey());
        display.addProperty("announce_to_chat", Boolean.valueOf(false));
        display.addProperty("show_toast", Boolean.valueOf(true));
        display.addProperty("hidden", Boolean.valueOf(true));
        JsonObject criteria = new JsonObject();
        JsonObject trigger = new JsonObject();
        trigger.addProperty("trigger", "minecraft:impossible");
        criteria.add("impossible", (JsonElement)trigger);
        json.add("criteria", (JsonElement)criteria);
        json.add("display", (JsonElement)display);
        return new Gson().toJson((JsonElement)json);
    }

    private void grantAdvancement(Player plazer) {
        Advancement adv = this.getAdvancement();
        AdvancementProgress progress = plazer.getAdvancementProgress(adv);
        if (!progress.isDone()) {
            progress.getRemainingCriteria().forEach(crit -> progress.awardCriteria(crit));
        }
    }

    private void revokeAdvancement(Player plazer) {
        Advancement adv = this.getAdvancement();
        AdvancementProgress prog = plazer.getAdvancementProgress(adv);
        if (prog.isDone()) {
            prog.getAwardedCriteria().forEach(crit -> prog.revokeCriteria(crit));
        }
    }

    private void removeAdvancement() {
        Bukkit.getUnsafe().removeAdvancement(this.key);
    }

    private Advancement getAdvancement() {
        return Bukkit.getAdvancement((NamespacedKey)this.key);
    }
}

