/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.region;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.ClickType;
import sk.adonikeoffice.epicchat.lib.BlockUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;

public class Region
implements ConfigSerializable {
    private String name;
    private Location primary;
    private Location secondary;

    public Region(Location primary, Location secondary) {
        this(null, primary, secondary);
    }

    public Region(String name, Location primary, Location secondary) {
        this.name = name;
        if (primary != null) {
            Valid.checkNotNull(primary.getWorld(), "Primary location lacks a world!");
            this.primary = primary;
        }
        if (secondary != null) {
            Valid.checkNotNull(secondary.getWorld(), "Primary location lacks a world!");
            this.secondary = secondary;
        }
    }

    private Location[] getCorrectedPoints() {
        if (this.primary == null || this.secondary == null) {
            return null;
        }
        Valid.checkBoolean(this.primary.getWorld().getName().equals(this.secondary.getWorld().getName()), "Points must be in one world! Primary: " + this.primary + " != secondary: " + this.secondary, new Object[0]);
        int x1 = this.primary.getBlockX();
        int x2 = this.secondary.getBlockX();
        int y1 = this.primary.getBlockY();
        int y2 = this.secondary.getBlockY();
        int z1 = this.primary.getBlockZ();
        int z2 = this.secondary.getBlockZ();
        Location primary = this.primary.clone();
        Location secondary = this.secondary.clone();
        primary.setX((double)Math.min(x1, x2));
        primary.setY((double)Math.min(y1, y2));
        primary.setZ((double)Math.min(z1, z2));
        secondary.setX((double)Math.max(x1, x2));
        secondary.setY((double)Math.max(y1, y2));
        secondary.setZ((double)Math.max(z1, z2));
        return new Location[]{primary, secondary};
    }

    public final Location getCenter() {
        Valid.checkBoolean(this.isWhole(), "Cannot perform getCenter on a non-complete region: " + this.toString(), new Object[0]);
        Location[] centered = this.getCorrectedPoints();
        Location primary = centered[0];
        Location secondary = centered[1];
        return new Location(primary.getWorld(), (primary.getX() + secondary.getX()) / 2.0, (primary.getY() + secondary.getY()) / 2.0, (primary.getZ() + secondary.getZ()) / 2.0);
    }

    public final boolean hasPrimary() {
        return this.primary != null;
    }

    public final boolean hasSecondary() {
        return this.secondary != null;
    }

    public final boolean isPrimary(Location location) {
        return this.primary != null && Valid.locationEquals(this.primary, location);
    }

    public final boolean isSecondary(Location location) {
        return this.secondary != null && Valid.locationEquals(this.secondary, location);
    }

    public final Location getPrimary() {
        return this.primary == null ? null : this.primary.clone();
    }

    public final Location getSecondary() {
        return this.secondary == null ? null : this.secondary.clone();
    }

    public final List<Block> getBlocks() {
        Valid.checkBoolean(this.isWhole(), "Cannot perform getBlocks on a non-complete region: " + this.toString(), new Object[0]);
        Location[] centered = this.getCorrectedPoints();
        return BlockUtil.getBlocks(centered[0], centered[1]);
    }

    public final Set<Location> getBoundingBox() {
        Valid.checkBoolean(this.isWhole(), "Cannot perform getBoundingBox on a non-complete region: " + this.toString(), new Object[0]);
        return BlockUtil.getBoundingBox(this.primary, this.secondary);
    }

    public final List<Entity> getEntities() {
        Valid.checkBoolean(this.isWhole(), "Cannot perform getEntities on a non-complete region: " + this.toString(), new Object[0]);
        LinkedList<Entity> found = new LinkedList<Entity>();
        Location[] centered = this.getCorrectedPoints();
        Location primary = centered[0];
        Location secondary = centered[1];
        int xMin = (int)primary.getX() >> 4;
        int xMax = (int)secondary.getX() >> 4;
        int zMin = (int)primary.getZ() >> 4;
        int zMax = (int)secondary.getZ() >> 4;
        for (int cx = xMin; cx <= xMax; ++cx) {
            for (int cz = zMin; cz <= zMax; ++cz) {
                for (Entity entity : this.getWorld().getChunkAt(cx, cz).getEntities()) {
                    if (!entity.isValid() || entity.getLocation() == null || !this.isWithin(entity.getLocation())) continue;
                    found.add(entity);
                }
            }
        }
        return found;
    }

    public final World getWorld() {
        if (!this.isWhole()) {
            return null;
        }
        if (this.primary != null && this.secondary == null) {
            return Bukkit.getWorld((String)this.primary.getWorld().getName());
        }
        if (this.secondary != null && this.primary == null) {
            return Bukkit.getWorld((String)this.secondary.getWorld().getName());
        }
        Valid.checkBoolean(this.primary.getWorld().getName().equals(this.secondary.getWorld().getName()), "Worlds of this region not the same: " + this.primary.getWorld() + " != " + this.secondary.getWorld(), new Object[0]);
        return Bukkit.getWorld((String)this.primary.getWorld().getName());
    }

    public final boolean isWithin(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        Valid.checkBoolean(this.isWhole(), "Cannot perform isWithin on a non-complete region: " + this.toString(), new Object[0]);
        if (!location.getWorld().getName().equals(this.primary.getWorld().getName())) {
            return false;
        }
        Location[] centered = this.getCorrectedPoints();
        Location primary = centered[0];
        Location secondary = centered[1];
        int x = (int)location.getX();
        int y = (int)location.getY();
        int z = (int)location.getZ();
        return (double)x >= primary.getX() && (double)x <= secondary.getX() && (double)y >= primary.getY() && (double)y <= secondary.getY() && (double)z >= primary.getZ() && (double)z <= secondary.getZ();
    }

    public final boolean isWithinXZ(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        Valid.checkBoolean(this.isWhole(), "Cannot perform isWithinXZ on a non-complete region: " + this.toString(), new Object[0]);
        if (!location.getWorld().getName().equals(this.primary.getWorld().getName())) {
            return false;
        }
        Location[] centered = this.getCorrectedPoints();
        Location primary = centered[0];
        Location secondary = centered[1];
        int x = (int)location.getX();
        int z = (int)location.getZ();
        return (double)x >= primary.getX() && (double)x <= secondary.getX() && (double)z >= primary.getZ() && (double)z <= secondary.getZ();
    }

    public final boolean isWhole() {
        return this.primary != null && this.secondary != null;
    }

    public final void setPrimary(Location primary) {
        this.primary = primary;
    }

    public final void setSecondary(Location secondary) {
        this.secondary = secondary;
    }

    public final void setLocation(Location location, ClickType click) {
        this.setLocation(location, click, false);
    }

    public final void updateLocation(@Nullable Location primary, @Nullable Location secondary) {
        if (primary != null) {
            this.setPrimary(primary);
        }
        if (secondary != null) {
            this.setSecondary(secondary);
        }
    }

    public final boolean toggleLocation(Location location, ClickType click) {
        return this.setLocation(location, click, true);
    }

    private boolean setLocation(Location location, ClickType click, boolean toggle) {
        boolean isPrimary;
        boolean bl = isPrimary = click == ClickType.LEFT;
        if (isPrimary) {
            if (location == null || this.hasPrimary() && this.isPrimary(location) && toggle) {
                this.setPrimary(null);
                return false;
            }
            this.setPrimary(location);
            return true;
        }
        if (location == null || this.hasSecondary() && this.isSecondary(location) && toggle) {
            this.setSecondary(null);
            return false;
        }
        this.setSecondary(location);
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Region) {
            Region otherRegion = (Region)obj;
            if (otherRegion.name != null && this.name == null || otherRegion.name == null && this.name != null) {
                return false;
            }
            if (otherRegion.name != null && !otherRegion.name.equals(this.name) || otherRegion.name != null && !this.name.equals(otherRegion.name)) {
                return false;
            }
            return Valid.locationEquals(otherRegion.getPrimary(), this.primary) && Valid.locationEquals(otherRegion.getSecondary(), this.secondary);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.primary, this.secondary);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ",location=" + Common.shortLocation(this.primary) + " - " + Common.shortLocation(this.secondary) + "}";
    }

    @Override
    public final SerializedMap serialize() {
        SerializedMap map = new SerializedMap();
        map.putIfExist("Name", this.name);
        map.putIfExist("Primary", this.primary);
        map.putIfExist("Secondary", this.secondary);
        return map;
    }

    public static Region deserialize(SerializedMap map) {
        Valid.checkBoolean(map.containsKey("Primary") && map.containsKey("Secondary"), "The region must have Primary and a Secondary location", new Object[0]);
        String name = map.getString("Name");
        Location prim = map.getLocation("Primary");
        Location sec = map.getLocation("Secondary");
        return new Region(name, prim, sec);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

